function ptraj = preprocessposition(traj, faceindexstart, faceindexend)
%lefthand x:1 y:2  ---  righthand x:3 y:4
%face RLU:faceindexstart CLU:faceindexstart+1
%face RRD:faceindexstart+3 CRD:faceindexstart+4
ylu = faceindexstart;
xlu = faceindexstart+1;
yrd = faceindexstart+2;
xrd = faceindexstart+3;

num_traj = size(traj,1);
ptraj = cell(num_traj, 1);
% normalize the distance btw face and each hand by the face width
for (t = 1:num_traj)
	tempArr = traj{t,1};
	num_points = size(tempArr,2);
    num_features = size(tempArr,1);
	for j=1:num_points
        % downsize the coords
        tempArr(faceindexstart:faceindexend,j) =  tempArr(faceindexstart:faceindexend,j)/2;
        %calculate the face CoM in smaller sized image
        fcomx = (tempArr(xlu,j)+tempArr(xrd,j))/2;
        fcomy = (tempArr(ylu,j)+tempArr(yrd,j))/2;
        % calculate face width and height
        fw = (tempArr(xrd,j)-tempArr(xlu,j));
        fh = (tempArr(yrd,j)+tempArr(ylu,j));        
        %calculate dyLeft, dxLeft, dyRight, dxRight
        tempArr(ylu,j) = (tempArr(1,j)-fcomx)/fw/10;
        tempArr(xlu,j) = (tempArr(2,j)-fcomy)/fh/10;
        tempArr(yrd,j) = (tempArr(3,j)-fcomx)/fw/10;
        tempArr(xrd,j) = (tempArr(4,j)-fcomy)/fh/10;
    end
    ptraj{t,1} = tempArr;
end