function ptraj = preprocesstrajectory(traj, zerovalueindex, shapeindexstart, shapeindexend, nohandcount, transitioncount)
% crop the 0s at the beginning and at the end of the trajectory
% Give no hand count as 0 if there are no 0s at the end

num_traj = size(traj,1);
ptraj = cell(num_traj, 1);
%si = zerovalueindex(end)+1; % shape feature start index
% for the hand shape information coming from pavel
% there is no data if the hand is not seen. Fill in those empty parts
for (t = 1:num_traj)
	tempArr = traj{t,1};
	num_points = size(tempArr,2);
    num_features = size(tempArr,1);
	mdata = zeros(num_features, num_points);
    new_num = 1;
    countendzeros = 0;
	for j=1:num_points
        if (sum(tempArr(zerovalueindex,j))~=0)
            if (sum(tempArr(shapeindexstart:2:shapeindexend,j))==0)
                tempArr(shapeindexstart:2:shapeindexend,j) = tempArr(shapeindexstart:2:shapeindexend,j-1);
            end
            if (sum(tempArr(shapeindexstart+1:2:shapeindexend,j))==0)
                tempArr(shapeindexstart+1:2:shapeindexend,j) = tempArr(shapeindexstart+1:2:shapeindexend,j-1);
            end            
            mdata(:,new_num) = tempArr(:,j);
            new_num = new_num + 1;
            countendzeros = 0;
        else
            countendzeros =  countendzeros + 1;
        end
    end
    if (countendzeros>0)
        ptraj{t,1} = mdata(:,transitioncount+1:new_num-1-nohandcount-transitioncount);
    else
        ptraj{t,1} = mdata(:,transitioncount+1:new_num-1-round(nohandcount/3*2)-transitioncount);
    end
end