function [alld] = readTrajShapeSEQ(trajfile, shapefile)
% read features for 1 seq from files
fid1 = fopen([trajfile], 'r');
fid2 = fopen([shapefile], 'r');
vectorsize1 = 14;
vectorsize2 = 38;
newvectorsize = 66;
alld.data = {};
lastclass = 0;

    seqline = fgetl(fid1);
    tempseq1 = sscanf(seqline, '%f', [vectorsize1 inf]);
    seqline = fgetl(fid2);
    tempseq2 = sscanf(seqline, '%f', [vectorsize2 inf]);
        %tempseq1(traj+shape):    Lx Ly Lvx Lvy Rx Ry Rvx Rvy 1-8
        %                   Lh Lw La Rh Rw Ra           9-14
        %                   Lh1 Lh2 Lh3 Lh4 Lh5 Lh6 Lh7 15-21
        %                   Rh1 Rh2 Rh3 Rh4 Rh5 Rh6 Rh7 22-28
        %tempseq2(shape):   L1 ... L19 1-19
        %                   R1 ... R19 20-38
    num_points = size(tempseq1,2);
    seq = zeros(newvectorsize, num_points);
    for j=1:num_points
        seqvectorsize1 = vectorsize1+14;
        seq(1:seqvectorsize1,j) = [tempseq1(1:2,j); tempseq1(5:6,j); tempseq1(3:4,j); tempseq1(7:8,j); tempseq1(9:10,j); tempseq1(12:13,j); tempseq1(11,j); tempseq1(14,j); zeros(length(15:28),1)];
        temp = [];
        for (k=1:19)
            temp = [temp; tempseq2(k,j);tempseq2(k+19,j)];
        end
        seq(seqvectorsize1+1:newvectorsize,j) = temp;    
    end
    alld.data{1,1} = seq';
    
fclose(fid1); 
fclose(fid2); 

