function [transmat, prior, sigma, mu, mixmat] = rnd_leftrightHMMcont(data, N, M, V)
% function [transmat, obsmat, prior] = rnd_leftrightHMM(N)
% N = num states M=number of gaussians V=vector size

p = rand(N-1,1); %p + (1-p) = 1
transmat = diag([p;1].* ones(N,1)) + diag((1-p).* ones(N-1,1),1);
%transmat(N,N)=1;
%prior = (1 / N) * ones(N,1);
prior = zeros(N,1);
prior(1) = 1;


sigma = repmat(eye(V), [1 1 N M]);

% Initialize each mean to a random data point
alldata = [];
for i=1:size(data)
	alldata = [alldata data{i}];
end
indices = randperm(length(alldata));
mu = reshape(alldata(:,indices(1:(N*M))), [V N M]);

if (M==1)
    mixmat = [];
else
    mixmat = mk_stochastic(rand(N,M));
end
