%function [mtr] = setstartpos(tr)
function [mtr] = setstartpos(tr, posind)
%posind is the end index of the position features : for features 1:posind, starting
%position will be set to 0
if (nargin==1)
    posind = size(tr{1,1},1);
end
num_trajectory = size(tr,1);
mtr = cell(num_trajectory, 1);
for (t = 1:num_trajectory)
	tempArr = tr{t,1};
	num_points = size(tempArr,2);
	mdata = zeros(posind, num_points-1);
	for j=1:num_points-1
		mdata(1:posind,j) = tempArr(1:posind,j+1) - tempArr(1:posind,j);
    end
	mtr{t,1} = [zeros(posind,1) cumsum(mdata,2); tempArr(posind+1:end,:)];
end
