%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier 
 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%  
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
 
% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.
 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test program that analyses local motion in a video using a Spatio
% Temporal retinal filter %
% This version uses a gabor rosace to compute the LogPolar conversion...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%profile on
%function Finish = YesNoFinder(a)

Finish = 0;
% general variables
global Att2DWindow NBangles NBradius movie CorrelationMovie FrameComputingTime

% coordinates of the 2 extrema defining the region of interest box
global ROI_RowMin ROI_RowMax ROI_ColumnMin ROI_ColumnMax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% matlab Init
clc
%clear all
%close all
clear mex

if exist('LogPolTransfoMatrixPixList','var')
    clear LogPolTransfoMatrixPixList;
end

if exist('LogPolTransfoMatrixPixCoef','var')
    clear LogPolTransfoMatrixPixCoef;
end 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% variables manual init

    DemoMode = 0; % set display mode : 1 = demo mode, 0 = experimental dispqly mode
    WebcamVideoMode = 0; % sets the video strem input style (1:realtime input, else, videofile
    SaveVideoOutput = 0; % if 1 : then an output video file is generated (requires much processing power, disk access...)
    
    MotionDisplay=0;% no motion is displayed in this algo
    FPSmeanRecordedVideo = 25;
    
    InterpretationDisplay=1; %  if 1 : display the interpretation figures on thge 'live' window
    
    %%%%%%%%%%%%%%%%%%%%%%%
    % general detection parameters
    ActivateNoiseMean =1; % set to 0 if no need to take care of the spatioTemporal noise, set to 1 else
    NoiseMeanInitDuration=20;
    SignificantNumberOfFrames_EyeLevels = 2;

    %%%%%%%%%%%%%%%%%%%%%%%
    UseSpectrum = 1;    % use 1 if spectrum has to be computed
    ActivateSalency =0;      % use 1 if Salency has to be computed
    % MoviePicture Index (start/stop)
    MovieStart = 1;
    MovieStop = 100000;
    MovieStep = 1;
    
  
    % Initialisation parameters
    MinRadius = 0.02;%0.1
    MaxRadius = 0.3;%0.45
    FilterPrecision = 100;
    NBangles = 15;%45;35;55
    NBradius = 7;%31;15;35
    AnglesWindowHalfSize=5;
    
    AngleAxis = (1:1:NBangles)';
    FreqAxis = 1:1:NBradius;
    
    %%%%%%%%%%%%%%%%%%%%%%%
    % concerning MotionType detection
    
    if SaveVideoOutput ==1
        % Creat a movie file to record the computed correlation
        CorrelationMovie = avifile('MovieAnalyseRotations.avi');
        CorrelationMovie.compression = 'none';
    end

    FirstStageInit
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialising each filter

    %%%% SpatioTemporal Filtering Init : first retina filter (just after frame read)
    beta_1 =0;  %   bon :0
    tau_1 = 0.6;  %   bon :1
    k_1 = 0.5;    %   bon :5
    
    beta_2 =0;%   bon :0.1
    tau_2 = 0.6;  %   bon :2
    k_2 = 8;    %   bon :6
    % Init Standart Retina Filter (First Retina Filtering)
    FirstRetinaCoefTable = InitRealRetinaFilter(beta_1, tau_1, k_1, beta_2, tau_2, k_2);
    
    PhotoreceptorsCoefTable=InitSpatialLPFilter( 0, tau_1/2, k_2);
    
     % Init LP spatial filter used for ON and OFF outputs filtering
    SpatialLPFilterCoefs = InitSpatialLPFilter( (beta_1+beta_2)/2, tau_1, k_1);
    SpatialLPFilterCoefs_Wide = InitSpatialLPFilter( 0.00, tau_1*0, k_2);
    SpatialLPFilterCoefs_VeryWide = InitSpatialLPFilter( 0.00, tau_1*0, 3*k_2);
                   
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%% Velocity Filters Init Starting %%%%%%%%%%%%%
        
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%% SpatioTemporalVelocity Filtering Init
    
    % specify the number of velocity filters
    NbVelocityFilters = 5;
        
	% create the table that specifies the orientation of the filters :
	VelocityOrientation = zeros(NbVelocityFilters,1);
    % filling the orientation table : 0 means horizontal velocity filter
	VelocityOrientation(1) = 0; % => not oriented filter... so the orientation is arbitrary...
	VelocityOrientation(2) = 0;
	VelocityOrientation(3) = 0;
	VelocityOrientation(4) = 1;
	VelocityOrientation(5) = 1;
	
    betaVelocity = 2; %default value = 0 ; 2
    tauVelocity = 3; %default value = 6 ; 0.9
    kVelocity = 2; %default value = 3  ;1.2
    
    a=1.9;
    b=2-a;
    
    % Init Velocity Retina Filters    => InitSpatialRetinaFilter(beta, tau, k, m_a, m_b)
    ZeroVelocity = InitRetinaVelocityFilter         (betaVelocity, tauVelocity, kVelocity, 1, 1);
    MaxFreqSlideVelocity = InitRetinaVelocityFilter (betaVelocity, tauVelocity, kVelocity, a, b);
    MinFreqSlideVelocity = InitRetinaVelocityFilter (betaVelocity, tauVelocity, kVelocity, b, a);
    MaxAngleSlideMaxVelocity =      InitRetinaVelocityFilter    (betaVelocity, tauVelocity, kVelocity, a, b);
    MinAngleFreqSlideMaxVelocity =  InitRetinaVelocityFilter    (betaVelocity, tauVelocity, kVelocity, b, a);
    
        
    VelocityCoefTables = [  ZeroVelocity
                            MaxFreqSlideVelocity
                            MinFreqSlideVelocity
                            MaxAngleSlideMaxVelocity
                            MinAngleFreqSlideMaxVelocity
                        ];
                            
    %%%%%%%%%%%%%%%%
    % loop variables pre init
    CurrentVelocities = zeros(Nrows, Mcolumns, NbVelocityFilters);
    FilteredOrientedVelocities = zeros(Nrows, Mcolumns, NbVelocityFilters);
    Velocities = zeros(Nrows, Mcolumns, NbVelocityFilters);
    VelocitiesInitTable = zeros(Nrows, Mcolumns);
    %%%%%%%%%%%%%%%%
    
    fs=-0.5:0.01:0.5;
    fs = repmat(fs, [101 1]);
    ft=fs';
    
    Gfxft=1./(1 + 2*kVelocity*kVelocity*[1-cos(2*pi*fs)] + i*2*pi*tauVelocity*(ft + kVelocity*kVelocity*(b-1)/(pi*tauVelocity)*sin(2*pi*fs)));
    figure
    surf(fs, fs', abs(Gfxft))
    shading interp
    xlabel('Fs');
    ylabel('Ft');
    zlabel('G(fx,ft)')
   %%%%%%%%%%%%%%%%%

    % Init Resistive Network (placed at the output of the Velocity filters, Input = k, beta+tau, inj, tau=0)
    ResistiveNetworkCoefs = InitResistiveNetwork(50, 0, 1, 0.0);
    
    Orientation_EstimatedVelocity = zeros(Nrows, Mcolumns);
    Frequency_EstimatedVelocity = zeros(Nrows, Mcolumns);
        
   %%%%%%%%%%%% Velocity Filters Init End%%%%%%%%%%%%
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
   SpectrumAnalysisInit
    
   SecondStageInit
   
   CurrentFrame=2;
   
    while CurrentFrame < MovieStop
        
        t0 = cputime;
    
    
    %%%% SpatioTemporal filtering video Loop
      %tic  
        % Current Picture Read&Init
            % Reference picture reading
            if WebcamVideoMode == 1
                %AcquiredPicture = vfm('grab');
                AcquiredPicture = vcapg2;
            else
                AcquiredPicture = movie(CurrentFrame).cdata;
            end
            
            %Selecting ROI
            CurrentRGBpic =  AcquiredPicture(ROI_RowMin:ROI_RowMax, ROI_ColumnMin:ROI_ColumnMax,:);
             
            CurrentPicture = RGB2grayC(CurrentRGBpic);

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % First stage sptial Retinal prefiltering
        	
            % Photoreceptors compression
            PhotoreceptorsCompression(CurrentPicture, PhotoreceptorsOutput, Nrows, Mcolumns, PhotoreceptorsCoefTable); 

            % Retina B model filtering
            RealSpatialRetinaFilter_OnOff(PhotoreceptorsOutput, RetinaFirstStageOutput, RetinaSecondStageOutput, RetinaOutput_ON, RetinaOutput_OFF, Nrows, Mcolumns, FirstRetinaCoefTable);
            
            % compute low pass filter on On and OFF outputs before temporal
            % high pass filtering
            SpatioTemporalSquaringLPFilter(RetinaOutput_ON, RetinaOutput_ON_LP, Nrows, Mcolumns, SpatialLPFilterCoefs); 
            SpatioTemporalSquaringLPFilter(RetinaOutput_OFF, RetinaOutput_OFF_LP, Nrows, Mcolumns, SpatialLPFilterCoefs); 
            
            EnergyLocalization = RetinaOutput_ON_LP + RetinaOutput_OFF_LP;
            RetinaOutput=RetinaOutput_ON_LP-RetinaOutput_OFF_LP;
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % temporal derivative ... more instable but efficient
            IPLFilter(EnergyLocalization, AmacrinCellsTempOutput, MagnoXOutput, MagnoYOutput, Nrows, Mcolumns, 0.04);
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%% Blinks/Yawnings detection start  %%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%% FFT computing
            OPLCurrentFFT = abs(fftshift(fft2(RetinaOutput.*HammingWindow)));
            IPLCurrentFFT = abs(fftshift(fft2(MagnoXOutput.*HammingWindow)));
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % LogPolar transform using GloP filters
            FastTransfoLogPolFunctionL_C(OPLCurrentFFT, LogPolTransfoMatrixPixList, LogPolTransfoMatrixPixCoef, NBangles, NBradius, OPLLogPolFFT, MaxListSize);
            FastTransfoLogPolFunctionL_C(IPLCurrentFFT, LogPolTransfoMatrixPixList, LogPolTransfoMatrixPixCoef, NBangles, NBradius, IPLLogPolFFT, MaxListSize);
            
            OPLShowLogPolSpectrum = OPLLogPolFFT';
            IPLShowLogPolSpectrum = IPLLogPolFFT';
                     
            % find the max value and its coordonates
            [MaxValue, IDrow]  = max(max(IPLShowLogPolSpectrum));
            [MaxValue, IDcolumn]  = max(max(IPLShowLogPolSpectrum'));
            
            MaxIndexOrientedFrequency(CurrentFrame)= IDcolumn;
            % get the oriented energie at the output of the OPL and IPL filter 
            OPLOrientedEnergie=sum(OPLShowLogPolSpectrum);
            IPLOrientedEnergie=sum(IPLShowLogPolSpectrum);
            
            % Computing the Total IPL energy
            TotalIPLEnergy(CurrentFrame) = sum(IPLOrientedEnergie);            
            TotalOPLEnergy(CurrentFrame) = sum(OPLOrientedEnergie);
            
            % estimating OPL energies         
            OPLTotalEnergyAdaptativeMean(CurrentFrame) = OPLTotalEnergyAdaptativeMean(CurrentFrame-1)*(1-OPLAdaptativeMeanSensitivity) + OPLAdaptativeMeanSensitivity*TotalOPLEnergy(CurrentFrame);
                       
           %%% Extract motion evolution
           if CurrentFrame < NoiseMeanInitDuration
               % first evaluate the noise to avoid interpretation errors
               if CurrentFrame >8
                   NoiseMeanInit = NoiseMeanInit+TotalIPLEnergy(CurrentFrame);
                   MaxIPLEnergy = NoiseMeanInit/20;
                   MaxEver = 0;
                   NoiseMean = NoiseMeanInit/12;
                   NoiseMeanMultiple=3*NoiseMean;
                   LastEyeMotionEvent = CurrentFrame;
                   EyeClosedEnergyLevel =OPLTotalEnergyAdaptativeMean(CurrentFrame);
                   EyeOpenedEnergyLevel =OPLTotalEnergyAdaptativeMean(CurrentFrame);
               end
           else
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%% Evaluating variables signification
            MaxIPLEnergy = MaxIPLEnergy*0.9; % MaxEnergy decreases in the time => be aware of all events even smallest but significant...
            MaxEver= MaxEver*0.98;
            
            if TotalIPLEnergy(CurrentFrame)-NoiseMean > NoiseMeanMultiple

                % Update the max value limit :

                MaxIPLEnergy = max(MaxIPLEnergy, TotalIPLEnergy(CurrentFrame)-NoiseMean);

                % computing maximum energy to avoid noise problem in the

                MaxEver = max(MaxIPLEnergy, MaxEver);
                alphaMaxEver = MaxIPLEnergy/MaxEver;


                alphaMaxIPLEnergy = (TotalIPLEnergy(CurrentFrame)-NoiseMean)/MaxIPLEnergy;
                alphaMaxIPLEnergy = alphaMaxIPLEnergy*alphaMaxIPLEnergy;
                alphaCurrentData = alphaMaxIPLEnergy;%*alphaMaxEver;

            else
                alphaCurrentData =0;
            end
            alphaCurrentDataHist(CurrentFrame)=alphaCurrentData;
            MaxIPLEnergyHistory(CurrentFrame) = MaxIPLEnergy;
            MaxEverHistory(CurrentFrame) = MaxEver;            
            
            %%%%%%%%%% Init part end %%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % Detecting Eye Motion/Blink:
            if alphaCurrentData < 0.5
                        EyeMotion = 'EyeStable';
                        LastStableOPLValue = OPLTotalEnergyAdaptativeMean(CurrentFrame); 
            else
                % identifying the motion orientation
                [MaxOrientedEnergy, IndexMaxOrientedEnergy] = max(IPLOrientedEnergie);
                if abs(IndexMaxOrientedEnergy - NBangles/4) < NBangles/4
                
                    EnergyGradient = (OPLTotalEnergyAdaptativeMean(CurrentFrame)-OPLTotalEnergyAdaptativeMean(CurrentFrame-1));

                    if EnergyGradient < 0
                        EyeMotion = 'ClosingEye';
                    else
                        EyeMotion = 'OpeningEye';
                    end

                    % detecting eye state
                    EyeStableFrameNumber = CurrentFrame-LastEyeMotionEvent;
                    % init for the upcoming reinitialized records
                    LastEyeMotionEvent = CurrentFrame;

                    % if there are sufficient stables frames, then compute energy levels
                    if EyeStableFrameNumber > SignificantNumberOfFrames_EyeLevels
                        % case of current energy level higher than the one
                        % during the stable period => the eye just closed
                        if OPLTotalEnergyAdaptativeMean(CurrentFrame) > TotalOPLEnergy(CurrentFrame)
                            % updating eye opened energy level
                            EyeOpenedEnergyLevel = max(LastStableOPLValue, EyeOpenClosedEnergyLimit);
                        else%if OPLTotalEnergyAdaptativeMean(CurrentFrame) < TotalOPLEnergy(CurrentFrame)
                            % updating eye opened energy level
                            EyeClosedEnergyLevel = min(LastStableOPLValue, EyeOpenClosedEnergyLimit);
                        end
                    end
                end
            end
           
            % detectting Eye State
            EyeOpenClosedEnergyLimit = (EyeClosedEnergyLevel+EyeOpenedEnergyLevel)/2;
            
            if TotalOPLEnergy(CurrentFrame) < EyeOpenClosedEnergyLimit
                EyeState='EyeClosed';
                EyeClosedEnergyLevel = EyeClosedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*min(LastStableOPLValue, EyeOpenClosedEnergyLimit);
                        
            else
                EyeState='EyeOpened';
                EyeOpenedEnergyLevel = EyeOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(LastStableOPLValue, EyeOpenClosedEnergyLimit);
                        
            end
             
            % recording values
                EyeClosedEnergyLevel_Hist(CurrentFrame) = EyeClosedEnergyLevel;
                EyeOpenedEnergyLevel_Hist(CurrentFrame) = EyeOpenedEnergyLevel;

            
            %%%  Blinks/Yawnings detection end  %%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            end % end of "if CurrentFrame < NoiseMeanInitDuration"
            
            
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%% Display and save
               
            set(RetinaOutputFigure,'cdata',gray2RGB_Hot(-RetinaOutput));
            set(IPLOutputFigure,'cdata',gray2RGB_Hot(MagnoXOutput));
            set(InterpretationFigure,'cdata', getfield(ResultPicture,EyeState));%getfield(ResultPicture,EyeState)) OR gray2RGB_Hot(PLIEdgesTable));
            set(CurrentPictureDisplay,'cdata',CurrentRGBpic); 
    
    drawnow

    if SaveVideoOutput ==1
                F=getframe(gcf);
                CorrelationMovie = addframe(CorrelationMovie,F);
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    % estimating computing time 
            LastFPS = 1/(cputime-t0+0.0001);
            FPSmean = LastFPS*alpaFPS+FPSmean*alphaFPSopp;
            FrameComputingTime(CurrentFrame - MovieStart+1)=FPSmean;
                        
            CurrentFrame = CurrentFrame+MovieStep;
    
    
    end
    %%%%%%%%% Loop END %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if SaveVideoOutput ==1
         CorrelationMovie = close(CorrelationMovie);
end


XPoints = MovieStart:MovieStep:MovieStop-1;

figure
plot(FrameComputingTime,'-g');
title('FrameRate (/sec)');


%profile report
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
BlinksYawningsGraph
Finish = 1
