%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a
% copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% compute head optical flow
% based on optical flow computed by the retina

% author Alexandre BENOIT since may 2004 benoit@lis.inpg.fr, www.lis.inpg.fr/pages_perso/benoit
% reference work : Jeanny Herault, herault@lis.inpg.fr, www.lis.inpg.fr/pages_perso/herault

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%  MOTION ESTIMATION  %%%%%%%%%%%%%%%%

%%%% first part: motion segmentation method...beta test ;o)
MagnoYEnergyMean=SpatioTemporalSquaringLPFilter(MagnoYOutput(rowStart:rowEnd, columnStart:columnEnd), MagnoYOutput_LP, velocitiesRows, velocitiesColumns, SpatialLPFilterCoefs_Wide);
SpatioTemporalLPFilter(MagnoYOutput_LP, MagnoYOutput_LP2, velocitiesRows, velocitiesColumns, SpatialLPFilterCoefs_VeryWide);
ComputeSegmentation3(PLIEdgesTable, MagnoYOutput_LP, MagnoYOutput_LP2, MagnoYEnergyMean*3);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Motion estimation, 2nd part %%%
%%%%% Compute velocities
% Mouvement detection using retina velocity filters
%% ca prend grave du temps...... ici,MagnoYOutput,RetinaOutput_ON
SpatialVelocityTunedRetina2(MagnoYOutput, FilteredOrientedVelocities, Nrows, Mcolumns, VelocityCoefTables, NbVelocityFilters, VelocityOrientation);
%%algo super bourrin
% Local Energie Computing (using Edges stop Integration method)
MultipleLocalIntegratorNetwork2(FilteredOrientedVelocities(rowStart:rowEnd, columnStart:columnEnd, :), PLIEdgesTable, Velocities, velocitiesRows, velocitiesColumns, ResistiveNetworkCoefs, NbVelocityFilters, tempMemory1, tempMemory2);
%%autre algo super bourrin
VerticalMeanVelocity = VelocityComputing(Velocities(:,:, 1), Velocities(:,:, 4), Velocities(:,:, 5), velocitiesRows, velocitiesColumns, PLIEdgesTable, V_EstimatedVelocity);
HorizontalMeanVelocity = VelocityComputing(Velocities(:,:, 1), Velocities(:,:, 2), Velocities(:,:, 3), velocitiesRows, velocitiesColumns, PLIEdgesTable, H_EstimatedVelocity);


%figure(40);quiver(HorizontalMeanVelocity,VerticalMeanVelocity);axis equal
%% fin des modifs  realiser ici...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Vmotion = sum(sum(V_EstimatedVelocity.*EnergyLocalization(rowStart:rowEnd, columnStart:columnEnd)));
%Hmotion = sum(sum(H_EstimatedVelocity.*EnergyLocalization(rowStart:rowEnd, columnStart:columnEnd)));

% determining head motion direction
HeadMotionDirection = 'UndeterminedMotion';
HeadMotionOrientation_Current=0;

HeadMotionAlert=0;

if CurrentFrame>NoiseMeanInitDuration

    % median filtering the last 3 motion events, generates the value of
    % HeadMotionAlert: 0 if 3 last frame don't show motion, 1 if motion
    CurrentHeadMotionEventTableIndex=mod(CurrentFrame, HeadMotionMedianFilterSize)+1;
    HeadMotionEventTable(CurrentHeadMotionEventTableIndex) = (FaceTotalIPLEnergy(CurrentFrame)-4*FaceNoiseMean > 0);%&& NoNonRigidMotionActiv;
    HeadMotionEvent = median(HeadMotionEventTable);

    
   
    if HeadMotionEvent

        VerticalAdaptativeMean = VerticalAdaptativeMean*alphaMotion + (1-alphaMotion)*VerticalMeanVelocity;
        HorizontalAdaptativeMean = HorizontalAdaptativeMean*alphaMotion + (1-alphaMotion)*HorizontalMeanVelocity;
        VelocityValue=sqrt(VerticalAdaptativeMean*VerticalAdaptativeMean+HorizontalAdaptativeMean*HorizontalAdaptativeMean);
        Prob1=abs(VerticalAdaptativeMean/VelocityValue);
        Prob2=abs(HorizontalAdaptativeMean/VelocityValue);
    
        % get robability of hrizontal or vertical motion with the help of
        % the velocity filters
        if Prob1>0
            VerticalProbOpticFlow=(Prob1*(1-Prob2))/(Prob1*Prob1);
        else
            VerticalProbOpticFlow=0;
        end
        if Prob2>0
            HorizontalProbOpticFlow=(Prob2*(1-Prob1))/(Prob2*Prob2);
        else
             HorizontalProbOpticFlow=0;
        end
            
        % get the same thing with the orientation filter
        Prob1=ComputeProbability(NBanglesFace/4, NBanglesFace/2, FaceOrientedEnergyMean);
        Prob2=ComputeProbability(NBanglesFace*3/4, NBanglesFace, FaceOrientedEnergyMean);

        
        % final choice
        if Prob1>0
            VerticalProb(CurrentFrame)=(Prob1*(1-Prob2))/(Prob1*Prob1+0.00001);
        else
            VerticalProb(CurrentFrame)=0;
        end
        if Prob2>0
            HorizontalProb(CurrentFrame)=(Prob2*(1-Prob1))/(Prob2*Prob2+0.00001);
        else
            HorizontalProb(CurrentFrame)=0;
        end
        
        % detecting vertical motion on the energy per orientation curve
        if abs(FaceOrientedEnergyMean - NBanglesFace/4) < NBanglesFace/4

            CurrentHeadMotionDirectionTableIndex=mod(CurrentFrame, HeadMotionDirectionMedianFilterSize)+1;
            V_HeadMotionDirectionEventTable(CurrentHeadMotionDirectionTableIndex) = sign(VerticalAdaptativeMean);
            V_HeadMotionDirectionSign = median(V_HeadMotionDirectionEventTable);

            if V_HeadMotionDirectionSign > 0
                HeadMotionDirection = 'TurnDown';
                HeadMotionAlert=1;
                HeadMotionAlertHistory(CurrentFrame)=2;
                HeadMotionOrientation_Current=2;
            elseif V_HeadMotionDirectionSign < 0
                HeadMotionDirection = 'TurnUp';
                HeadMotionAlert=1;
                HeadMotionAlertHistory(CurrentFrame)=-2;
                HeadMotionOrientation_Current=-2;
            end
            HorizontalAdaptativeMean = 0;

            % reset horizontal motion detector
            H_HeadMotionDirectionEventTable=HeadMotionDirectionEventTableInit;


        end

        % detecting horinzontal motion
        if abs(FaceOrientedEnergyMean - NBanglesFace*3/4) < NBanglesFace/4
            
            %HorizontalSpectrumOrientationProbability=(NBanglesFace/4)/abs(FaceOrientedEnergyMean - NBanglesFace*3/4)
            
            CurrentHeadMotionDirectionTableIndex=mod(CurrentFrame, HeadMotionDirectionMedianFilterSize)+1;
            H_HeadMotionDirectionEventTable(CurrentHeadMotionDirectionTableIndex) = sign(HorizontalAdaptativeMean);
            H_HeadMotionDirectionSign = median(H_HeadMotionDirectionEventTable);

            if H_HeadMotionDirectionSign < 0
                HeadMotionDirection = 'TurnLeft';
                HeadMotionAlert=1;
                HeadMotionAlertHistory(CurrentFrame)=-1;
                HeadMotionOrientation_Current=-1;
            elseif H_HeadMotionDirectionSign >0
                HeadMotionDirection = 'TurnRight';
                HeadMotionAlert=1;
                HeadMotionAlertHistory(CurrentFrame)=1;
                HeadMotionOrientation_Current=1;
            end
            VerticalAdaptativeMean = 0;


            % reset vertical motion detector
            V_HeadMotionDirectionEventTable=HeadMotionDirectionEventTableInit;

        end

        % DrawVectors

    else
        VerticalAdaptativeMean = 0;
        HorizontalAdaptativeMean = 0;

    end
    %     end
    
    
verticalVelocityHist(CurrentFrame)=VerticalAdaptativeMean;
horizontalVelocityHist(CurrentFrame)=HorizontalAdaptativeMean;

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Display and save

% HeadMotionSpeedHist(CurrentFrame) = sqrt(HorizontalMeanVelocity*HorizontalMeanVelocity+VerticalMeanVelocity*VerticalMeanVelocity);
% HeadMotionOrientationHist(CurrentFrame)=atan(VerticalMeanVelocity/HorizontalMeanVelocity)*180/pi;
