
function [PhotoreceptorsOutput RetinaOutput MagnoYOutput]=ComputeRetinaFiltering(InputPicture)

global PhotoreceptorsOutput RetinaFirstStageOutput RetinaSecondStageOutput RetinaOutput_ON RetinaOutput_OFF
global RetinaOutput_ON_LP RetinaOutput_OFF_LP
global MagnoYOutput MagnoXOutputON MagnoXOutputOFF AmacrinCellsTempOutput_ON AmacrinCellsTempOutput_OFF
global SpatialLPFilterCoefTable OPLCoefTable IPLparameter
global NBrows NBcolumns

% first init the tables if not already allocated
if isempty(PhotoreceptorsOutput)
    [NBrows NBcolumns]=size(InputPicture);
    PhotoreceptorsOutput = zeros(NBrows, NBcolumns);
    RetinaFirstStageOutput = zeros(NBrows, NBcolumns);
    RetinaSecondStageOutput = zeros(NBrows, NBcolumns);
    RetinaOutput_ON = zeros(NBrows, NBcolumns);
    RetinaOutput_OFF = zeros(NBrows, NBcolumns);

    RetinaOutput_ON_LP = zeros(NBrows, NBcolumns);
    RetinaOutput_OFF_LP = zeros(NBrows, NBcolumns);

    MagnoYOutput = zeros(NBrows, NBcolumns);
    AmacrinCellsTempOutput_ON = zeros(NBrows, NBcolumns);
    AmacrinCellsTempOutput_OFF = zeros(NBrows, NBcolumns);
    MagnoXOutputON = zeros(NBrows, NBcolumns);
    MagnoXOutputOFF = zeros(NBrows, NBcolumns);
end

% update the filtering coefficient tables
if isempty(SpatialLPFilterCoefTable)
   % No full matlab use, check initialization and stops if not
%     error('Retina filtering parameters not initialized')
   % to make it run without OpenInterface
   'InitialisinRetina Parameters'
   setRetinaParameters(1, 0.1, 0, 5, 0.1, 0.5, 0, 0.1, 1.6);
end

% Photoreceptors compression
PhotoreceptorsCompressionHCells2(InputPicture,RetinaSecondStageOutput, PhotoreceptorsOutput, NBrows, NBcolumns);

% Retina B model filtering
RealSpatialRetinaFilter_OnOff2(PhotoreceptorsOutput, RetinaFirstStageOutput, RetinaSecondStageOutput, RetinaOutput_ON, RetinaOutput_OFF, NBrows, NBcolumns, OPLCoefTable);

% compute low pass filter on On and OFF outputs
SpatioTemporalLPFilter(RetinaOutput_ON, RetinaOutput_ON_LP, NBrows, NBcolumns, SpatialLPFilterCoefTable);
SpatioTemporalLPFilter(RetinaOutput_OFF, RetinaOutput_OFF_LP, NBrows, NBcolumns, SpatialLPFilterCoefTable);

%EnergyLocalization = RetinaOutput_ON_LP + RetinaOutput_OFF_LP;
RetinaOutput=RetinaOutput_ON-RetinaOutput_OFF; %tous les contours

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% temporal derivative ... more instable but efficient
%IPLFilter(EnergyLocalization, AmacrinCellsTempOutput, MagnoXOutput, MagnoYOutput, NBrows, NBcolumns, CoefIPL); % dans MagnoX et MagnoY=abs(MagnoX) seulement les contours en mouvement
IPLFilter2(RetinaOutput_ON_LP, RetinaOutput_OFF_LP, AmacrinCellsTempOutput_ON, AmacrinCellsTempOutput_OFF, MagnoXOutputON, MagnoXOutputOFF, MagnoYOutput, NBrows, NBcolumns, IPLparameter);
