%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% script that computes the preliminar data fusion analysis for visual
% hypovigilence detection : events alarms are : both eyes closed more than
% X period, mouth yawnings and global head motions
% this is a very basic integration, can be improved for better fusion
% process


% Fusion process of the visual informations

global AlarmEyesClosed
global fissionVariables

% computing time reference
timeCounter=clock;
currentTime = timeCounter(5)*60+timeCounter(6);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% detecting 2 closed eyes => generate alarm if it's too long
% OUTPUT : AlarmEyesClosed (char* ?)
EyesAlert=0;
AlarmEyesClosed=' ';
if EyeLeftBinaryState==0 && EyeRightBinaryState==0

    if LastEyesCLosedDuration == -1
        timeClosedEyesStart=currentTime;
    end

    LastEyesCLosedDuration=1000*(currentTime-timeClosedEyesStart);

    if LastEyesCLosedDuration > MaxTimeEyesClosed
        LastEyesCLosedDuration
        %%% Alarm, long eye closed duration
        AlarmEyesClosed='Eyes CLOSED !!!!!, wake UP';
        EyesAlert=1


    else
        AlarmEyesClosed=' ';%-------- RAS -------------';

    end

else
    LastEyesCLosedDuration=-1;

end

if HeadMotionAlert

    if LastHeadMotionDuration == -1
        timeHeadMotionStart=currentTime;
    end

    LastHeadMotionDuration=1000*(currentTime-timeHeadMotionStart)

    if LastHeadMotionDuration > HeadMotionAlertTime

        %%% Alarm, long eye closed duration
        AlarmHeadMotion='Head Motion !!!!!, Attention'
        disp(LastHeadMotionDuration);


    else
        AlarmHeadMotion=' ';%-------- RAS -------------';

    end

else
    LastHeadMotionDuration=-1;

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% detecting mouth Yawning
% OUTPUT : MouthYawningDetected

% idea : if the MouthIPLEnergy variation is
% regular and reaches 2 times its initial value after motion event, then, a
% yawning is detected
%
% Corriger par LUONG Hong Viet
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% if not(FaceActivity)
LastYawnDuration=0;
if (MouthMotion~=0)&&not(StartMouthAnalysis)% if mouth state is changing
    %    CurrentFrame;
    StartMouthAnalysis=1;
    timeMouthChangeStart=currentTime;
    MouthOPLEnergyEvolutionSign=sign(MouthMotion);
    MouthOPLEnergyInitValue=MouthOPLTotalEnergyAdaptativeMean_New;
    MouthOPLEnergyVariationRegular=1;
    debuggingV='YawningChronoStart'

end


%if ok then, compute the mouth motion duration (if needed)
LastMouthChangeDuration=double(1000*(currentTime-timeMouthChangeStart));

% detecting constant energy evolution of the mouth motion (constant
% opening or constant closing'
MouthAlert=0;
MouthYawningDetected=' ';

% if CurrentFrame==338
%     disp('ABC');
% end
FindYawning=0;
if StartMouthAnalysis
    if (sign(MouthMotion) == MouthOPLEnergyEvolutionSign)&&(LastMouthChangeDuration<MaxYawnDuration)
        %debuggingV='Yawning-----REGULAR'
        MouthOPLEnergyVariationRegular =1;
        %LastMouthChangeDuration
        if abs(MouthOPLTotalEnergyAdaptativeMean_New - MouthOPLEnergyInitValue) > MouthOPLEnergyInitValue/2
            if (MouthOPLEnergyEvolutionSign ==1 && LastMouthChangeDuration>MinTimeMouthYawns) || (MouthOPLEnergyEvolutionSign ==-1)
                MouthYawningDetected='- Yawnings? Don t Sleep !-'
                YawningFrame=CurrentFrame
                MouthAlert=1;
                LastYawnDuration=LastMouthChangeDuration
            end
        else

            MouthYawningDetected=' ';
        end

    else
        % irregular motion; reinit mouth yawning detection
        %        CurrentFrame;
        %        StartMouthAnalysis=0
        MouthOPLEnergyVariationRegular =0;
        timeMouthChangeStart=currentTime;
        %'Irregular MouthMotion'
        LastMouthMotionEvent=-1;

    end
end
% end
%%appel de la methode pour envoyer le message
NewAlertCode=EyesAlert*1+MouthAlert*2+HeadMotionAlert*3;
if (NewAlertCode~=OldAlertCode)%EyesAlert||MouthAlert||HeadMotionAlert)
    VigilenceNoFusion(AlarmEyesClosed, MouthYawningDetected, HeadMotionDirection,EyesAlert, MouthAlert, HeadMotionAlert,useTCPConnexion);
end
% end    ChangeDone=1;
% elseif ChangeDone
%     VigilenceNoFusion(AlarmEyesClosed, MouthYawningDetected, HeadMotionDirection,EyesAlert, MouthAlert, HeadMotionAlert,useTCPConnexion);
%     ChangeDone=0;
% end
OldAlertCode=NewAlertCode;
%if CurrentFrame<21
%stringMessage=strcat('<Event><Message Sentence="','Initializing, please don't move ','"/><ColorFe%edback Color="', '1','"/> <VibrationFeedback Strength="','0','"/>', '</Event>');
%stringMessage = char(stringMessage);
%SendInitMessage(stringMessage);
%end

% case of bayesian fusion
% if (EyesAlert||MouthAlert||HeadMotionAlert)
%      VigilenceAlarm(EyesAlert, MouthAlert, HeadMotionAlert)
%      ChangeDone=1;
% elseif ChangeDone
%      VigilenceAlarm(EyesAlert, MouthAlert, HeadMotionAlert)
%      ChangeDone=0;
% end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A new strategy of data fusion
% LUONG Hong Viet
% LastEyesCLosedDuration  = X
% LastYawnDuration = Y
% SpeechTime= Z

%  AlphaEye=0.25;
%  EyeClosedTime=1;
%  BetaYawn=0.5;
%  YawnTime=2;
%  GammaHeadMotion=0.25;
%  HeadMotionAlertTime=3;
%  DeltaSpeech=0.5;
%  SpeechTimeAlert=3;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if LastEyesCLosedDuration<=EyeClosedTime
    fX=0;
else
    fX=AlphaEye*sqrt((LastEyesCLosedDuration-EyeClosedTime)/LastEyesCLosedDuration);
end

if LastYawnDuration<=YawnTime
    fY=0;
else
    fY=BetaYawn*sqrt((LastYawnDuration-YawnTime)/LastYawnDuration);
end
if SpeechTime<=SpeechTimeAlert
    fZ=0;
else
    fZ=DeltaSpeech*sqrt((SpeechTime-SpeechTimeAlert)/SpeechTime);
end

if LastHeadMotionDuration <=HeadMotionAlertTime
    fW=0;
else
    fW=GammaHeadMotion*sqrt((LastHeadMotionDuration-HeadMotionAlertTime)/LastHeadMotionDuration);
end

HypoVigilenceIndex=fX+fY+fW+fZ;
if HypoVigilenceIndex>0
    if HypoVigilenceIndex<0.25
        AlertHypoVigilence='Hypovigilence----------Attention'
    elseif HypoVigilenceIndex>=0.25
        AlertHypoVigilence='Hypovigilence----------Attention, Be careful!'
    elseif HypoVigilenceIndex>=0.35
        AlertHypoVigilence='Hypovigilence----------Attention, Very dangerous!!!!!!'
    end
    disp(HypoVigilenceIndex);
end