% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% script that computes the preliminar data fusion analysis for visual
% hypovigilence detection : events alarms are : both eyes closed more than
% X period, mouth yawnings and global head motions
% this is a very basic integration, can be improved for better fusion
% process

% Fusion process of the visual informations

% computing time reference
timeCounter=clock;
currentTime = timeCounter(5)*60+timeCounter(6);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compute the duration of both eye closing periods
% OUTPUT : LastEyesCLosedDuration:unit in second
if EyeLeftBinaryState==0 && EyeRightBinaryState==0

    if LastEyesCLosedDuration == -1
        timeClosedEyesStart=currentTime;
        
        % add a new line for the new blink in the list: translate the rows
        % one line below
        EyeBlinksList(2:sizeEyeBlinksList,:)=EyeBlinksList(1:sizeEyeBlinksList-1,:);
        % fill the first line
        EyeBlinksList(1,1)=currentTime;
    end

    LastEyesCLosedDuration=1000*(currentTime-timeClosedEyesStart);

    

else
    
    if LastEyesCLosedDuration~=-1
        EyeBlinksList(1,2)=currentTime;
        
        % get the last 20 seconds of eye blinks
        [numberOfLines temp]=size(find(currentTime-EyeBlinksList(:,1)<20));
        OutputBlinksList=EyeBlinksList(1:numberOfLines, :)
    end
    
    LastEyesCLosedDuration=-1;

end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute the duration of the head motions
% OUTPUT : LastHeadMotionDuration:unit in second
if HeadMotionAlert

    if LastHeadMotionDuration == -1
        timeHeadMotionStart=currentTime;
    end

    LastHeadMotionDuration=1000*(currentTime-timeHeadMotionStart);

else
    LastHeadMotionDuration=-1;

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% detecting mouth Yawning
% OUTPUT : MouthYawningDetected

% idea : if the MouthIPLEnergy variation is
% regular and reaches 2 times its initial value after motion event, then, a
% yawning is detected
%
% Corriger par LUONG Hong Viet
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% if not(FaceActivity)
LastYawnDuration=0;
if (MouthMotion~=0)&&not(StartMouthAnalysis)% if mouth state is changing
    %    CurrentFrame;
    StartMouthAnalysis=1;
    timeMouthChangeStart=currentTime;
    MouthOPLEnergyEvolutionSign=sign(MouthMotion);
    MouthOPLEnergyInitValue=MouthOPLTotalEnergyAdaptativeMean_New;
    MouthOPLEnergyVariationRegular=1;
    debuggingV='YawningChronoStart'

end


%if ok then, compute the mouth motion duration (if needed)
LastMouthChangeDuration=double(1000*(currentTime-timeMouthChangeStart));

% detecting constant energy evolution of the mouth motion (constant
% opening or constant closing'
MouthAlert=0;

% if CurrentFrame==338
%     disp('ABC');
% end
FindYawning=0;
if StartMouthAnalysis
    if (sign(MouthMotion) == MouthOPLEnergyEvolutionSign)&&(LastMouthChangeDuration<MaxYawnDuration)
        %debuggingV='Yawning-----REGULAR'
        MouthOPLEnergyVariationRegular =1;
        %LastMouthChangeDuration
        if abs(MouthOPLTotalEnergyAdaptativeMean_New - MouthOPLEnergyInitValue) > MouthOPLEnergyInitValue/2
            if (MouthOPLEnergyEvolutionSign ==1 && LastMouthChangeDuration>MinTimeMouthYawns) || (MouthOPLEnergyEvolutionSign ==-1)
                MouthYawningDetected='- Yawnings? Don t Sleep !-'
                YawningFrame=CurrentFrame;
                MouthAlert=1;
                LastYawnDuration=LastMouthChangeDuration;
            end
        else
            MouthYawningDetected=' ';
        end

    else
        % irregular motion; reinit mouth yawning detection
        %        CurrentFrame;
        %        StartMouthAnalysis=0
        MouthOPLEnergyVariationRegular =0;
        timeMouthChangeStart=currentTime;
        %'Irregular MouthMotion'
        LastMouthMotionEvent=-1;

    end
end
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Compute alarm levels
if LastEyesCLosedDuration<=EyeClosedTime
    EyesClosedAlarm=0;
else
    EyesClosedAlarm=AlphaEye*sqrt((LastEyesCLosedDuration-EyeClosedTime)/LastEyesCLosedDuration);
end

if LastYawnDuration<=YawnTime
    YawningAlarm=0;
else
    YawningAlarm=BetaYawn*sqrt((LastYawnDuration-YawnTime)/LastYawnDuration);
end

if (LastHeadMotionDuration<=HeadMotionAlertTime)
    HorizontalHeadMotionAlarm=0;
    VerticalHeadMotionAlarm=0;
else
    if abs(HeadMotionOrientation_Current)==1
        HorizontalHeadMotionAlarm=GammaHeadMotion*sqrt((LastHeadMotionDuration-HeadMotionAlertTime)/LastHeadMotionDuration);
    elseif abs(HeadMotionOrientation_Current)==2
        VerticalHeadMotionAlarm=GammaHeadMotion*sqrt((LastHeadMotionDuration-HeadMotionAlertTime)/LastHeadMotionDuration);
    else
        if (LastHeadMotionDuration<=HeadMotionAlertTime)
            HorizontalHeadMotionAlarm=0;
            VerticalHeadMotionAlarm=0;
        end
    end
end

% create the output vector
if CurrentFrame>NoiseMeanInitDuration
    FusionVector=[EyesClosedAlarm, YawningAlarm, HorizontalHeadMotionAlarm, VerticalHeadMotionAlarm];
else
    FusionVector=zeros(1,4);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FINAL STEP: send the data to the fusion processes
%FusionVector for alerts:
%SendData(FusionVector);
%SendEyeBlinksList(EyeBlinksList);

