
%function [xmlMessage]= makeFission(fatigueLevel)
%creates a XML message that can be send to Driver Simulator
%Input parameters : fatigueLevel (0 - 100)
% Output: xmlMessage - XML message or "NOT_CHANGED"
% Vjekoslav Levacic, vjekoslav.levacic@fer.hr

function [xmlMessage]= makeFission(fatigueLevel)

global fissionVariables
enumMessages = {'';'You look tired. Get some rest!'; 'WARNING! Serious fatigue. Stop the car!'}; %enumerates messages
enumMessageColor = {'1','1','0'}; %0 is Red, 1 is Green, 2 is Blue
enumWheelShakingPower = {'0',fatigueLevel,'100'}; % 100 is a maximum shaking power, integer values
enumSoundVolume = {'0','0','0'}; % sound power is between 0 and 5, integer values
enumBorders = [0 33;33 50;50 100]; % enumeraters borders for messages
stabilityValues = [10;1;1]; %stability values provide information how many loops in the same state must be to take the effect

if(size(fissionVariables,1)~= (2 + size(stabilityValues,1))) %if not initialized or wrongly initialized
        fissionVariables = [0; 0; stabilityValues];
end

rowIndex = findRowIndex(enumBorders,fatigueLevel); %in which row is the threshold
lastRowIndex = fissionVariables(1,1);
lastValidIndex = fissionVariables(2,1);

    %if inserted into a new range reset all values to normal
if(lastRowIndex ~= rowIndex)
        fissionVariables = [rowIndex; fissionVariables(2,1); stabilityValues];
end

fissionVariables(1,1) = rowIndex; %set the last row index
    if(fissionVariables(rowIndex + 2,1) > 0)
    fissionVariables(rowIndex + 2, 1) = fissionVariables(rowIndex + 2, 1) - 1; %decrease the counter
    end
fissionVariables(1,1) = rowIndex; % set the current index

xmlMessage = 'NOT_CHANGED';

if(fissionVariables(rowIndex + 2,1) == 0 && lastValidIndex ~= rowIndex )
%%if currentThreshold is in same range as last one and if it has been in this range long enough    
message = findRow(enumMessages,enumBorders,fatigueLevel);
color = findRow(enumMessageColor, enumBorders,fatigueLevel);
shakingPower = findRow(enumWheelShakingPower,enumBorders,fatigueLevel);
soundVolume = findRow(enumSoundVolume,enumBorders,fatigueLevel);
xmlMessage = generateXMLMessage(message,color,shakingPower,soundVolume); % generate the new message
fissionVariables(2,1) = rowIndex; % set a new stabile index value
end

% decomment par philou
    message = findRow(enumMessages,enumBorders,lastValidThreshold);
   color = findRow(enumMessageColor, enumBorders,lastValidThreshold);
    shakingPower = findRow(enumWheelShakingPower,enumBorders,lastValidThreshold);
    soundVolume = findRow(enumSoundVolume,enumBorders,lastValidThreshold);
    xmlMessage = generateXMLMessage(message,color,shakingPower,soundVolume); % generate the message

%fissionVariablesOut = fissionVariables;
%fin de decommentarisation philou


% send the xml message via tcp ip connection
if not(strcmp('NOT_CHANGED',xmlMessage))
    SendAlarm(xmlMessage);
end

%
%Finds a row index in enumBorders where col(1) < fatigueLevel and col(2) >
%fatigue Level. According to row get the row value in enumValue
%
function message = findRow(enumValue, enumBorders, fatigueLevel)
index = findRowIndex(enumBorders,fatigueLevel);
message = enumValue(index);


%
%Finds a row index in enumBorders where col(1) < fatigueLevel and col(2) >
%fatigue Level.
%
function index = findRowIndex(enumBorders, fatigueLevel)
index = find( enumBorders(:,1) <= fatigueLevel & enumBorders(:,2) > fatigueLevel);



function stringMessage=generateXMLMessage(message, color, VibrationFeedbackValue, SoundVolumeValue)
stringMessage==strcat('<Event><Message Sentence="'  message '"/> <ColorFeedback Color="' color '"/> <SoundFeedback Sound="' 1 '"/> <VibrationFeedback Strength="' VibrationFeedbackValue  '"/>'];
%stringMessage=strcat('<Event><Message Sentence="', message,'"/><ColorFeedback Color="', color,'"/> <VibrationFeedback Strength="', VibrationFeedbackValue,'"/>', '</Event>');
stringMessage = char(stringMessage);
%stringMessage=[stringMessage '<Sound Level="' SoundVolumeValue '"/>']



