%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier 
 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%  
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
 
% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.
 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit


% demo file used to test mpisearch results


WebcamVideoMode=0; %set 1 if you want to use the webcam...


% prepare video input data for matrix sizes
    if WebcamVideoMode==1
            a=vcapg2;
            pause(2);
    else
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % read the movie if needed
        if not(exist('movie', 'var'))
            [filename  pathname] = uigetfile('*.avi', 'Choose a video');
            movie = aviread([pathname filename]);
            [x MovieLenght] = size(movie);
            MovieStop = MovieLenght;
        end
    end

    CurrentFrame=1;
    
while CurrentFrame<MovieStop
    
            if WebcamVideoMode == 1
            FirstRGBPicture = vcapg2;
        else    
            % first picture region selection
            FirstRGBPicture = movie(CurrentFrame).cdata;
            CurrentFrame=CurrentFrame+1;
            
        end
    
[boxes, detects, n] = mpisearchMexNEW(0, single(RGB2grayC(FirstRGBPicture)'), 1, 1, 0);
    
            
        mpisearchDLL_Failed = not(n);
        
        subplot(1,2,1)
        imshow(FirstRGBPicture);
        title(['Frame n' num2str(CurrentFrame)]);    
        
        if n
            HeadBoxRowUpIndex=boxes(3);
            HeadBoxRowDownIndex=boxes(4);
            HeadBoxColumnUpIndex=boxes(5);
            HeadBoxColumnDownIndex=boxes(6);
            
            subplot(1,2,2)
            imshow(FirstRGBPicture(HeadBoxRowUpIndex:HeadBoxRowDownIndex, HeadBoxColumnUpIndex:HeadBoxColumnDownIndex, :));
        else
            subplot(1,2,2)
            imshow(zeros(size(FirstRGBPicture)));
    
        end
        
        drawnow
        
end

