%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% script that displays the figures depending of the HeadMotionDirectionDemoMode value
global MainWindowHandle initMainWindowOK

if CurrentFrame<NoiseMeanInitDuration
    if CurrentFrame<5
        subplot(1,2,1)
        imshow(getfield(ResultPicture,InitPeriodFlag))
        subplot(1,2,2)
        imshow(AcquiredPicture)
        
        drawnow
    end

else
    
    if not(initMainWindowOK)
        InitWindowDisplay
        initMainWindowOK=true;
    end

    set(CurrentPictureDisplay,'cdata',uint8(PhotoreceptorsOutput));

    if HeadMotionDirectionDemoMode~=2
        set(HeadMotionDirectionFigure,'cdata',getfield(ResultPicture,HeadMotionDirection));
    end

    FaceAreaDisplay=zeros(NrowsFace, McolumnsFace);
    %                 EyeLeftUp
    %                 EyeLeftDown
    %                 EyeLeftLeft
    %                 EyeLeftRight

    %                 FaceAreaDisplay(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight) = Face_OPL(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight);
    %                 FaceAreaDisplay(EyeRightUp:EyeRightDown, HalfMcolumnsFace+uint16(EyeRightLeft):HalfMcolumnsFace+uint16(EyeRightRight)) = Face_OPL(EyeRightUp:EyeRightDown, HalfMcolumnsFace+uint16(EyeRightLeft):HalfMcolumnsFace+uint16(EyeRightRight));
    %                 FaceAreaDisplay(MouthUp:MouthDown, MouthLeft:MouthRight) = Face_OPL(MouthUp:MouthDown, MouthLeft:MouthRight);
    FaceAreaDisplay(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight) = Face_OPL(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight);
    FaceAreaDisplay(EyeRightUp:EyeRightDown, EyeRightLeft:EyeRightRight) = Face_OPL(EyeRightUp:EyeRightDown, EyeRightLeft:EyeRightRight);
    FaceAreaDisplay(MouthUp:MouthDown, MouthLeft:MouthRight) = Face_OPL(MouthUp:MouthDown, MouthLeft:MouthRight);


    if HeadMotionDirectionDemoMode==0

        % Drawing Interpretation figure...basic... ;o)
        InterpretationPicture(1:47, 1:51, :)=getfield(ResultPicture,EyeLeftState);
        InterpretationPicture(1:47, 70:120, :)=getfield(ResultPicture,EyeRightState);
        InterpretationPicture(42:78, 32:89, :)=getfield(ResultPicture,MouthState);

        set(RetinaOutputFigure,'cdata',gray2RGB_2DmatrixGray(Face_OPL));

        if testFaceLogPolarSpectrum
            set(IPLOutputFigure,'cdata',gray2RGB_2DmatrixGray(IPLLogPolFFTFace'));
        else
            set(IPLOutputFigure,'cdata',gray2RGB_2DmatrixGray(Face_IPL));
        end

        set(ExtractedFaceFeaturesDisplay,'cdata',gray2RGB_2DmatrixGray(FaceAreaDisplay));
        set(PLIEdgesTableFigure,'cdata',gray2RGB_2DmatrixGray(double(PLIEdgesTable)));

        set(InterpretationFigure,'cdata', InterpretationPicture);%getfield(ResultPicture,EyeState)) OR gray2RGB_2DmatrixGray(PLIEdgesTable));


        set(YesNoFinderFigure,'cdata',getfield(ResultPicture,FaceAttitudeState));

        subplot(2,4,8)
        %                 imagesc(IPLLogPolFFTFace')

    elseif HeadMotionDirectionDemoMode==2

        set(HeadDetectionFigure,'cdata',gray2RGB_2DmatrixGray(FaceAreaDisplay));
    end

    drawnow

    if SaveVideoOutput ==1
        F=getframe(gcf);
        CorrelationMovie = addframe(CorrelationMovie,F);
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end