%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% functiuon that detects eye left blinks (action : opening/closing), and state
% using a spectrum analysis of the eye area : the OPL filter output of the
% area reports the state information, the IPLK output reports the moton
% events and its orientation
% a first eye detection is done with oriented flow pass filter computing
% (low coputation cost but can be improved)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Eye Left Detection and analysis

%First : filtering the eye region
EyeLeftArea = EyeLeftWindow.*Face_OPL(1:HalfNrowsFace, 1:HalfMcolumnsFace); %1/4 gauche superieur du cadre du visage de MPT
% Face_OPL = sortie retinaOutput
% if CurrentFrame>20
% figure
% mesh(EyeLeftArea)
% input('press enter')
% end

MaxCoordEyeLeft = SpatioTemporalSquaringLPFilterFindSymMax(abs(EyeLeftArea), EyeLeftArea_LP_H, EyeLeftArea_LP_V, EyesSearchAreaNRows, EyesSearchAreaMcolumns, EyeFinderTableCoef);
%fichier .c retourne coord du centre de l'oeil

EyeLeftUp = max(1, EyeLeftUp*alphaEyePositionMotion+(1-alphaEyePositionMotion)*(MaxCoordEyeLeft(1)-HalfNrowsEye) );
EyeLeftDown = EyeLeftUp+NrowsEye-1;
EyeLeftLeft = max(1, EyeLeftLeft*alphaEyePositionMotion+(1-alphaEyePositionMotion)*(MaxCoordEyeLeft(2)-HalfMcolumnsEye) );
EyeLeftRight = EyeLeftLeft+McolumnsEye-1;
%extrait le cadre de l'oeil (prend la moiti du cadre initial

% Extract face features OPL and IPL responses
EyeLeft_OPL = Face_OPL(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight);
EyeLeft_IPL = Face_IPL(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight);
%OPL = retina output et IPL= contours en mvt.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Blinks/Yawnings detection start  %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% FFT computing
%             a=size(EyeHammingWindow)
%             b=size(EyeLeft_OPL)
EyeOPLCurrentFFT = abs(fftshift(fft2(EyeLeft_OPL.*EyeHammingWindow)));
EyeIPLCurrentFFT = abs(fftshift(fft2(EyeLeft_IPL.*EyeHammingWindow)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LogPolar transform using GloP filters
FastTransfoLogPolFunctionL_C(EyeIPLCurrentFFT, EyeLogPolTransfoMatrixPixList, EyeLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, IPLLogPolFFTFaceInside, EyeMaxListSize);

IPLShowLogPolSpectrum = IPLLogPolFFTFaceInside';

% find the max value and its coordonates
[MaxValue, IDrow]  = max(max(IPLShowLogPolSpectrum));
[MaxValue, IDcolumn]  = max(max(IPLShowLogPolSpectrum'));

EyeLeftMaxIndexOrientedFrequency(CurrentFrame)= IDcolumn;
% get the oriented energie at the output of the OPL and IPL filter
IPLOrientedEnergie=sum(IPLShowLogPolSpectrum);

% Computing the Total IPL energy
EyeLeftTotalIPLEnergy(CurrentFrame) = sum(IPLOrientedEnergie);
EyeLeftTotalOPLEnergy(CurrentFrame) = sum(sum(EyeOPLCurrentFFT));

% estimating OPL energies
EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame) = EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame-1)*(1-OPLAdaptativeMeanSensitivity) + OPLAdaptativeMeanSensitivity*EyeLeftTotalOPLEnergy(CurrentFrame);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Modify by LUONG Hong Viet
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Extract motion evolution
if CurrentFrame < NoiseMeanInitDuration
    % first evaluate the noise to avoid interpretation errors
    if CurrentFrame >8
        EyeLeftNoiseMeanInit = EyeLeftNoiseMeanInit+EyeLeftTotalIPLEnergy(CurrentFrame);
        EyeLeftMaxIPLEnergy = EyeLeftNoiseMeanInit/NoiseMeanInitDuration;
        EyeLeftMaxEver = 0;
        EyeLeftNoiseMean = EyeLeftNoiseMeanInit/(NoiseMeanInitDuration-8);
        EyeLeftNoiseMeanMultiple=3*EyeLeftNoiseMean;
        LastEyeLeftMotionEvent = CurrentFrame;
        EyeLeftClosedEnergyLevel =EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame)/2;
        EyeLeftOpenedEnergyLevel =EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame);
        EyeLeftOpenClosedEnergyLimit = (EyeLeftClosedEnergyLevel+EyeLeftOpenedEnergyLevel)/2;

    end
else
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Evaluating variables signification
    EyeLeftMaxIPLEnergy = EyeLeftMaxIPLEnergy*0.9; % MaxEnergy decreases in the time => be aware of all events even smallest but significant...

    if (EyeLeftTotalIPLEnergy(CurrentFrame)-EyeLeftNoiseMean > 0)&&(EyesIPLtotalEnergy||EyesAndMouthActivity)

        % Update the max value limit :

        EyeLeftMaxIPLEnergy = max(EyeLeftMaxIPLEnergy, EyeLeftTotalIPLEnergy(CurrentFrame)-EyeLeftNoiseMean);

        EyeLeftalphaMaxIPLEnergy = (EyeLeftTotalIPLEnergy(CurrentFrame)-EyeLeftNoiseMean)/EyeLeftMaxIPLEnergy;
        EyeLeftalphaMaxIPLEnergy = EyeLeftalphaMaxIPLEnergy*EyeLeftalphaMaxIPLEnergy;
        EyeLeftalphaCurrentData = EyeLeftalphaMaxIPLEnergy;

    else
        EyeLeftalphaCurrentData =0;
    end
    EyeLeftalphaCurrentDataHist(CurrentFrame)= EyeLeftalphaCurrentData;
    EyeLeftMaxIPLEnergyHistory(CurrentFrame) = EyeLeftMaxIPLEnergy;
    EyeLeftMaxEverHistory(CurrentFrame) = EyeLeftMaxEver;

    %%%%%%%%%% Init part end %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Detecting Eye Motion/Blink:

    % state evolution indicator pre update
    EyeLeftStateChange =0;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Modifier par LUONG Hong Viet
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if EyeLeftalphaCurrentData < 0.5 || FaceActivity
        EyeLeftMotion = 'EyeStable';
        EyeLeftLastStableOPLValue = EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame);
    else
        % identifying the motion orientation
        [MaxOrientedEnergy, IndexMaxOrientedEnergy] = max(IPLOrientedEnergie);

        if abs(IndexMaxOrientedEnergy - NBanglesFaceInside/4) < NBanglesFaceInside/4

            EnergyGradient = (EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame)-EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame-1));

            if EnergyGradient < 0
                EyeLeftMotion = 'ClosingEye';
            else
                EyeLeftMotion = 'OpeningEye';
            end

            % detecting eye state
            EyeLeftStableFrameNumber = CurrentFrame-LastEyeLeftMotionEvent;
            % init for the upcoming reinitialized records
            LastEyeLeftMotionEvent = CurrentFrame;

            % if there are sufficient stables frames, then compute energy levels
            if EyeLeftStableFrameNumber > SignificantNumberOfFramesLevels
                % case of current energy level higher than the one
                % during the stable period => the eye just closed
                if EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame) > EyeLeftTotalOPLEnergy(CurrentFrame)
                    % updating eye opened energy level
                    EyeLeftOpenedEnergyLevel = max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
                else%if OPLTotalEnergyAdaptativeMean(CurrentFrame) < TotalOPLEnergy(CurrentFrame)
                    % updating eye opened energy level
                    EyeLeftClosedEnergyLevel = min(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
                end

                EyeLeftStateChange =1;

            end
        end
    end

    % detectting Eye State
    EyeLeftOpenClosedEnergyLimit = (EyeLeftClosedEnergyLevel+EyeLeftOpenedEnergyLevel)/2;
    limit_hist(CurrentFrame)=EyeLeftOpenClosedEnergyLimit;
    % if state change imposed, then change OK, else, continue
    % updating the last state ... try to test...goal, avoid
    % false change detection when a global head mtion occurs
    if not(FaceActivity)%update energy levels only if the global head do not move
        if EyeLeftTotalOPLEnergy(CurrentFrame) < EyeLeftOpenClosedEnergyLimit
            if EyeLeftBinaryState==0 || EyeLeftStateChange % allows a limittion of the state changes...check if better
                EyeLeftState='LeftEyeClosed';
                EyeLeftBinaryState =0;
                EyeLeftClosedEnergyLevel = EyeLeftClosedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*min(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
            else
                EyeLeftState='LeftEyeOpen';
                EyeLeftBinaryState =1;
                EyeLeftOpenedEnergyLevel = EyeLeftOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
            end
        else
            EyeLeftState='LeftEyeOpen';
            EyeLeftBinaryState =1;
            EyeLeftOpenedEnergyLevel = EyeLeftOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);

        end
    end
    % recording values
     EyeLeftClosedEnergyLevel_Hist(CurrentFrame) = EyeLeftClosedEnergyLevel;
     EyeLeftOpenedEnergyLevel_Hist(CurrentFrame) = EyeLeftOpenedEnergyLevel;


    %%%  Blinks/Yawnings detection end  %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %end of "if CurrentFrame < NoiseMeanInitDuration"
end

