%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% functiuon that detects eye left blinks (action : opening/closing), and state
% using a spectrum analysis of the eye area : the OPL filter output of the
% area reports the state information, the IPLK output reports the moton
% events and its orientation
% a first eye detection is done with oriented flow pass filter computing
% (low coputation cost but can be improved)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Eye Right Detection and analysis
%First : filtering the eye region
EyeRightArea = EyeRightWindow.*Face_OPL(1:HalfNrowsFace, HalfMcolumnsFace:McolumnsFace-1);
MaxCoordEyeRight = SpatioTemporalSquaringLPFilterFindSymMax(abs(EyeRightArea), EyeRightArea_LP_H, EyeRightArea_LP_V, EyesSearchAreaNRows, EyesSearchAreaMcolumns, EyeFinderTableCoef);

EyeRightUp = max(1, EyeRightUp*alphaEyePositionMotion+(1-alphaEyePositionMotion)*(MaxCoordEyeRight(1)-HalfNrowsEye));
EyeRightDown = EyeRightUp+NrowsEye-1;
EyeRightLeft = min(HalfMcolumnsFace-McolumnsEye, (double(EyeRightLeft)-double(HalfMcolumnsFace))*alphaEyePositionMotion+(1-alphaEyePositionMotion)*(uint16(MaxCoordEyeRight(2)-HalfMcolumnsEye+1)))+HalfMcolumnsFace;
EyeRightRight = EyeRightLeft+McolumnsEye-1;

% Extract face features OPL and IPL responses
EyeRight_OPL = Face_OPL(EyeRightUp:EyeRightDown, EyeRightLeft:EyeRightRight);
EyeRight_IPL = Face_IPL(EyeRightUp:EyeRightDown, EyeRightLeft:EyeRightRight);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Blinks/Yawnings detection start  %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% FFT computing
EyeOPLCurrentFFT = abs(fftshift(fft2(EyeRight_OPL.*EyeHammingWindow)));
EyeIPLCurrentFFT = abs(fftshift(fft2(EyeRight_IPL.*EyeHammingWindow)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LogPolar transform using GloP filters
FastTransfoLogPolFunctionL_C(EyeIPLCurrentFFT, EyeLogPolTransfoMatrixPixList, EyeLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, IPLLogPolFFTFaceInside, EyeMaxListSize);

IPLShowLogPolSpectrum = IPLLogPolFFTFaceInside';

% find the max value and its coordonates
[MaxValue, IDrow]  = max(max(IPLShowLogPolSpectrum));
[MaxValue, IDcolumn]  = max(max(IPLShowLogPolSpectrum'));

EyeRightMaxIndexOrientedFrequency(CurrentFrame)= IDcolumn;
% get the oriented energie at the output of the OPL and IPL filter
IPLOrientedEnergie=sum(IPLShowLogPolSpectrum);

% Computing the Total IPL energy
EyeRightTotalIPLEnergy(CurrentFrame) = sum(IPLOrientedEnergie);
EyeRightTotalOPLEnergy(CurrentFrame) = sum(sum(EyeOPLCurrentFFT));

% estimating OPL energies
EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame) = EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame-1)*(1-OPLAdaptativeMeanSensitivity) + OPLAdaptativeMeanSensitivity*EyeRightTotalOPLEnergy(CurrentFrame);

%%% Extract motion evolution
if CurrentFrame < NoiseMeanInitDuration
    % first evaluate the noise to avoid interpretation errors
    if CurrentFrame >8
        EyeRightNoiseMeanInit = EyeRightNoiseMeanInit+EyeRightTotalIPLEnergy(CurrentFrame);
        EyeRightMaxIPLEnergy = EyeRightNoiseMeanInit/NoiseMeanInitDuration;
        EyeRightMaxEver = 0;
        EyeRightNoiseMean = EyeRightNoiseMeanInit/(NoiseMeanInitDuration-8);
        EyeRightNoiseMeanMultiple=3*EyeRightNoiseMean;
        LastEyeRightMotionEvent = CurrentFrame;
        EyeRightClosedEnergyLevel =EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame)/2;
        EyeRightOpenedEnergyLevel =EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame);
        EyeRightOpenClosedEnergyLimit = (EyeRightClosedEnergyLevel+EyeRightOpenedEnergyLevel)/2;
    end
else
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Evaluating variables signification
    EyeRightMaxIPLEnergy = EyeRightMaxIPLEnergy*0.9; % MaxEnergy decreases in the time => be aware of all events even smallest but significant...

    if (EyeRightTotalIPLEnergy(CurrentFrame)-EyeRightNoiseMean > 0)&&(EyesIPLtotalEnergy||EyesAndMouthActivity)

        % Update the max value limit :

        EyeRightMaxIPLEnergy = max(EyeRightMaxIPLEnergy, EyeRightTotalIPLEnergy(CurrentFrame)-EyeRightNoiseMean);

        EyeRightalphaMaxIPLEnergy = (EyeRightTotalIPLEnergy(CurrentFrame)-EyeRightNoiseMean)/EyeRightMaxIPLEnergy;
        EyeRightalphaMaxIPLEnergy = EyeRightalphaMaxIPLEnergy*EyeRightalphaMaxIPLEnergy;
        EyeRightalphaCurrentData = EyeRightalphaMaxIPLEnergy;

    else
        EyeRightalphaCurrentData =0;
    end
    EyeRightalphaCurrentDataHist(CurrentFrame)= EyeRightalphaCurrentData;
    EyeRightMaxIPLEnergyHistory(CurrentFrame) = EyeRightMaxIPLEnergy;
    EyeRightMaxEverHistory(CurrentFrame) = EyeRightMaxEver;

    %%%%%%%%%% Init part end %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Detecting Eye Motion/Blink:

    % state evolution indicator pre update
    EyeRightStateChange =0;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Modifier par LUONG Hong Viet
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if EyeRightalphaCurrentData < 0.5 || FaceActivity
        EyeRightMotion = 'EyeStable';
        EyeRightLastStableOPLValue = EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame);
    else
        % identifying the motion orientation
        [MaxOrientedEnergy, IndexMaxOrientedEnergy] = max(IPLOrientedEnergie);

        if abs(IndexMaxOrientedEnergy - NBanglesFaceInside/4) < NBanglesFaceInside/4

            EnergyGradient = (EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame)-EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame-1));

            if EnergyGradient < 0
                EyeRightMotion = 'ClosingEye';
            else
                EyeRightMotion = 'OpeningEye';
            end

            % detecting eye state
            EyeRightStableFrameNumber = CurrentFrame-LastEyeRightMotionEvent;
            % init for the upcoming reinitialized records
            LastEyeRightMotionEvent = CurrentFrame;

            % if there are sufficient stables frames, then compute energy levels
            if EyeRightStableFrameNumber > SignificantNumberOfFramesLevels
                % case of current energy level higher than the one
                % during the stable period => the eye just closed
                if EyeRightOPLTotalEnergyAdaptativeMean(CurrentFrame) > EyeRightTotalOPLEnergy(CurrentFrame)
                    % updating eye opened energy level
                    EyeRightOpenedEnergyLevel = max(EyeRightLastStableOPLValue, EyeRightOpenClosedEnergyLimit);
                else%if OPLTotalEnergyAdaptativeMean(CurrentFrame) < TotalOPLEnergy(CurrentFrame)
                    % updating eye opened energy level
                    EyeRightClosedEnergyLevel = min(EyeRightLastStableOPLValue, EyeRightOpenClosedEnergyLimit);
                end

                EyeRightStateChange =1;

            end
        end
    end

    % detectting Eye State
    EyeRightOpenClosedEnergyLimit = (EyeRightClosedEnergyLevel+EyeRightOpenedEnergyLevel)/2;
    if not(FaceActivity)%|| EyesAndMouthActivity|| EyesActivityOnly
        if EyeRightTotalOPLEnergy(CurrentFrame) < EyeRightOpenClosedEnergyLimit
            % if state change imposed, then change OK, else, continue
            % updating the last state ... try to test...goal, avoid
            % false change detection when a global head mtion occurs
            if EyeRightBinaryState==0 || EyeRightStateChange
                EyeRightState='RightEyeClosed';
                EyeRightBinaryState =0;
                EyeRightClosedEnergyLevel = EyeRightClosedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*min(EyeRightLastStableOPLValue, EyeRightOpenClosedEnergyLimit);
            else
                EyeRightState='RightEyeOpen';
                EyeRightBinaryState =1;
                EyeRightOpenedEnergyLevel = EyeRightOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeRightLastStableOPLValue, EyeRightOpenClosedEnergyLimit);
            end
        else
            EyeRightState='RightEyeOpen';
            EyeRightBinaryState =1;
            EyeRightOpenedEnergyLevel = EyeRightOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeRightLastStableOPLValue, EyeRightOpenClosedEnergyLimit);
        end
    end
    % recording values
%     EyeRightClosedEnergyLevel_Hist(CurrentFrame) = EyeRightClosedEnergyLevel;
%     EyeRightOpenedEnergyLevel_Hist(CurrentFrame) = EyeRightOpenedEnergyLevel;


    %%%  Blinks/Yawnings detection end  %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %end of "if CurrentFrame < NoiseMeanInitDuration"
end

%00 0F 66 C8 B3 FF