% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% function that detects eye left blinks (action : opening/closing), and state
% using a spectrum analysis of the eye area : the OPL filter output of the
% area reports the state information, the IPLK output reports the moton
% events and its orientation
% a first eye detection is done with oriented flow pass filter computing
% (low coputation cost but can be improved)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Eye Detection and analysis

% INPUTS: 
%       NrowsEye, McolumnsEye: size in pixels of the eye research area
%       EyeAreaOPL: OPL filtering result of the left or right upper part of the face
%       EyeAreaIPL: IPL filtering result--------------------------------------------
%       EyeLeftRightSelection: integer value that selects the eye left (value=1) or
%           right(value=2)
%       EyeWindow: bump map that helps the detection of the eye position:
%           same size as EyeAreaOPL
%       alphaEyePositionMotion: value between 0 and 1 that allows the
%           temporal smoothing of the eye position
%       EyeUp, EyeLeft: last position of the eye in the eye reseach area
%       EyeLogPolTransfoMatrixPixList, EyeLogPolTransfoMatrixPixCoef,
%           EyeMaxListSize: parameters of the log polar transformation
%           given by the function GloPLargeFilterInitFDivideFast2.dll
%       NBanglesFaceInside, NBradiusFaceInside: size of the output spectrum
%       picture
%       
% OUTPUTS:
%       EyeUp EyeLeft:position of the eye in the eye reseach area
%       EyeState: word that shows the eye state: 'EyeOpen' or 'EyeClosed'
%       EyeMotion: word that shows the eye action: 'EyeStable',
%       'OpeningEye' or 'ClosingEye'



function [EyeUp EyeLeft EyeState EyeMotion]=EyeAnalysis(NrowsEye, McolumnsEye, EyeAreaOPL, EyeAreaIPL, EyeLeftRightSelection, EyeWindow, alphaEyePositionMotion, EyeUp, EyeLeft, EyeLogPolTransfoMatrixPixList, EyeLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, IPLLogPolFFTFaceInside, EyeMaxListSize)


% recalculate half size of the eye research area
HalfNrowsEye = floor(NrowsEye/2);
HalfMcolumnsEye = floor(McolumnsEye/2);

%First : filtering the eye region
EyeArea = EyeWindow.*EyeAreaOPL);
% Face_OPL = sortie retinaOutput
% if CurrentFrame>20
% figure
% mesh(EyeLeftArea)
% input('press enter')
% end
EyeArea_LP_H=zeros(EyesSearchAreaNRows, EyesSearchAreaMcolumns);
EyeArea_LP_V=zeros(EyesSearchAreaNRows, EyesSearchAreaMcolumns);

MaxCoordEye = SpatioTemporalSquaringLPFilterFindSymMax(abs(EyeAreaOPL), EyeArea_LP_H, EyeArea_LP_V, NrowsEye, McolumnsEye, EyeFinderTableCoef);
%fichier .c retourne coord du centre de l'oeil

EyeUp = max(1, EyeUp*alphaEyePositionMotion+(1-alphaEyePositionMotion)*(MaxCoordEye(1)-HalfNrowsEye) );
EyeDown = EyeLeftUp+NrowsEye-1;
EyeLeft = max(1, EyeLeft*alphaEyePositionMotion+(1-alphaEyePositionMotion)*(MaxCoordEye(2)-HalfMcolumnsEye) );
EyeRight = EyeLeft+McolumnsEye-1;
%extrait le cadre de l'oeil (prend la moiti du cadre initial

% Extract face features OPL and IPL responses
Eye_OPL = EyeAreaOPL(EyeUp:EyeDown,EyeLeft:EyeRight);
Eye_IPL = EyeAreaIPL(EyeUp:EyeDown,EyeLeft:EyeRight);
%OPL = retina output et IPL= contours en mvt.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Blinks/Yawnings detection start  %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% FFT computing
%             a=size(EyeHammingWindow)
%             b=size(EyeLeft_OPL)
EyeOPLCurrentFFT = abs(fftshift(fft2(Eye_OPL.*EyeHammingWindow)));
EyeIPLCurrentFFT = abs(fftshift(fft2(Eye_IPL.*EyeHammingWindow)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LogPolar transform using GloP filters
FastTransfoLogPolFunctionL_C(EyeIPLCurrentFFT, EyeLogPolTransfoMatrixPixList, EyeLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, IPLLogPolFFTFaceInside, EyeMaxListSize);

IPLShowLogPolSpectrum = IPLLogPolFFTFaceInside';

% find the max value and its coordonates
[MaxValue, IDrow]  = max(max(IPLShowLogPolSpectrum));
[MaxValue, IDcolumn]  = max(max(IPLShowLogPolSpectrum'));

% get the oriented energie at the output of the OPL and IPL filter
IPLOrientedEnergie=sum(IPLShowLogPolSpectrum);

% Computing the Total IPL energy
EyeLeftTotalIPLEnergy(CurrentFrame) = sum(IPLOrientedEnergie);
EyeLeftTotalOPLEnergy(CurrentFrame) = sum(sum(EyeOPLCurrentFFT));

% estimating OPL energies
EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame) = EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame-1)*(1-OPLAdaptativeMeanSensitivity) + OPLAdaptativeMeanSensitivity*EyeLeftTotalOPLEnergy(CurrentFrame);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Modifyed by LUONG Hong Viet
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Extract motion evolution
if CurrentFrame < NoiseMeanInitDuration
    % first evaluate the noise to avoid interpretation errors
    if CurrentFrame >8
        EyeLeftNoiseMeanInit = EyeLeftNoiseMeanInit+EyeLeftTotalIPLEnergy(CurrentFrame);
        EyeLeftMaxIPLEnergy = EyeLeftNoiseMeanInit/NoiseMeanInitDuration;
        EyeLeftMaxEver = 0;
        EyeLeftNoiseMean = EyeLeftNoiseMeanInit/(NoiseMeanInitDuration-8);
        EyeLeftNoiseMeanMultiple=3*EyeLeftNoiseMean;
        LastEyeLeftMotionEvent = CurrentFrame;
        EyeLeftClosedEnergyLevel =EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame)/2;
        EyeLeftOpenedEnergyLevel =EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame);
        EyeLeftOpenClosedEnergyLimit = (EyeLeftClosedEnergyLevel+EyeLeftOpenedEnergyLevel)/2;

    end
else
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Evaluating variables signification
    EyeLeftMaxIPLEnergy = EyeLeftMaxIPLEnergy*0.9; % MaxEnergy decreases in the time => be aware of all events even smallest but significant...

    if (EyeLeftTotalIPLEnergy(CurrentFrame)-EyeLeftNoiseMean > 0)&&(EyesIPLtotalEnergy||EyesAndMouthActivity)

        % Update the max value limit :

        EyeLeftMaxIPLEnergy = max(EyeLeftMaxIPLEnergy, EyeLeftTotalIPLEnergy(CurrentFrame)-EyeLeftNoiseMean);

        EyeLeftalphaMaxIPLEnergy = (EyeLeftTotalIPLEnergy(CurrentFrame)-EyeLeftNoiseMean)/EyeLeftMaxIPLEnergy;
        EyeLeftalphaMaxIPLEnergy = EyeLeftalphaMaxIPLEnergy*EyeLeftalphaMaxIPLEnergy;
        EyeLeftalphaCurrentData = EyeLeftalphaMaxIPLEnergy;

    else
        EyeLeftalphaCurrentData =0;
    end
    EyeLeftalphaCurrentDataHist(CurrentFrame)= EyeLeftalphaCurrentData;
    EyeLeftMaxIPLEnergyHistory(CurrentFrame) = EyeLeftMaxIPLEnergy;
    EyeLeftMaxEverHistory(CurrentFrame) = EyeLeftMaxEver;

    %%%%%%%%%% Init part end %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Detecting Eye Motion/Blink:

    % state evolution indicator pre update
    EyeLeftStateChange =0;
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Modifier par LUONG Hong Viet
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    if EyeLeftalphaCurrentData < 0.5 || FaceActivity
        EyeLeftMotion = 'EyeStable';
        EyeLeftLastStableOPLValue = EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame);
    else
        % identifying the motion orientation
        [MaxOrientedEnergy, IndexMaxOrientedEnergy] = max(IPLOrientedEnergie);

        if abs(IndexMaxOrientedEnergy - NBanglesFaceInside/4) < NBanglesFaceInside/4

            EnergyGradient = (EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame)-EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame-1));

            if EnergyGradient < 0
                EyeLeftMotion = 'ClosingEye';
            else
                EyeLeftMotion = 'OpeningEye';
            end

            % detecting eye state
            EyeLeftStableFrameNumber = CurrentFrame-LastEyeLeftMotionEvent;
            % init for the upcoming reinitialized records
            LastEyeLeftMotionEvent = CurrentFrame;

            % if there are sufficient stables frames, then compute energy levels
            if EyeLeftStableFrameNumber > SignificantNumberOfFramesLevels
                % case of current energy level higher than the one
                % during the stable period => the eye just closed
                if EyeLeftOPLTotalEnergyAdaptativeMean(CurrentFrame) > EyeLeftTotalOPLEnergy(CurrentFrame)
                    % updating eye opened energy level
                    EyeLeftOpenedEnergyLevel = max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
                else%if OPLTotalEnergyAdaptativeMean(CurrentFrame) < TotalOPLEnergy(CurrentFrame)
                    % updating eye opened energy level
                    EyeLeftClosedEnergyLevel = min(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
                end

                EyeLeftStateChange =1;

            end
        end
    end

    % detectting Eye State
    EyeLeftOpenClosedEnergyLimit = (EyeLeftClosedEnergyLevel+EyeLeftOpenedEnergyLevel)/2;
    % if state change imposed, then change OK, else, continue
    % updating the last state ... try to test...goal, avoid
    % false change detection when a global head mtion occurs
    if not(FaceActivity)%|| EyesAndMouthActivity || EyesActivityOnly
        if EyeLeftTotalOPLEnergy(CurrentFrame) < EyeLeftOpenClosedEnergyLimit
            if EyeLeftBinaryState==0 || EyeLeftStateChange
                EyeLeftState='EyeClosed';
                EyeLeftBinaryState =0;
                EyeLeftClosedEnergyLevel = EyeLeftClosedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*min(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
            else
                EyeLeftState='EyeOpen';
                EyeLeftBinaryState =1;
                EyeLeftOpenedEnergyLevel = EyeLeftOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
            end
        else
            if EyeLeftBinaryState==1 || EyeLeftStateChange
                EyeLeftState='EyeOpen';
                EyeLeftBinaryState =1;
                EyeLeftOpenedEnergyLevel = EyeLeftOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
            else
                EyeLeftState='EyeOpen';
                EyeLeftBinaryState =1;
                EyeLeftOpenedEnergyLevel = EyeLeftOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(EyeLeftLastStableOPLValue, EyeLeftOpenClosedEnergyLimit);
            end
        end
    else
        EyeLeftBinaryState=1;
    end
    % recording values
    EyeLeftClosedEnergyLevel_Hist(CurrentFrame) = EyeLeftClosedEnergyLevel;
    EyeLeftOpenedEnergyLevel_Hist(CurrentFrame) = EyeLeftOpenedEnergyLevel;


    %%%  Blinks/Yawnings detection end  %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %end of "if CurrentFrame < NoiseMeanInitDuration"
end

