%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% function that filters the detected faces : median + adaptative filter
%
% Input parameter : none
% Output parameter : none
% Global updated values : FaceArea ; LeftEyeArea ; RightEyeArea ; MouthArea

%Selecting ROI with mpisearch face detector trying to minimize the
%searching area
HeadDetectedInPreviousFrame=not(mpisearchDLL_Failed);
%if last head detection was ok, then search the head in the neighborhood
%of the last position
%disp('**********************************************')




if not(mpisearchDLL_Failed)
    %disp('****** Previous detection succeded')
    headminRow=uint16(max(HeadBoxRowUpIndex-HalfNrowsFace,1));
    headmaxRow=uint16(min(HeadBoxRowDownIndex+HalfNrowsFace,Nrows));
    headminColumn=uint16(max(HeadBoxColumnUpIndex-HalfMcolumnsFace,1));
    headmaxColumn=uint16(min(HeadBoxColumnDownIndex+HalfMcolumnsFace,Mcolumns));

else
    headminRow=1;
    headmaxRow=Nrows;
    headminColumn=1;
    headmaxColumn=Mcolumns;
    %beep;
end

%%%%%%%%%%%%%%%%%%%%%%%%%TEST DEBUGGGG %%%%%%%%%%%
%disp('***')
%headminRow
%     headmaxRow
%     headminColumn
%     headmaxColumn
%
%     size(CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn))
%     max(max(CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn)))
%     min(min(CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn)))
% compute current result index in the table used for median filtering
CurrentTableIndex=mod(CurrentFrame, MedianFilterSize)+1;
% class(CurrentPicture)
% class(CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn))
if ContinuousHeadDetection
    if useYUVstream&&WebcamVideoMode % case of linux...so specific mpisearch mex file

        [boxes, detects, n] = mpisearchMex(0, CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn), 1, 1, 0); %appel de mpisearch
    else
        %clear mpisearchMex
        clear mpisearchMexWindows
        %[boxes, detects, n] = mpisearchMexWindows(0, single(CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn)'), 1, 1, 0);
        headlocationArea=PhotoreceptorsOutput(headminRow:headmaxRow, headminColumn:headmaxColumn);
        % new version of the mpt toolbox .... TESTING
        [boxes, detects, n] = mpisearchMexWindows(0, single(headlocationArea'), 1, 1, 0);
        %[boxes, detects, n] = mpisearchMex(0, headlocationArea, 1, 1, 0); % slower...

    end
    % test if face detection success
    mpisearchDLL_Failed = isempty(boxes);

    if not(mpisearchDLL_Failed)
        %disp('***Face detected');
        HeadBoxRowUpIndex=boxes(3) +headminRow;
        HeadBoxRowDownIndex=boxes(4) +headminRow;
        HeadBoxColumnUpIndex=boxes(5) +headminColumn;
        HeadBoxColumnDownIndex=boxes(6) +headminColumn;
    end

    % figure(10)
    % subplot(1,3,1)
    % imagesc(CurrentPicture(headminRow:headmaxRow, headminColumn:headmaxColumn))
    % subplot(1,3,2)
    % mask=zeros(Nrows, Mcolumns);
    % mask(headminRow:headmaxRow, headminColumn:headmaxColumn)=ones(size(mask(headminRow:headmaxRow, headminColumn:headmaxColumn)));
    % mask(HeadBoxRowUpIndex:HeadBoxRowDownIndex, HeadBoxColumnUpIndex:HeadBoxColumnDownIndex)=2*ones(size(mask(HeadBoxRowUpIndex:HeadBoxRowDownIndex, HeadBoxColumnUpIndex:HeadBoxColumnDownIndex)));
    % imagesc(mask)

    DetectedFaceCenterCoord_Row(CurrentTableIndex)=(HeadBoxRowUpIndex+HeadBoxRowDownIndex)/2;
    DetectedFaceCenterCoord_Column(CurrentTableIndex)=(HeadBoxColumnUpIndex+HeadBoxColumnDownIndex)/2;
else
    DetectedFaceCenterCoord_Row(CurrentTableIndex)=(HeadBoxRowUpIndex+HeadBoxRowDownIndex)/2;
    DetectedFaceCenterCoord_Column(CurrentTableIndex)= (HeadBoxColumnUpIndex+HeadBoxColumnDownIndex)/2;
end




% compute median values
RowFaceCenter=median(DetectedFaceCenterCoord_Row)+(1/9*NrowsFace);
ColumnFaceCenter=median(DetectedFaceCenterCoord_Column);

%debug informations
% CurrentFrame
% ColumnLeftUpCorner

if HeadDetectedInPreviousFrame && RowFaceCenter<Nrows-HalfNrowsFace && RowFaceCenter>HalfNrowsFace && ColumnFaceCenter<Mcolumns-HalfMcolumnsFace && ColumnFaceCenter>HalfMcolumnsFace

    RowLeftUpCorner=round(RowLeftUpCorner*alphaFaceLocation+(1-alphaFaceLocation)*(RowFaceCenter-HalfNrowsFace));
    ColumnLeftUpCorner=round(ColumnLeftUpCorner*alphaFaceLocation+(1-alphaFaceLocation)*(ColumnFaceCenter-HalfMcolumnsFace));

    RowRightDownCorner=RowLeftUpCorner+NrowsFace-1;
    ColumnRightDownCorner=ColumnLeftUpCorner+McolumnsFace-1;

else
    % 'detection failed'
end

% Extracting face area
FaceArea =  CurrentPicture(RowLeftUpCorner:RowRightDownCorner, ColumnLeftUpCorner:ColumnRightDownCorner);
%subplot(1,3,3)
%imagesc(FaceArea)


% define integration area of the head motion (2 times the
% bounding box of the face in order to get more details: hairs
% etc)

if RowLeftUpCorner-velocitiesBorderFaceOffsetRows<1
    %debugVelocityRow='rowTwoHigh';
    rowStart = 1;
    rowEnd = velocitiesRows;
elseif RowRightDownCorner+velocitiesBorderFaceOffsetRows >Nrows
    %debugVelocityRow='rowtoLow';
    rowStart = Nrows-velocitiesRows+1;
    rowEnd = Nrows;
else
    %debugVelocityRow='rowIdle';
    rowStart = RowLeftUpCorner-velocitiesBorderFaceOffsetRows;
    rowEnd = rowStart+velocitiesRows-1;
end

if ColumnLeftUpCorner-velocitiesBorderFaceOffsetColumns<1
    %debugVelocityColumn='ColTwoLeft';
    columnStart = 1;
    columnEnd = velocitiesColumns;
elseif ColumnRightDownCorner+velocitiesBorderFaceOffsetColumns >Mcolumns
    %debugVelocityColumn='colTwoRight';
    columnStart = Mcolumns-velocitiesColumns+1;
    columnEnd = Mcolumns;
else
    %debugVelocityColumn='colIdle';
    columnStart = ColumnLeftUpCorner-velocitiesBorderFaceOffsetColumns;
    columnEnd = columnStart+velocitiesColumns-1;
end



% Extracting face area
Face_OPL = RetinaOutput(RowLeftUpCorner:RowRightDownCorner, ColumnLeftUpCorner:ColumnRightDownCorner);
Face_IPL = MagnoYOutput(RowLeftUpCorner:RowRightDownCorner, ColumnLeftUpCorner:ColumnRightDownCorner);

% locate motion activity localization : global head or localised (eyes or
% mouth)

% get IPL response on the face area (large view, same as the one used for
% velocity), eyes area and mouth area

% Modifier par LUONG Hong Viet
% IPLenergyLocationAroundFace=MagnoYOutput(rowStart:rowEnd, columnStart:columnEnd);

IPLenergyLocationAroundFace=Face_IPL;
IPLenergyEyesArea = Face_IPL(1:floor(NrowsFace/3), :);
IPLenergyMouthArea = Face_IPL(HalfNrowsFace:NrowsFace, McolumnsFace/4:McolumnsFace*3/4);


IPLenergyHigherArea=Face_IPL(1:HalfNrowsFace, :);
IPLenergyLowerArea=Face_IPL(HalfNrowsFace:NrowsFace, :);

% get the total energy in these areas
FaceIPLtotalEnergy=sum(sum(IPLenergyLocationAroundFace.*IPLenergyLocationAroundFace));
EyesIPLtotalEnergy=sum(sum(IPLenergyEyesArea.*IPLenergyEyesArea));
MouthIPLtotalEnergy=sum(sum(IPLenergyMouthArea.*IPLenergyMouthArea));



HigherAreaIPLtotalEnergy=sum(sum(IPLenergyHigherArea.*IPLenergyHigherArea));
LowerAreaIPLtotalEnergy=sum(sum(IPLenergyLowerArea.*IPLenergyLowerArea));

% FaceActivity= FaceIPLtotalEnergy>3*(EyesIPLtotalEnergy+MouthIPLtotalEnergy);
if CurrentFrame==180
    disp('start');
end


%     EyesActivityOnly=(FaceIPLtotalEnergy-EyesIPLtotalEnergy)<(FaceIPLtotalEnergy/8);
%     MouthActivityOnly=(FaceIPLtotalEnergy-MouthIPLtotalEnergy)<(FaceIPLtotalEnergy/8);
EyesActivity=(HigherAreaIPLtotalEnergy-EyesIPLtotalEnergy)<(HigherAreaIPLtotalEnergy/7);
MouthActivity=(LowerAreaIPLtotalEnergy-MouthIPLtotalEnergy)<(LowerAreaIPLtotalEnergy/7);

if  (EyesActivity && MouthActivity)%(MouthActivityOnly1 && EyesActivityOnly)%||

    %         EyesAndMouthActivity=(FaceIPLtotalEnergy-MouthIPLtotalEnergy-EyesIPLtotalEnergy)<(FaceIPLtotalEnergy/10);
    EyesAndMouthActivity=1;
else
    EyesAndMouthActivity=0;
    if not(EyesActivity)&&not(MouthActivity)
        FaceActivity=1;
    else
        FaceActivity=0;
    end
end

%%%% Save Data history
if not(FaceActivity)
    MotionEnergyEyes(CurrentFrame)=EyesIPLtotalEnergy;
    MotionEnergyMouth(CurrentFrame)=MouthIPLtotalEnergy;
else    
    MotionEnergyEyes(CurrentFrame)=0;
    MotionEnergyMouth(CurrentFrame)=0;
end


% if HeadMotionAlert%or HeadMotionEvent %(more alerts, not dependent on motion direction and its lenght)
%     %disp('HeadNod')
%     FaceActivity=1;
% end

% if EyesActivity
%     disp('EyeMotion')
%     %disp('end');
% end
% 
% if MouthActivity
%     disp('MouthMotion')
% end
% 
% if EyesAndMouthActivity
%     disp('MouthMotion+Eye Motion')
% end

%
% figure(10)
% subplot(1,4,1)
% imagesc(IPLenergyLocationAroundFace);
% axis image
% subplot(1,4,2)
% imagesc(IPLenergyEyesArea);
% axis image
% subplot(1,4,3)
% imagesc(IPLenergyMouthArea);
% axis image
% colormap gray
% subplot(1,4,4)
% plot([FaceIPLtotalEnergy EyesIPLtotalEnergy MouthIPLtotalEnergy]);

