%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop)
%
% Alexandre Benoit, Philippe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% script that research the face in the video stream for the first time and
% initializes the first tables related to this face size

global CurrentFigureHandles initMainWindowOK Nrows Mcolumns
clear mex;
initMainWindowOK=false;
% prepare video input data for matrix sizes
if WebcamVideoMode==1
    if not(useYUVstream)
        a=vcapg2;
        answer=input('Check the webcam parameters and hit RETURN');
    end
else
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % read the movie if needed

    if ImageSequenceMode
        [filename  pathname] = uigetfile('*.*', 'Choose a picture of the image sequence');
    elseif MatGrayInputFile
        % test .mat input file
        [filename  pathname] = uigetfile('*.*', 'Choose a mat file to load gray levels image sequence');
        if isequal(filename,0) || isequal(pathname,0)
            disp('User pressed cancel')
        else

            matFile= [pathname filename]
            load(matFile)
        end
    elseif not(useYUVstream)
        if not(VideoDataBaseAnalysis||SingleFileDirectComputing)
            [filename  pathname] = uigetfile('*.avi', 'Choose a video');
            %fileinfo = aviinfo(filename)
            if isequal(filename,0) || isequal(pathname,0)
                disp('User pressed cancel')
            else
                movie = aviread([pathname filename]);
                [x MovieLenght] = size(movie);
                MovieStop = min(MovieStop,MovieLenght)
            end
        else
            ['reading file: ' videoPathAndName]
            movie = aviread(videoPathAndName);
            [x MovieLenght] = size(movie);
            MovieStop = min(MovieStop,MovieLenght)
        end
    end

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Variables Allocation
if WebcamVideoMode == 1
    if useYUVstream
        CameraSizeRows=320;
        CameraSizeColumns=240;

        FirstRGBPicture=uint8(zeros(CameraSizeColumns, CameraSizeRows));
        YUVPicture=uint8(zeros(CameraSizeRows, CameraSizeColumns));

        FirstRGBPicture=GrabFrame; %avec la lib de lionel
        %AcquisitionLinux1394(YUVPicture);
        %FirstRGBPicture=YUVPicture';
    else
        FirstRGBPicture = vcapg2;
    end

else
    % first picture region selection

    if ImageSequenceMode

    elseif MatGrayInputFile
        % test .mat input file
        FirstRGBPicture = squeeze(Im(:,:,CurrentFrame));

    elseif useYUVstream
        %Modified by PN 06/02/2006
        %filename
        YUVPicture = ConvertYUV2AVI(filename, CurrentFrame,offlineYUVwidth,offlineYUVheight);
        FirstRGBPicture=YUVPicture(:,:,1)'; %AB
    else
        FirstRGBPicture = movie(CurrentFrame).cdata;
    end

    %??????????????????????? hemhemheeeemmmmm
    if CurrentFrame<MovieLenght
        CurrentFrame=CurrentFrame+1;
    end




end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% global variables Initialisation
[Nrows Mcolumns nbLayers] = size(FirstRGBPicture)
if OnlyUseUpperHalfPartOfFrame
  Nrows=Nrows/2;
end
if MatGrayInputFile
    MovieLenght=nbLayers
end

% On and Off cells outputs init
%RetinaOutput_ON=zeros(Nrows, Mcolumns);
%RetinaOutput_OFF=zeros(Nrows, Mcolumns);

% Low pass filter on ON and OFF outputs before IPL input
%RetinaOutput_ON_LP=zeros(Nrows, Mcolumns);
%RetinaOutput_OFF_LP=zeros(Nrows, Mcolumns);

%%%%% Prefiltering variables
%PhotoreceptorsOutput = zeros(Nrows, Mcolumns);
%RetinaFirstStageOutput = zeros(Nrows, Mcolumns);
%RetinaSecondStageOutput = zeros(Nrows, Mcolumns);
RetinaOutput = zeros(Nrows, Mcolumns);
PLIOutput = zeros(Nrows, Mcolumns);
%MagnoYOutput = zeros(Nrows, Mcolumns);
%AmacrinCellsTempOutput_ON = zeros(Nrows, Mcolumns);
%AmacrinCellsTempOutput_OFF = zeros(Nrows, Mcolumns);
%MagnoXOutputON = zeros(Nrows, Mcolumns);
%MagnoXOutputOFF = zeros(Nrows, Mcolumns);

tempMemory1 = zeros(Nrows, Mcolumns);
tempMemory2 = zeros(Nrows, Mcolumns);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% Face detection %%%%%%%%%%%%
% plan : 1:detection de visage
%        2:detection des yeux
%        3:initialisation des tailles de matrices utilisees
ValidFaceDetection=0;
CurrentFrame=1;
while ValidFaceDetection~=1 % OpenEnterfaceTest

    %close all
    %figure;
    mpisearchDLL_Failed =1;
    

    while mpisearchDLL_Failed && CurrentFrame<MovieLenght
        % Get a frame in which the first face detection will occur
        AcquireVideoFrame
        CurrentFrame=CurrentFrame+1;

        % TEST OpenEnterface in the case of no head motion detection...
        if TestOpenEnterfaceNoFaceDetection
            mpisearchDLL_Failed=0;
        else
            if useYUVstream&&WebcamVideoMode % case of linux...so specific mpisearch mex file
                [boxes, detects, n] = mpisearchMex(0, double(FirstRGBPicture)/255, 1, 1, 0);
                %Test='LinuxMode'
            else

                % in order to enhance the face detection, first step is to correct
                % the luminance
                photoreceptorsCoefs=InitSpatialLPFilter( 0, 0, 10);
                output=zeros(Nrows, Mcolumns);
                PhotoreceptorsCompression(CurrentPicture, output, Nrows, Mcolumns, photoreceptorsCoefs);

                [boxes, detects, n] = mpisearchMexWindows(0, single(output)', 1, 1, 0);
                %[boxes, detects, n] = mpisearchMexWindows(0, single(RGB2grayC(AcquiredPicture)'), 1, 1, 0);
                %Test='WindowsMode'
                
            end

            mpisearchDLL_Failed = isempty(boxes); % test face detection success
            if not(HeadMotionDirectionDemoMode~=-1)
%                 subplot(1,1,1)
%                 imshow(AcquiredPicture);
%                 title('Trying to find Head, please wait...stay in front of the camera');
%                 drawnow;
            end
        end

    end
    TestOpenEnterfaceNoFaceDetection

    if TestOpenEnterfaceNoFaceDetection
        HeadBoxRowUpIndex=1;
        HeadBoxRowDownIndex=Nrows;
        HeadBoxColumnUpIndex=1;
        HeadBoxColumnDownIndex=Mcolumns;
    else
        CurrentFrame
        if mpisearchDLL_Failed
            disp('no face detected');
            initFailed=true
            return
        else
            HeadBoxRowUpIndex=boxes(3);
            HeadBoxRowDownIndex=boxes(4);
            HeadBoxColumnUpIndex=boxes(5);
            HeadBoxColumnDownIndex=boxes(6);
        end
    end


    % round it to the nearest power of two (required to compute ffts faster)
    [HeadBoxColumnUpIndex HeadBoxColumnDownIndex]=PowerOf2Spacing(HeadBoxColumnUpIndex, HeadBoxColumnDownIndex);
    [HeadBoxRowUpIndex HeadBoxRowDownIndex]=PowerOf2Spacing(HeadBoxRowUpIndex, HeadBoxRowDownIndex);

    %subplot(1,2,1);
    %imshow(FirstRGBPicture);
    %subplot(1,2,2);
    %imshow(AcquiredPicture(HeadBoxRowUpIndex:HeadBoxRowDownIndex, HeadBoxColumnUpIndex:HeadBoxColumnDownIndex, :));
    %title('Face Detected, please, press 1 if detection is OK, the 2 eyes and mouth must appear')
    %%%% old method o validate the face detection : keyboard input

    if not(TestOpenEnterfaceNoFaceDetection)

        %ValidFaceDetection = input('Face Detected, please, press 1 if detection is OK'); % Test OpenEnterface => no face detection

        % test : min head box > 15*15 pixels
        if (HeadBoxColumnDownIndex-HeadBoxColumnUpIndex>15) && (HeadBoxRowDownIndex-HeadBoxRowUpIndex>15)
            ValidFaceDetection = 1;
        else
            ValidFaceDetection = 0;
        end
    else
        ValidFaceDetection = 1;
    end

end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Define Head Window size/position

alphaFaceLocation=0.05;
FaceArea=FirstRGBPicture(HeadBoxRowUpIndex:HeadBoxRowDownIndex, HeadBoxColumnUpIndex:HeadBoxColumnDownIndex, 1);
[NrowsFace McolumnsFace NBLayers] = size(FaceArea);

HalfNrowsFace=uint16(NrowsFace/2);
HalfMcolumnsFace=uint16(McolumnsFace/2);

FirstStageInitCheck=1;
RowLeftUpCorner=HeadBoxRowUpIndex;
ColumnLeftUpCorner=HeadBoxColumnUpIndex;
RowRightDownCorner=RowLeftUpCorner+NrowsFace-1;
ColumnRightDownCorner=ColumnLeftUpCorner+McolumnsFace-1;

RowFaceCenter=(HeadBoxRowUpIndex+HeadBoxRowDownIndex)/2;
ColumnFaceCenter=(HeadBoxColumnUpIndex+HeadBoxColumnDownIndex)/2;

minRow=1;
maxRow=Nrows;
minColumn=1;
maxColumn=Mcolumns;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% loop on the number of frames in the video

% loop init
CurrentFrame=MovieStart;

% Frame computing time variables
FrameComputingTime = zeros(1, MovieStop);

% FPS variables used to improve yes / no detection
FPSmean = 30;
alpaFPS = 0.99;
alphaFPSopp = 1-alpaFPS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Face Area detection median filter parameters/variables
MedianFilterSize=5;
SortCenter=round(MedianFilterSize/2);

DetectedFaceCenterCoord_Row=zeros(MedianFilterSize,1);
DetectedFaceCenterCoord_Column=zeros(MedianFilterSize,1);

DetectedLeftEyeCenterCoord_Row=zeros(MedianFilterSize,1);
DetectedLeftEyeCenterCoord_Column=zeros(MedianFilterSize,1);

DetectedRightEyeCenterCoord_Row=zeros(MedianFilterSize,1);
DetectedRightEyeCenterCoord_Column=zeros(MedianFilterSize,1);

DetectedMouthCenterCoord_Row=zeros(MedianFilterSize,1);
DetectedMouthCenterCoord_Column=zeros(MedianFilterSize,1);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%% Eye/Mouth size init

% searchng areas for each eyes
EyeLeftArea = FaceArea(1:HalfNrowsFace, 1:HalfMcolumnsFace);
EyeRightArea = FaceArea(1:HalfNrowsFace, HalfMcolumnsFace:McolumnsFace-1);

BinaryEyeLeftArea = zeros(size(EyeLeftArea));
BinaryEyeRightArea = zeros(size(EyeRightArea));

EnergyLabelInEyeLeftArea = zeros(size(EyeLeftArea));

[EyesSearchAreaNRows EyesSearchAreaMcolumns]= size(EyeLeftArea);

EyeLeftArea_LP_H = zeros(EyesSearchAreaNRows, EyesSearchAreaMcolumns);
EyeRightArea_LP_H = zeros(EyesSearchAreaNRows, EyesSearchAreaMcolumns);


EyeLeftArea_LP_V = zeros(EyesSearchAreaNRows, EyesSearchAreaMcolumns);
EyeRightArea_LP_V = zeros(EyesSearchAreaNRows, EyesSearchAreaMcolumns);


EyeLeftUp = 1;
EyeLeftDown = round(HalfNrowsFace/2);
EyeLeftLeft = 1;
EyeLeftRight = round(HalfMcolumnsFace/2);

EyeRightUp = 1;
EyeRightDown = round(HalfNrowsFace/2);
EyeRightLeft = HalfMcolumnsFace+1;
EyeRightRight = McolumnsFace-round(HalfMcolumnsFace/2);

MouthUp = HalfNrowsFace+1;
MouthDown = NrowsFace;
MouthLeft = floor(HalfMcolumnsFace/2);
MouthRight =floor(McolumnsFace*3/4)-1;

[MouthRowUpLimit, MouthRowDownLimit] = PowerOf2Spacing(HalfNrowsFace, NrowsFace);
[MouthColumnLeftBorderLimit,  MouthColumnRightBorderLimit] = PowerOf2Spacing(HalfMcolumnsFace/4, McolumnsFace*7/8);

EyeLeft = FaceArea(EyeLeftUp:EyeLeftDown,EyeLeftLeft:EyeLeftRight);
EyeRight = FaceArea(EyeRightUp:EyeRightDown, EyeRightLeft:EyeRightRight);
Mouth   = FaceArea(MouthUp:MouthDown, MouthLeft:MouthRight);
% figure
% figure(10)
% imagesc(Mouth)
% colormap gray
% figure

[NrowsEye McolumnsEye] = size(EyeLeft);
[NrowsEye McolumnsEye] = size(EyeRight);
[NrowsMouth McolumnsMouth] = size(Mouth);


HalfNrowsEye = floor(NrowsEye/2);
HalfMcolumnsEye = floor(McolumnsEye/2);

FaceAreaDisplay = zeros(NrowsFace, McolumnsFace);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Motion detection parameters %%%%

alphaMotion = 0.0;% parameter for temporal velocity mean calculation, 0: no stabilization; 1:full mean computing; prefer values between 0.1 to 0
VerticalAdaptativeMean=0;
HorizontalAdaptativeMean=0;

% % Detection Display
% subplot(2,3,1)
% imagesc(FirstRGBPicture);
% axis image
% axis off
%
% subplot(2,3,2)
% imagesc(FaceArea);
% axis image
% axis off
%
% subplot(2,3,4)
% imagesc(EyeLeft);
% axis image
% axis off
%
% subplot(2,3,5)
% imagesc(EyeRight);
% axis image
% axis off
%
% subplot(2,3,6)
% imagesc(Mouth);
% axis image
% axis off

HeadMotionSpeed=zeros(1, MovieStop);
HeadMotionOrientation=zeros(1, MovieStop);
HeadMotionMedianFilterSize=7;
HeadMotionEventTable=zeros(1,HeadMotionMedianFilterSize);

HeadMotionDirectionMedianFilterSize=3;
HeadMotionDirectionEventTableInit=zeros(1, HeadMotionDirectionMedianFilterSize);
H_HeadMotionDirectionEventTable=zeros(1, HeadMotionDirectionMedianFilterSize);
V_HeadMotionDirectionEventTable=zeros(1, HeadMotionDirectionMedianFilterSize);


HorizontalHeadMotion=0;
VerticalHeadMotion=0;
FaceActivity=0;
MouthActivityOnly=0;
EyesAndMouthActivity=0;
HeadMotionAlert=0;
