/*** Mex Function that grabs YUV frames on a IEEE1394 camera device ****/

//for compyling the file:
/* mex GrabFrame.cpp ieee1394_fgrabber.so -I/usr/include/libdc1394 -L/usr/lib -ldc1394_control -lraw1394 -L/usr/local/matlab7/bin/glnx86 -leng -lmx -lmat -lmex -lm -lpthread -Wl,-rpath,/usr/local/matlab7/bin/glnx86 -Wl,-rpath,/home/stage/ngo/Desktop/GUI_HeadtrackingAndAnalysisTEST/lio
 */
#define _DEBUGLOOP
#define _DEBUGSTD
#define _VERSIONTRANSPOSEE

extern "C"
{
    #include "mex.h" /* oblig pour l'utiliser avec matlab */
    //#include <string.h>
}

#include "IEEE1394_FrameGrabber.h" /* je pense qu'il faut ca */

/* Define the size of the frames */
#define NBrows    240
#define NBcolumns 320
#define FrameRate 30

static IEEE1394_FrameGrabber* IEEEDeviceToGrab;
/* dclare un objet qui va rester initialis  chaque appel de cette fonction
 * je crois que c'est ca  (qu'il faut faire d'aprs Lio */


/* ta fonction interface matlab -> C avec tj les mme param : un compteur
 de param de sortie nlhs et son tableau de variable de sortie plhs, idem pour les entre
 compteur entre = nrhs et tab d'entre = prhs */
extern "C" void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    static bool NotInitialized = true; /* pout voir si la fonction a dj t apelle / camra dj configure */
    #ifdef VERSIONTRANSPOSEE
    int pixelIndex, TableDims[2]={NBcolumns,NBrows};
    #else
    int pixelIndex, TableDims[2]={NBrows,NBcolumns};
    #endif
    YUV422Vectors *GrabbedFrame;
    unsigned char* outputBuffer;
    #ifdef DEBUGLOOP
        unsigned char CurrentPixel;
    #endif
    
    #ifdef DEBUGSTD
        mexPrintf("\nEntering GrabFrame");
    #endif
    
    /* test if dll has been previously called i.e. initialized */
    if(NotInitialized)
    {
        NotInitialized=false;
        
        /* init the cam */
        IEEEDeviceToGrab= new IEEE1394_FrameGrabber(0,0,1,FrameRate);
         #ifdef DEBUGLOOP
        IEEEDeviceToGrab->printphilou(); //juste pour tester si la lib .mexglx marche!! ce qui n'est pas le cas!!!!
         #endif
    }
    /* Grab a frame */
    GrabbedFrame=IEEEDeviceToGrab->getYUV422Vectors();
    
    /* Create the NBrows*NBcolumns uint8 output matrix */
    if( (plhs[0]=mxCreateNumericArray(2, TableDims, mxUINT8_CLASS, mxREAL)) == NULL)
        mexErrMsgTxt("Memory allocation (output Velocity Labelled areas matching results)");
    
    /* Get pointer to the created buffer TAKE CARE OF THE FORMAT... or it will crash on the loop*/
    outputBuffer =(unsigned char*) mxGetPr(plhs[0]);
    //memmove(outputBuffer,GrabbedFrame->y,NBcolumns*NBrows*sizeof(char));
    #ifdef VERSIONTRANSPOSEE
    memcpy(outputBuffer,GrabbedFrame->y,NBrows*NBcolumns*sizeof(unsigned char));
    /*ATTENTION DANS LE FICHIER DE TEST MATLAB, il faut ecrire:
        CameraSizeRows=320;
        CameraSizeColumns=240;

        FirstRGBPicture=uint8(zeros(CameraSizeColumns, CameraSizeRows));
        FirstRGBPicture=GrabFrame;
        imshow(FirstRGBPicture');
     */
        /* take care of the coding of YUV422 in order to do the correct copy
         because the output of the mexfunction is only gray level !!! so not Y and U and V but only Y
         and if I remember comme il faut, c'tait un codage YUYV i.e. quelque chose comme frame i tu as Y et U et  la frame suivante i+1, tu as Y et V*/
    #else 
    int IdRow=0;
    int IdColumn=0;

    for (IdColumn=0;IdColumn<NBcolumns;IdColumn++)
    {
        for (IdRow=0;IdRow<NBrows;IdRow++)
        {
            #ifdef DEBUGLOOP
            outputBuffer[IdRow+NBrows*IdColumn]=CurrentPixel=GrabbedFrame->y[IdColumn+NBcolumns*IdRow];
            mexPrintf("\nCurrentPixel (%d, %d)=%c", IdRow, IdColumn, CurrentPixel);
            #endif
            outputBuffer[IdRow+NBrows*IdColumn]=GrabbedFrame->y[IdColumn+NBcolumns*IdRow];
        }
    }
   /* ATTENTION DANS LE FICHIER DE TEST MATLAB, il faut ecrire:
        CameraSizeRows=320;
        CameraSizeColumns=240;

        FirstRGBPicture=uint8(zeros(CameraSizeColumns, CameraSizeRows));
        FirstRGBPicture=GrabFrame;
        imshow(FirstRGBPicture);
    */
    #endif
    delete[] GrabbedFrame->y;
    delete[] GrabbedFrame->u;
    delete[] GrabbedFrame->v;
    delete GrabbedFrame;
}
