#include "./IEEE1394_FrameGrabber.h"

#define clip_8_bit(val) {if (val < 0) val = 0; else if (val > 255) val = 255;}

void IEEE1394_FrameGrabber::yuy2Toyuv(unsigned char *y, unsigned char *u, unsigned char *v, unsigned char *input,int height,int width){
  
  for (int i=0;i<width*height/2;i++){
    /*
       * packed YUV 422 is: Y[i] U[i] Y[i+1] V[i]
       */
      *(u++) = *(input++);
      *(y++) = *(input++);
      *(v++) = *(input++);
      *(y++) = *(input++);
  }
}

void IEEE1394_FrameGrabber::cleanup(void) {
  dc1394_dma_unlisten( this->_handle, &this->_camera );
  dc1394_dma_release_camera(this->_handle, &this->_camera);
  dc1394_stop_iso_transmission(this->_handle, this->_camera.node);
  dc1394_destroy_handle(this->_handle);
}

void IEEE1394_FrameGrabber::printphilou(void)
{
    std::cout<<"coucou ca marche"<<std::endl;
}

void IEEE1394_FrameGrabber::setupCameraParam(int resID,int formatID,int framerateID){
  switch(resID){  
  case 0 /*MODE_320x240_YUV422*/:
    this->_res = MODE_320x240_YUV422;
    this->_device_width=320;
    this->_device_height=240;
    break;	
  case 1 /*MODE_640x480_YUV422*/:
    this->_res = MODE_640x480_YUV422;
    this->_device_width=640;
    this->_device_height=480;
    break;
  case 2 /*MODE_640x480_MONO*/:
    this->_res = MODE_640x480_MONO;
    this->_device_width=640;
    this->_device_height=480;
    break;
  default:
    DEBUGERR("Invalid resolution! "<<resID<<". Try 0(=MODE_320x240_YUV422),1(=MODE_640x480_YUV422) or 2(=MODE_640x480_MONO).");
    exit(-1);
    break;
  }
  //TODO:
  this->_fps = FRAMERATE_30;
  this->_format=FORMAT_VGA_NONCOMPRESSED;
  this->_PixelsDataSize=1;
}

IEEE1394_FrameGrabber::IEEE1394_FrameGrabber(int camID,int resID,int formatID,int framerateID):NUM_BUFFERS(5),_DROP_FRAMES(1),_device_width(-1),_device_height(-1), _format(-1),_cameraPort(0),_fps(-1),_res(-1),_channel(0),_speed(0),_device_name(NULL),_PixelsDataSize(-1){
  setupCameraParam(resID,formatID,framerateID);

  raw1394handle_t raw_handle;
  nodeid_t* camera_nodes=NULL;
  int camCount;
  raw_handle = raw1394_new_handle();
  raw1394_set_port(raw_handle, this->_cameraPort );
  camera_nodes = dc1394_get_camera_nodes(raw_handle, &camCount, 0);
  raw1394_destroy_handle(raw_handle);

  if(camID>=camCount){
    DEBUGERR("Invalid camera id: "<<camID<< " camCount: "<<camCount);
    exit(1);
  }

  this->_handle = dc1394_create_handle(_cameraPort);
  this->_camera.node = camera_nodes[camID];
  if (dc1394_get_iso_channel_and_speed(this->_handle, this->_camera.node,&this->_channel, &this->_speed)!= DC1394_SUCCESS){
    DEBUGERR("unable to get the iso channel number\n");
    cleanup();
    exit(-1);
  }

  if (dc1394_dma_setup_capture(this->_handle, this->_camera.node, this->_channel ,this->_format, this->_res,this->_speed, this->_fps, NUM_BUFFERS, this->_DROP_FRAMES, this->_device_name, &this->_camera)!= DC1394_SUCCESS) {
    DEBUGERR("unable to setup camera- check to make sure that the video mode,framerate and format are supported\n");
    cleanup();
    exit(-1);
  }
 
  if (dc1394_start_iso_transmission(this->_handle, this->_camera.node)!=DC1394_SUCCESS){
    DEBUGERR("unable to start camera iso transmission");
    perror("unable to start camera iso transmission\n");
    cleanup();
    exit(-1);
  }
  DEBUG(this->_camera.quadlets_per_frame);
  DEBUG(this->_camera.quadlets_per_packet);
  dc1394_free_camera_nodes(camera_nodes); 
}

unsigned char* IEEE1394_FrameGrabber::getRawFrame(){
  long len=this->_device_height*this->_device_width*this->_PixelsDataSize;
  DEBUG("len: "<<len);
  unsigned char* buf=new unsigned char[len];
  return getRawFrame(len,buf);
}

unsigned char* IEEE1394_FrameGrabber::PeekFrame(){
  dc1394_dma_single_capture(&this->_camera);
  return (unsigned char* )this->_camera.capture_buffer;
}

unsigned char* IEEE1394_FrameGrabber::getRawFrame(long len,unsigned char* buf){
  memcpy(buf,PeekFrame(),len);
  dc1394_dma_done_with_buffer(&this->_camera);
  return buf;
}

YUV422Vectors* IEEE1394_FrameGrabber::getYUV422Vectors(){
  YUV422Vectors* yuv=new YUV422Vectors(PeekFrame(),this->_device_height,this->_device_width);
  dc1394_dma_done_with_buffer(&this->_camera);
  return yuv;
}

YUV422Matrices* IEEE1394_FrameGrabber::getYUV422Matrices(){
  YUV422Matrices* yuv=new YUV422Matrices(PeekFrame(),this->_device_height,this->_device_width);
  dc1394_dma_done_with_buffer(&this->_camera);
  return yuv;
}

