#ifndef _IEEE1394_FrameGrabber_H
#define _IEEE1394_FrameGrabber_H


#include "baseheader.h"
#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <string>
#include <libraw1394/raw1394.h>
#include <libdc1394/dc1394_control.h>

class YUV422Matrices;
class YUV422Vectors;

class IEEE1394_FrameGrabber{
 protected:
  const int NUM_BUFFERS;
  int _DROP_FRAMES;
  nodeid_t _camera_node;
  raw1394handle_t _handle;
  dc1394_cameracapture _camera;
  long _device_width,_device_height,_format;
  dc1394_feature_set _features;
  int _cameraPort,_fps,_res;
  unsigned int _channel,_speed;
  char *_device_name;
  int _PixelsDataSize;
 
  void cleanup(void);
  
  void setupCameraParam(int resID,int formatID,int framerateID);
  
  unsigned char* PeekFrame();

 public:
  IEEE1394_FrameGrabber(int camID,int resID,int formatID,int framerateID);
  ~IEEE1394_FrameGrabber(){
    cleanup();
  }
  
  void printphilou(void);
  
  YUV422Matrices* getYUV422Matrices();

  YUV422Vectors* getYUV422Vectors();
  
  unsigned char* getRawFrame();
  
  unsigned char* getRawFrame (long len,unsigned char* buf);
  
  static void yuy2Toyuv(unsigned char *y, unsigned char *u, unsigned char *v, unsigned char *input,int width, int height);
  
};


class YUV422Matrices{
 public:
    unsigned char** y;
    unsigned char** u;
    unsigned char** v;
    
    YUV422Matrices(unsigned char* input,int h,int w):y(NULL),u(NULL),v(NULL){
      int len=w*h;
      this->y=new unsigned char*[h];
      this->u=new unsigned char*[h];
      this->v=new unsigned char*[h];
      (this->y)[0]=new unsigned char[len];
      (this->u)[0]=new unsigned char[len/2];
      (this->v)[0]=new unsigned char[len/2];
      IEEE1394_FrameGrabber::yuy2Toyuv((this->y)[0],(this->u)[0],(this->v)[0],input,h,w);
      int w2=w/2;
      for(int i=0;i<h;i++){
	(this->y)[i]=(this->y)[0]+i*w;
	(this->u)[i]=(this->u)[0]+i*w2;
	(this->v)[i]=(this->v)[0]+i*w2; 
      }
      
    }
};


class YUV422Vectors{
 public:
  unsigned char* y;
  unsigned char* u;
  unsigned char* v;
  YUV422Vectors(unsigned char* input,int h,int w):y(NULL),u(NULL),v(NULL){
    int len=w*h;
    this->y=new unsigned char[len];
    this->u=new unsigned char[len/2];
    this->v=new unsigned char[len/2];
    IEEE1394_FrameGrabber::yuy2Toyuv(this->y,this->u,this->v,input,h,w);
  }
};

#endif
