%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test program that analyses (head) motion in a video using a Spatio
% Temporal retinal filter %
% This version uses a gabor rosace to compute the LogPolar conversion...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global ContinueAnalysis AlarmEyesClosed 

%function Finish = YesNoFinder(a)

%addpath /home/lawson/third_part_lib/GUI_HeadtrackingAndAnalysisTEST/MPT_04_Levi2
%addpath ~/Desktop/GUI_HeadtrackingAndAnalysisTEST/MPT
% open tcp ip connection, 'adress', port number

Finish = 0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% matlab Init
clc
%clear all
%close all
%clear mex

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% variables manual init


global Nrows Ncolumns





%made by philou%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%open tcp ip connection, 'adress', port number
%useTCPConnexion=0;
%if (useTCPconnection==1)
%addpath ~/Desktop/GUI_HeadtrackingAndAnalysisTEST/tcpip/
%addpath tcpip
%end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



testFaceLogPolarSpectrum =0;% if not(0) -> display log polar spectrum of the OPL filtered face instead of IPL output display

MotionDisplay=0;% no motion is displayed in this algo
FPSmeanRecordedVideo = 25;

InterpretationDisplay=1; %  if 1 : display the interpretation figures on the 'live' window

%%%%%%%%%%%%%%%%%%%%%%%
% general detection parameters
ActivateNoiseMean =1; % set to 0 if no need to take care of the spatioTemporal noise, set to 1 else
NoiseMeanInitDuration=15;
SignificantNumberOfFramesLevels = 2;

%%%%%%%%%%%%%%%%%%%%%%%
% concerning OUI NON filters
FaceEventNumberCount = 4; % to detect a succesion of 4 oriented motion and consider them as a 'yes' or 'no' attitude

%%%%%%%%%%%%%%%%%%%%%%%
UseSpectrum = 1;    % use 1 if spectrum has to be computed
ActivateSalency =0;      % use 1 if Salency has to be computed
% MoviePicture Index (start/stop)
MovieStart = 1;
MovieLenght = 100000;
MovieStop = 100000;
MovieStep = 1;
CurrentFrame=10;

% Initialisation parameters
NBanglesFace = 25;%45;35;55
NBradiusFace = 7;%31;15;35
MaxRadius = 0.3;%0.45
FilterPrecision = 100;
NBanglesFaceInside = 15;%45;35;55
NBradiusFaceInside = 7;%31;15;35
AnglesWindowHalfSize=5;


%%%%%%%%%%%%%%%%%%%%%%%
% concerning MotionType detection

if SaveVideoOutput ==1
    % Creat a movie file to record the computed correlation
    CorrelationMovie = avifile('MovieAnalyseRotations.avi');
    CorrelationMovie.compression = 'none';
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialising each filter

%%%% SpatioTemporal Filtering Init : first retina filter (just after frame read)
beta_1 =0;  %   bon :0
tau_1 = 0.1;  %   bon :1
k_1 = 0.5;    %   bon :5

beta_2 =0;%   bon :0.1
tau_2 = 0.1;  %   bon :2
k_2 = 5;    %   bon :6
% Init Standart Retina Filter (First Retina Filtering)
FirstRetinaCoefTable = InitRealRetinaFilter(beta_1, tau_1, k_1, beta_2, tau_2, k_2);

PhotoreceptorsCoefTable=InitSpatialLPFilter( 0, tau_1/2, (k_1+k_2)/2);

% Temporal parameter of the IPL stage
tauIPL=1.6; % old working value 3.0 %temporal cut frequency of the IPL
CoefIPL = exp(-1/tauIPL);

% Init LP spatial filter used for ON and OFF outputs filtering
SpatialLPFilterCoefs = InitSpatialLPFilter( (beta_1+beta_2)/2, tau_1, k_1);
SpatialLPFilterCoefs_Wide = InitSpatialLPFilter( 0.00, 0.0, k_2);
SpatialLPFilterCoefs_VeryWide = InitSpatialLPFilter( 0.00, 0.0, 2*k_2);
SpatialLPFilterCoefs_VeryVeryWide = InitSpatialLPFilter( 0.00, 0.6, 5*k_2);
EyeFinderTableCoef = InitSpatialLPFilter( 1, tau_2, 2*k_2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%% Velocity Filters Init Starting %%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% SpatioTemporalVelocity Filtering Init

% specify the number of velocity filters
NbVelocityFilters = 5;

% create the table that specifies the orientation of the filters :
VelocityOrientation = zeros(NbVelocityFilters,1);
% filling the orientation table : 0 means horizontal velocity filter
VelocityOrientation(1) = 0; % => not oriented filter... so the orientation is arbitrary...
VelocityOrientation(2) = 0;
VelocityOrientation(3) = 0;
VelocityOrientation(4) = 1;
VelocityOrientation(5) = 1;

betaVelocity = 0; %default value = 0 ; 2
tauVelocity = 3; %default value = 6 ; 0.9
kVelocity = 1; %default value = 3  ;1.2

a=1.99;
b=2-a;

% Init Velocity Retina Filters    => InitSpatialRetinaFilter(beta, tau, k, m_a, m_b)
ZeroVelocity = InitRetinaVelocityFilter         (betaVelocity, tauVelocity, kVelocity, 1, 1);
MaxFreqSlideVelocity = InitRetinaVelocityFilter (betaVelocity, tauVelocity, kVelocity, a, b);
MinFreqSlideVelocity = InitRetinaVelocityFilter (betaVelocity, tauVelocity, kVelocity, b, a);
MaxAngleSlideMaxVelocity =      InitRetinaVelocityFilter    (betaVelocity, tauVelocity, kVelocity, a, b);
MinAngleFreqSlideMaxVelocity =  InitRetinaVelocityFilter    (betaVelocity, tauVelocity, kVelocity, b, a);


VelocityCoefTables = [  ZeroVelocity
    MaxFreqSlideVelocity
    MinFreqSlideVelocity
    MaxAngleSlideMaxVelocity
    MinAngleFreqSlideMaxVelocity
    ];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%% Fisrt init stage (get fra�me size, face size eyes size etc)
initFailed=false;
FirstStageInitAutoROI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%
% loop variables pre init : velocitiesRows and velocitiesColumns define
% the size of the computation area for global head motion detection
if initFailed
    return
end
velocitiesRows = round(min(3/2*NrowsFace, Nrows));
velocitiesColumns = round(min(3/2*McolumnsFace, Mcolumns));

MagnoYOutput_LP = zeros(velocitiesRows, velocitiesColumns);
MagnoYOutput_LP2 = zeros(velocitiesRows, velocitiesColumns);

%%%%%%%%%%%%%%%%%%%%%%%%
% Modification Viet
%%%%%%%%%%%%%%%%%%%%%%%%
% rowStart=Nrows/8;
% rowEnd=Nrows/2;
% columnStart=Mcolumns/2-Mcolumns/6;
% columnEnd=Mcolumns/2+Mcolumns/6;
% velocitiesRows=round(3*Nrows/8);
% velocitiesColumns=round(Mcolumns/3);
%%%%%%%%%%%%%%%%%%%%%%
% End Modification
%%%%%%%%%%%%%%%%%%%%%%
velocitiesBorderFaceOffsetRows = round((velocitiesRows-NrowsFace)/2);
velocitiesBorderFaceOffsetColumns = round((velocitiesColumns-McolumnsFace)/2);

%CurrentVelocities = zeros(Nrows, Mcolumns, NbVelocityFilters);
FilteredOrientedVelocities = zeros(Nrows, Mcolumns, NbVelocityFilters);
Velocities = zeros(velocitiesRows, velocitiesColumns, NbVelocityFilters);
%%%%%%%%%%%%%%%%
fs=-0.5:0.01:0.5;
fs = repmat(fs, [101 1]);
ft=fs';

Gfxft=1./(1 + 2*kVelocity*kVelocity*[1-cos(2*pi*fs)] + i*2*pi*tauVelocity*(ft + kVelocity*kVelocity*(b-1)/(pi*tauVelocity)*sin(2*pi*fs)));
%     figure
%     surf(fs, fs', abs(Gfxft))
%     shading interp
%     xlabel('Fs');
%     ylabel('Ft');
%     zlabel('G(fx,ft)')
%%%%%%%%%%%%%%%%%

% Init Resistive Network (placed at the output of the Velocity filters, Input = k, beta, inj, tau=0)
ResistiveNetworkCoefs = InitResistiveNetwork(50, 0, 1, 0.0);

% prepare motion  edges detection
PLIEdgesTableInit=false(velocitiesRows, velocitiesColumns);
PLIEdgesTable=false(velocitiesRows, velocitiesColumns);

H_EstimatedVelocity = zeros(velocitiesRows, velocitiesColumns);
V_EstimatedVelocity = zeros(velocitiesRows, velocitiesColumns);

%%%%%%%%%%%% Velocity Filters Init End%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% Last Initializations %%%%%
SpectrumAnalysisInitHeadMotion
SecondStageInitAutoROI
%DataFusionInit2
%DataFusion2
%modified by philou
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

CurrentFrame=2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FeatureStateDetection function variable init value
LastEyeLeftMotionEvent=CurrentFrame;
EyeLeftClosedEnergyLevel=0;
EyeLeftOpenedEnergyLevel=0;
EyeLeftOPLTotalEnergyAdaptativeMean_New=0;
EyeLeftLastStableOPLValue=0;
% EyeLeftUp=1;
% EyeLeftLeft=1;
EyeLeftBinaryState=1;

LastEyeRightMotionEvent=CurrentFrame;
EyeRightClosedEnergyLevel=0;
EyeRightOpenedEnergyLevel=0;
EyeRightOPLTotalEnergyAdaptativeMean_New=0;
EyeRightLastStableOPLValue=0;
% EyeRightUp=1;
% EyeRightLeft=1;
EyeRightBinaryState=1;

LastMouthMotionEvent=CurrentFrame;
MouthClosedEnergyLevel=0;
MouthOpenedEnergyLevel=0;
MouthOPLTotalEnergyAdaptativeMean_New=0;
MouthLastStableOPLValue=0;
MouthBinaryState=1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FeatureMaxIPLEnergy_eyeLeft=zeros(1,MovieStop);
OPLenergyEyeLeft=zeros(1,MovieStop);
EyeLeftCloseElevel=zeros(1,MovieStop);
EyeLeftOpenElevel=zeros(1,MovieStop);
verticalVelocityHist=zeros(1,MovieStop);
horizontalVelocityHist=zeros(1,MovieStop);
limit_hist=zeros(1,MovieStop);
VerticalProb=zeros(1,MovieStop);
HorizontalProb=zeros(1,MovieStop);
MotionEnergyEyes=zeros(1,MovieStop);
MotionEnergyMouth=zeros(1,MovieStop);




YESvalue=0;
NOvalue=0;
EyesBrowsUp=0;

'Before Strating'
Nrows
MovieStop
CurrentFrame=1;

while (CurrentFrame < MovieStop) && ContinueAnalysis && not(initFailed)

    t0 = cputime;

    %%%% SpatioTemporal filtering video Loop
    %tic
    % Current Picture Read&Init
    % Reference picture reading
    AcquireVideoFrame;% output = CurrentPicture : gray level frame range= 0-1

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % First stage spatial Retinal prefiltering

    % retina computing
    [PhotoreceptorsOutput RetinaOutput MagnoYOutput]=ComputeRetinaFiltering(CurrentPicture);
    
    % Extract face and then, eyes and mouth OPL and IPL output
    FaceDetectionFilters

    % Compute eyes and mouth states detection an head motion
    % interpretation
    %TestEyeLeftFunctionModule % old original script:
    if CurrentFrame>2
%         EyeLeftStateDetection
%         EyeRightStateDetection
%         DetectEyesBrowsUp
%         MouthStateDetection %lance detection bouche+ mvt +etat
        GlobalHeadMotion_SpectrumAnalysis % used to extract yes and no and head motion direction (head motion events only)
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Call the data fusion script
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %DataFusion3

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%% Final display of the loop and save if variable
    %%%%%%%%%% SaveVideoOutput =1
    if HeadMotionDirectionDemoMode~=-1
        DisplayFigure
    end
    
    %%%% Write Data analysis report
    if VideoDataBaseAnalysis||saveReport
        writeAlldata(FeaturesAnalysisReportTextFile, videoCounter, YESvalue, NOvalue, FaceTotalIPLEnergy(CurrentFrame), MotionEnergyEyes(CurrentFrame), MotionEnergyMouth(CurrentFrame), RowLeftUpCorner, ColumnLeftUpCorner, RowRightDownCorner, ColumnRightDownCorner, horizontalVelocityHist(CurrentFrame), verticalVelocityHist(CurrentFrame))
    end
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % estimating computing time
    LastFPS = 1/(cputime-t0+0.0001);
    FPSmean = LastFPS*alpaFPS+FPSmean*alphaFPSopp;
    FrameComputingTime(CurrentFrame - MovieStart+1)=FPSmean;
    CurrentFrame = CurrentFrame+MovieStep;

    
end
%%%%%%%%% Loop END %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Write Data analysis report
    if VideoDataBaseAnalysis||saveReport
        writeAlldata(FeaturesAnalysisReportTextFile, videoCounter, YESvalue, NOvalue, FaceTotalIPLEnergy(CurrentFrame), MotionEnergyEyes(CurrentFrame), MotionEnergyMouth(CurrentFrame), RowLeftUpCorner, ColumnLeftUpCorner, RowRightDownCorner, ColumnRightDownCorner, horizontalVelocityHist(CurrentFrame), verticalVelocityHist(CurrentFrame))
    end

if not(VideoDataBaseAnalysis||SingleFileDirectComputing)
    if SaveVideoOutput ==1
        CorrelationMovie = close(CorrelationMovie);
    end

    %%     % display to check temporal evolution of variables
    figure
    plot(OPLenergyEyeLeft(1:CurrentFrame))
    hold on
    plot(EyeLeftOpenElevel(1:CurrentFrame), '-or')
    plot(EyeLeftCloseElevel(1:CurrentFrame), '-ob')
    plot((EyeLeftOpenElevel(1:CurrentFrame)+EyeLeftCloseElevel(1:CurrentFrame))/2, '-k')
    figure
    plot(FaceTotalIPLEnergy(1:CurrentFrame), '-m')
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%affichage du framerate
    % XPoints = MovieStart:MovieStep:MovieStop-1;
    figure
    plot(FrameComputingTime(1:CurrentFrame),'-g');
    title('FrameRate (/sec)');

    %%profile viewer
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%tous les graph pour la suite du prg...
    HeadMotionBlinksAndYawningsGraph
    DrawHeadVectors

    figure
    plot(FaceMotionAlert(1:CurrentFrame))
    hold on
    plot(FacealphaCurrentDataHist(1:CurrentFrame), '-r')

    Finish = 1;

    figure
    subplot(1,2,1)
    imagesc(CurrentPicture)
    axis image
    subplot(1,2,2)
    imagesc(PhotoreceptorsOutput)
    axis image
    colormap gray

    figure
    plot(MouthTotalOPLEnergy(1:CurrentFrame))
    title('MouthOPLTotalEnergy')
    figure
    plot(EyeLeftTotalOPLEnergy(1:CurrentFrame), '-r')
    title('EyeLeftOPLTotalEnergy')
    figure
    plot(EyeRightTotalOPLEnergy(1:CurrentFrame), '-r')
    title('EyeRightOPLTotalEnergy')

    figure
    plot(horizontalVelocityHist(1:CurrentFrame), '-r')
    hold on
    plot(verticalVelocityHist(1:CurrentFrame), '-b')
    title('velocity (red=h, blue=v)')
    
    figure
    plot(EyeLeftTotalOPLEnergy(1:CurrentFrame), '-k')
    hold on
    plot(EyeLeftClosedEnergyLevel_Hist(1:CurrentFrame), '-r')
    plot(EyeLeftOpenedEnergyLevel_Hist(1:CurrentFrame), '-b')
    plot(limit_hist(1:CurrentFrame-1), '-g')
    
    figure
    plot(VerticalProb(1:CurrentFrame), '-b')
    hold on
    plot(HorizontalProb(1:CurrentFrame), '-r')
    title('hProb=r, vProb=b')
    
    figure
    plot(MotionEnergyEyes(1:CurrentFrame), '-r');
    hold on
    plot(MotionEnergyMouth(1:CurrentFrame), '-b');
    title('Mouth=b, eyes=r');
    
    % figure
    % plot(MouthalphaCurrentDataHist(1:MovieStop),'-g');
    % hold on
    % plot(SpeechPeriod(1:MovieStop),'-r');
    % title('Speech Detection Viet')


    % for i=2:MovieStop-1
    %     if (SpeechDuration(i-1)==0 && SpeechDuration(i)>0)||(SpeechDuration(i)>0 && SpeechDuration(i+1)==0)
    %         disp(i);
    %     end
    % end

end