%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier 
 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%  
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
 
% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.
 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

%%%%%%%%%
% Function that initialise the 6 coefs used in the approximated Retina
% Filter [Herault, bodeau]

function CoefVector = InitRealSpatialRetinaFilter(beta_1, tau_1, k_1, beta_2, tau_2, k_2)


    % First stage retina
    CoefVector = ones (8,1);
    beta_1 = beta_1+tau_1;
    
	alpha = double(k_1*k_1);
	mu = double(0.8);
	temp =  double((1+beta_1)/(2*mu*alpha));
	a =  1 + temp - sqrt( double( (1+temp)*(1+temp) - 1) );
	CoefVector(1) = (1-a)*(1-a)*(1-a)*(1-a)/(1+beta_1);
	CoefVector(2) = 1;
    CoefVector(3) = a;
    CoefVector(4) = tau_1;

    
    % Second stage retina
    beta_2 = beta_2+tau_2;
    
	alpha = double(k_2*k_2);
	mu = double(0.8);
	temp =  double((1+beta_2)/(2*mu*alpha));
	a =  1 + temp - sqrt( double( (1+temp)*(1+temp) - 1) );
	CoefVector(5) = (1-a)*(1-a)*(1-a)*(1-a)/(1+beta_2);
	CoefVector(6) = 1;
    CoefVector(7) = a;
    CoefVector(8) = tau_2;
    

    
    