%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prepare figure display (fast method)
%close all
%figure('doublebuffer','on', 'Name', 'Head Motion Analyser', 'PaperUnits', 'points', 'Position', [10,640,1000, 800], 'ToolBar', 'none');



if HeadMotionDirectionDemoMode==0

    subplot(2,4,1)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 Nrows]);
    set(gca,'ylim',[0 Mcolumns]);
    CurrentPictureDisplay = image('cdata', zeros(Nrows, Mcolumns,3));
    axis off
    axis ij
    axis image
    set(CurrentPictureDisplay,'erasemode','none');
    colormap(gray(256))
    title('Detected Face')

    %%%%%%%%%%%%%%%%%%%%%
    % Test display mode

    subplot (2,4,2)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    RetinaOutputFigure = image('cdata', gray2RGB_Hot(zeros(size(FaceArea))));
    axis off
    axis ij
    axis image
    set(RetinaOutputFigure,'erasemode','none');
    title('Retina Output')

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%% FFT computing

    if testFaceLogPolarSpectrum
        subplot (2,4,3)
        set(gca,'drawmode','fast');
        set(gca,'units','pixels');
        set(gca,'xlim',[0 NBradiusFace]);
        set(gca,'ylim',[0 NBanglesFace]);
        IPLOutputFigure = image('cdata', gray2RGB_Hot(zeros(NBradiusFace, NBanglesFace)));
        axis off
        axis ij
        axis image
        set(IPLOutputFigure,'erasemode','none');
        title('OPL log polar sprectrum')
    else
        subplot (2,4,3)
        set(gca,'drawmode','fast');
        set(gca,'units','pixels');
        set(gca,'xlim',[0 NrowsFace]);
        set(gca,'ylim',[0 McolumnsFace]);
        IPLOutputFigure = image('cdata', gray2RGB_Hot(zeros(size(FaceArea))));
        axis off
        axis ij
        axis image
        set(IPLOutputFigure,'erasemode','none');
        title('IPL Output')


    end


    subplot (2,4,4)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    ExtractedFaceFeaturesDisplay = image('cdata', zeros(NrowsFace, McolumnsFace));
    axis off
    axis ij
    axis image
    set(ExtractedFaceFeaturesDisplay,'erasemode','none');
    title('Face Extracted Areas')


    subplot(2,4,5)
    [ResultPicXSize, ResultPicYSize] = size(imread('Yes.jpg'));
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 ResultPicYSize]);
    set(gca,'ylim',[0 ResultPicXSize]);
    InterpretationFigure = image('cdata', getfield(ResultPicture,'Undetermined'));
    axis off
    axis ij
    axis image
    set(InterpretationFigure,'erasemode','none');
    title('Interpretation')

    subplot (2,4,6)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    YesNoFinderFigure = image('cdata', getfield(ResultPicture,'Undetermined'));
    axis off
    axis ij
    axis image
    set(YesNoFinderFigure,'erasemode','none');
    title('Attitude Interpretation')


    subplot (2,4,7)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    HeadMotionDirectionFigure = image('cdata', getfield(ResultPicture,'UndeterminedMotion'));
    axis off
    axis ij
    axis image
    set(HeadMotionDirectionFigure,'erasemode','none');
    title('Head MotionDirection')

    subplot (2,4,8)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 velocitiesRows]);
    set(gca,'ylim',[0 velocitiesColumns]);
    PLIEdgesTableFigure = image('cdata', zeros(velocitiesRows, velocitiesColumns));
    axis off
    axis ij
    axis image
    set(PLIEdgesTableFigure,'erasemode','none');
    title('Face Extracted Areas')

elseif HeadMotionDirectionDemoMode==1
    subplot(1,2,1)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    CurrentPictureDisplay = image('cdata', FaceArea);
    axis off
    axis ij
    axis image
    set(CurrentPictureDisplay,'erasemode','none');
    colormap(gray(256))
    title('Input Frame')

    subplot (1,2,2)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    HeadMotionDirectionFigure = image('cdata', getfield(ResultPicture,'UndeterminedMotion'));
    axis off
    axis ij
    axis image
    set(HeadMotionDirectionFigure,'erasemode','none');
    title('Head MotionDirection')
elseif HeadMotionDirectionDemoMode==2

    subplot(1,2,1)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    CurrentPictureDisplay = image('cdata', gray2RGB_Hot(zeros(Nrows, Mcolumns)));
    axis off
    axis ij
    axis image
    set(CurrentPictureDisplay,'erasemode','none');
    colormap(gray(256))
    title('Input Frame')

    subplot (1,2,2)
    set(gca,'drawmode','fast');
    set(gca,'units','pixels');
    set(gca,'xlim',[0 NrowsFace]);
    set(gca,'ylim',[0 McolumnsFace]);
    HeadDetectionFigure = image('cdata', gray2RGB_Hot(zeros(NrowsFace, McolumnsFace)));
    axis off
    axis ij
    axis image
    set(HeadDetectionFigure,'erasemode','none');
    title('Head MotionDirection')

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%NBpixelsPic = Nrows*Mcolumns;


% prepare matrix for the loop
AcquiredPicture = zeros(Nrows, Mcolumns);
CurrentRGBpic = zeros(Nrows, Mcolumns);
CurrentPicture = zeros(Nrows, Mcolumns);

if MotionDisplay==1
    close all
    scrsz = get(0,'ScreenSize');
    figure('Position',[1 scrsz(4) scrsz(3) scrsz(4)]);
end

