    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier 
 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%  
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
%
% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.
 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% main function that launches the head detection and analysis

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%ATTENTION:
%chosing: Format_0 Mode_1: 320x240 YUV (4:2:2)
%under coriander application
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function varargout = LaunchHeadAnalysis(varargin)

% LAUNCHHEADANALYSIS M-file for LaunchHeadAnalysis.fig
%      LAUNCHHEADANALYSIS, by itself, creates a new LAUNCHHEADANALYSIS or raises the existing
%      singleton*.
%
%      H = LAUNCHHEADANALYSIS returns the handle to a new LAUNCHHEADANALYSIS or the handle to
%      the existing singleton*.
%
%      LAUNCHHEADANALYSIS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LAUCHHEADANALYSIS.M with the given input arguments.
%
%      LAUNCHHEADANALYSIS('Property','Value',...) creates a new LAUNCHHEADANALYSIS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before LaunchHeadAnalysis_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to LaunchHeadAnalysis_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

global ContinueAnalysis AlarmEyesClosed

% Edit the above text to modify the response to help LaunchHeadAnalysis
% Last Modified by GUIDE v2.5 24-Jul-2005 17:34:23

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @LaunchHeadAnalysis_OpeningFcn, ...
                   'gui_OutputFcn',  @LaunchHeadAnalysis_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before LauchHeadAnalysis is made visible.
function LaunchHeadAnalysis_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to LauchHeadAnalysis (see VARARGIN)
global MainWindowHandle
% Choose default command line output for LauchHeadAnalysis
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes LauchHeadAnalysis wait for user response (see UIRESUME)
%uiwait(handles.figure1);
MainWindowHandle=gcf

% --- Outputs from this function are returned to the command line.
function varargout = LaunchHeadAnalysis_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global dodo ContinueAnalysis AlarmEyesClosed textFileID

%%% addpathj depending on the goals...
    % to activate tcp ip connection when sending an alarm
    addpath MPT\
    addpath DataFusion\
    %addpath tcpip\   %removed by philou

    % to use the fusion scripts for hypovigylence detection during
    % Enterface Workshop
    %addpath ~/Desktop/GUI_HeadtrackingAndAnalysisTEST/Enterface/
    
%%% define variables to tweak the video hypovigylence detector
    useYUVstream=0; % set 1 if you use a yuv video file OR a camera which only gives you luminance
    param1='../sequences_test_pour_prg_alex/driver.yuv'; %for testing with a Raw YUV movie
    filename=uint8(param1); %c'est vraiment nul matlab, faut le convertir pour que la chaine de caracteres passe en param de la mex fonction!!!
    offlineYUVwidth=320; %width of the  previous offline yuv movie
    offlineYUVheight=240;%height of the previous offline yuv movie
    WebcamVideoMode=1; % sets the video stream input style (1:realtime input, else, videofile)
% image sequence parameters
    ImageSequenceMode=0;
    ImagenumberOfDigits=3;    
    MatGrayInputFile=0;
    VideoDataBaseAnalysis=0;
    OnlyUseUpperHalfPartOfFrame=0;
    SingleFileDirectComputing=0;
%%%
    HeadMotionDirectionDemoMode = 0; % set display mode : -1=n display, 0 = experimental display mode, 1 = input+velocity orientation, 2 = input+eye detection
    SaveVideoOutput = 0; % if 1 : then an output video file is generated (requires much processing power, disk access...)
    TestOpenEnterfaceNoFaceDetection = 0; % skip the face detection WARNING, will not work for frame size less than 320*240...
    ContinuousHeadDetection =1;% set 0 if you don't want head detection for each frame (there will be only one, for initialization)
    ActivateFullYexNoDetection=1;% if 1, then interprete head nods, if 0, only computes head motion detection in the YesNoFinder function
    useTCPConnexion=0; %for sending the xml message within a TCP/IP socket.otherwise, trace in matlab command window
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    saveReport=0;
    
ContinueAnalysis=1;
profile on

videoCounter=1;

if saveReport
    FeaturesAnalysisReportTextFile='report_part2.txt'
end

% Launch the analyser on a set of videos
if not(VideoDataBaseAnalysis)
    HeadDetectionAndAnalysis
else
    
    % get the text file that contains all the video file and pathnames
    [filename  pathname] = uigetfile('*.txt', 'Choose a video list TXT file');
    %fidVideoLIST = fopen([pathname filename], 'r');
    [PersonID GestureID VideoFile]=textread([pathname filename], '%d %d %s');
    VideoNumber=760;
    for videoCounter=123:VideoNumber
        ContinueAnalysis=1;
        videoPathAndName = VideoFile{videoCounter};
        textVideoIndex=['reading file: (' num2str(videoCounter) ') :' videoPathAndName]
        HeadDetectionAndAnalysis;

    end
    
end

% closing text file
if saveReport
    fclose(textFileID)
end
% % --- Executes on button press in pushbutton1.
% function OpenInterfaceGetState(hObject, eventdata, handles)
% global dodo
% return dodo

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global ContinueAnalysis
ContinueAnalysis=0;
%DrawHeadVectors
profile report

% --- Executes on button press in ValidFaceDetection.
function ValidFaceDetection_Callback(hObject, eventdata, handles)
% hObject    handle to ValidFaceDetection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in RestartFaceDetection.
function RestartFaceDetection_Callback(hObject, eventdata, handles)
% hObject    handle to RestartFaceDetection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on selection change in ValideFaceDetectionPopUp.
function ValideFaceDetectionPopUp_Callback(hObject, eventdata, handles)
% hObject    handle to ValideFaceDetectionPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ValideFaceDetectionPopUp contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ValideFaceDetectionPopUp


% --- Executes during object creation, after setting all properties.
function ValideFaceDetectionPopUp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ValideFaceDetectionPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in VideoInputPopUp.
function VideoInputPopUp_Callback(hObject, eventdata, handles)
% hObject    handle to VideoInputPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns VideoInputPopUp contents as cell array
%        contents{get(hObject,'Value')} returns selected item from VideoInputPopUp


% --- Executes during object creation, after setting all properties.
function VideoInputPopUp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to VideoInputPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
