% Sign Language Tutoring Tool utility
% takes a pathname of the video to be analysed in parameter
% and writes the result of the analysis in a text file which name is given
% as a second parameter

function LaunchSingleVideoAnalysis(inputVideoPathAndName, reportName)

global dodo ContinueAnalysis AlarmEyesClosed textFileID

%%% addpath depending on the goals...
    % to activate tcp ip connection when sending an alarm
    addpath MPT\
    addpath DataFusion\
    %addpath tcpip\   %removed by philou

    % to use the fusion scripts for hypovigylence detection during
    % Enterface Workshop
    %addpath ~/Desktop/GUI_HeadtrackingAndAnalysisTEST/Enterface/
    
%%% define variables to tweak the video hypovigylence detector
    useYUVstream=0; % set 1 if you use a yuv video file OR a camera which only gives you luminance
    param1='../sequences_test_pour_prg_alex/driver.yuv'; %for testing with a Raw YUV movie
    filename=uint8(param1); %c'est vraiment nul matlab, faut le convertir pour que la chaine de caracteres passe en param de la mex fonction!!!
    offlineYUVwidth=320; %width of the  previous offline yuv movie
    offlineYUVheight=240;%height of the previous offline yuv movie
    WebcamVideoMode=0; % sets the video stream input style (1:realtime input, else, videofile)
% image sequence parameters
    ImageSequenceMode=0;
    ImagenumberOfDigits=3;    
    MatGrayInputFile=0;
    VideoDataBaseAnalysis=0;
    OnlyUseUpperHalfPartOfFrame=1;
%%%
    HeadMotionDirectionDemoMode = -1; % set display mode : -1=n display, 0 = experimental display mode, 1 = input+velocity orientation, 2 = input+eye detection
    SaveVideoOutput = 0; % if 1 : then an output video file is generated (requires much processing power, disk access...)
    TestOpenEnterfaceNoFaceDetection = 0; % skip the face detection WARNING, will not work for frame size less than 320*240...
    ContinuousHeadDetection =1;% set 0 if you don't want head detection for each frame (there will be only one, for initialization)
    ActivateFullYexNoDetection=1;% if 1, then interprete head nods, if 0, only computes head motion detection in the YesNoFinder function
    useTCPConnexion=0; %for sending the xml message within a TCP/IP socket.otherwise, trace in matlab command window
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    SingleFileDirectComputing=1;
    saveReport=1;
    
ContinueAnalysis=1;
profile on

if saveReport
    if SingleFileDirectComputing
        videoCounter=1;
    end
    videoPathAndName=inputVideoPathAndName;
    FeaturesAnalysisReportTextFile=reportName
end

% Launch the analyser on a set of videos
if not(VideoDataBaseAnalysis)
    HeadDetectionAndAnalysis
else
    
    % get the text file that contains all the video file and pathnames
    [filename  pathname] = uigetfile('*.txt', 'Choose a video list TXT file');
    %fidVideoLIST = fopen([pathname filename], 'r');
    [PersonID GestureID VideoFile]=textread([pathname filename], '%d %d %s');
    VideoNumber=760;
    for videoCounter=123:VideoNumber
        ContinueAnalysis=1;
        videoPathAndName = VideoFile{videoCounter};
        textVideoIndex=['reading file: (' num2str(videoCounter) ') :' videoPathAndName]
        HeadDetectionAndAnalysis;

    end
    
end

% closing text file
if saveReport
    fclose('all')
end

disp('Process finished')