% luminance correction (photoreceptors modelling)
% input:
%   -> 1.Gray level (type is double) image
%   -> 2.local luminance adaptation sensitivity: the area in pixels on
%   which the luminance is adapted
% output: localy adapted picture (type is double)
function output=localLuminanceAdaptation(InputGrayPicture, localAdaptationRange)

% init parameters
[Nrows, Mcolumns]=size(InputGrayPicture);
output=zeros(Nrows, Mcolumns);

% compute adaptation
% NOTE: this function takes the output result marix in parameter, this allows faster computation as output matrix is allocated only one time
PhotoreceptorsCompression(InputGrayPicture, output, localAdaptationRange);
