%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% computing time reference
% Modify by LUONG Hong Viet
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
TimeCounter=clock; 
CurrentTime = 1000*(TimeCounter(5)*60+TimeCounter(6));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Mouth Detection and analysis based on spectrum analysis of the mouth
% area, this function detects mouth state (open/closed) and current action
% (opening/closing) i.e. motion events

Mouth_OPL   = Face_OPL(MouthUp:MouthDown, MouthLeft:MouthRight);
Mouth_IPL   = Face_IPL(MouthUp:MouthDown, MouthLeft:MouthRight);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Blinks/Yawnings detection start  %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% FFT computing
MouthOPLCurrentFFT = abs(fftshift(fft2(Mouth_OPL.*MouthHammingWindow)));
MouthIPLCurrentFFT = abs(fftshift(fft2(Mouth_IPL.*MouthHammingWindow)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LogPolar transform using GloP filters
FastTransfoLogPolFunctionL_C(MouthIPLCurrentFFT, MouthLogPolTransfoMatrixPixList, MouthLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, IPLLogPolFFTFaceInside, MouthMaxListSize);

IPLShowLogPolSpectrum = IPLLogPolFFTFaceInside';

% find the max value and its coordonates
[MaxValue, IDrow]  = max(max(IPLShowLogPolSpectrum));
[MaxValue, IDcolumn]  = max(max(IPLShowLogPolSpectrum'));

MouthMaxIndexOrientedFrequency(CurrentFrame)= IDcolumn;
% get the oriented energie at the output of the OPL and IPL filter
IPLOrientedEnergie=sum(IPLShowLogPolSpectrum);

% Computing the Total IPL energy
MouthTotalIPLEnergy(CurrentFrame) = sum(IPLOrientedEnergie);
MouthTotalOPLEnergy(CurrentFrame) = sum(sum(MouthOPLCurrentFFT));

% estimating OPL energies
MouthOPLTotalEnergyAdaptativeMean(CurrentFrame) = MouthOPLTotalEnergyAdaptativeMean(CurrentFrame-1)*(1-OPLAdaptativeMeanSensitivity) + OPLAdaptativeMeanSensitivity*MouthTotalOPLEnergy(CurrentFrame);

%NoiseMeanInitDuration=20;
%%% Extract motion evolution
if CurrentFrame < NoiseMeanInitDuration
    % first evaluate the noise to avoid interpretation errors
    if CurrentFrame >8
        % init motion alert parameters by computing noise informations
        MouthNoiseMeanInit = MouthNoiseMeanInit+MouthTotalIPLEnergy(CurrentFrame);
        MouthMaxIPLEnergy = MouthNoiseMeanInit/NoiseMeanInitDuration;
        MouthMaxEver = 0;
        MouthNoiseMean = 5*MouthNoiseMeanInit/(NoiseMeanInitDuration-8);
        MouthNoiseMeanMultiple=2*MouthNoiseMean;
        % init state detection parameters
        LastMouthMotionEvent = CurrentFrame;
        MouthClosedEnergyLevel =MouthOPLTotalEnergyAdaptativeMean(CurrentFrame)/2;
        MouthOpenedEnergyLevel =MouthOPLTotalEnergyAdaptativeMean(CurrentFrame);
        MouthOpenClosedEnergyLimit = (MouthClosedEnergyLevel+MouthOpenedEnergyLevel)/2;
        MouthOPLEnergyInitValue=MouthOpenClosedEnergyLimit;
    end
else
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% Evaluating variables signification
    MouthMaxIPLEnergy = MouthMaxIPLEnergy*0.9; % MaxEnergy decreases in the time => be aware of all events even smallest but significant...

    if (MouthTotalIPLEnergy(CurrentFrame)-MouthNoiseMean > 0)%&&(MouthActivityOnly||EyesAndMouthActivity)

        % Update the max value limit :

        MouthMaxIPLEnergy = max(MouthMaxIPLEnergy, MouthTotalIPLEnergy(CurrentFrame)-MouthNoiseMean);

        MouthalphaMaxIPLEnergy = abs((MouthTotalIPLEnergy(CurrentFrame)-MouthNoiseMean))/MouthMaxIPLEnergy;
        %MouthalphaMaxIPLEnergy = MouthalphaMaxIPLEnergy*MouthalphaMaxIPLEnergy;
        MouthalphaCurrentData = MouthalphaMaxIPLEnergy;

    else
        MouthalphaCurrentData =0;
    end
    MouthalphaCurrentDataHist(CurrentFrame)= MouthalphaCurrentData;
    MouthMaxIPLEnergyHistory(CurrentFrame) = MouthMaxIPLEnergy;
    MouthMaxEverHistory(CurrentFrame) = MouthMaxEver;

    %%%%%%%%%% Init part end %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Detecting Mouth Motion/Blink:


    if MouthalphaCurrentData < 0.5 || FaceActivity
        MouthMotion = 0;
        MouthLastStableOPLValue = MouthOPLTotalEnergyAdaptativeMean(CurrentFrame);
       
        MedianIndex=mod(CurrentFrame, MouthMedian)+1;
        LastMouthStateChangeTable(MedianIndex)=MouthStateChange;
        MouthStateChange =0;

        %%%%%%%%%% Speech period detection
        SpeechMotionPeriod(CurrentFrame)=median(LastMouthStateChangeTable); % median value of the last MouthStateChanges
%        SpeechMotionPeriod(CurrentFrame)= MouthStateChange;

        MouthStateChange=0;

    else
        % identifying the motion orientation
        [MaxOrientedEnergy, IndexMaxOrientedEnergy] = max(IPLOrientedEnergie);

        % speech detection code place???

        % test if motion is nearly vertical
        if abs(IndexMaxOrientedEnergy - NBanglesFaceInside/4) < NBanglesFaceInside/8

            MouthStateChange =1;
            MedianIndex=mod(CurrentFrame, MouthMedian)+1;
            LastMouthStateChangeTable(MedianIndex)=MouthStateChange;

            %%%%%%%%%% Speech period detection
            
            SpeechMotionPeriod(CurrentFrame)=median(LastMouthStateChangeTable); % median value of the last MouthStateChanges

              
            %%%% speech probability detection %%%%
            %%% TEST IF IT SHOULD BE PLACED JUST AFTER THE 'else'
            %%% JUST ABOVE
%           SpeechMotionPeriod(CurrentFrame)= MouthStateChange;
               
            % sppech detection
            % TEST IF IT SHOULD BE PLACED UNDER THE PREVIOUS 'else'
%            SpeechMotionPeriod(CurrentFrame)=median([SpeechMotionPeriod(CurrentFrame-4:CurrentFrame-1) MouthStateChange]);


            MouthEnergyGradient = (MouthOPLTotalEnergyAdaptativeMean(CurrentFrame)-MouthOPLTotalEnergyAdaptativeMean(CurrentFrame-1));

%             beep;
            if MouthEnergyGradient < 0
                MouthMotion = -1;
                MouthMotionActionBinary=0;
            else
                MouthMotion = 1;
                MouthMotionActionBinary=1;
            end

            % detecting Mouth state
            MouthStableFrameNumber = CurrentFrame-LastMouthMotionEvent;
            % init for the upcoming reinitialized records
            LastMouthMotionEvent = CurrentFrame;

            % if there are sufficient stables frames, then compute energy levels
            if MouthStableFrameNumber > SignificantNumberOfFramesLevels
                % case of current energy level higher than the one
                % during the stable period => the Mouth just closed
                if MouthOPLTotalEnergyAdaptativeMean(CurrentFrame) > MouthTotalOPLEnergy(CurrentFrame)
                    % updating Mouth opened energy level
                    MouthOpenedEnergyLevel = max(MouthLastStableOPLValue, MouthOpenClosedEnergyLimit);
                else%if OPLTotalEnergyAdaptativeMean(CurrentFrame) < TotalOPLEnergy(CurrentFrame)
                    % updating Mouth opened energy level
                    MouthClosedEnergyLevel = min(MouthLastStableOPLValue, MouthOpenClosedEnergyLimit);
                end

                MouthStateChange =1;

            end
        end
    end

    % if the face is not moving,then, no update of the energy levels
    if not(FaceActivity) %|| EyesAndMouthActivity || MouthActivityOnly
        % detectting Mouth State
        MouthOpenClosedEnergyLimit = (MouthClosedEnergyLevel+MouthOpenedEnergyLevel)/2;

        if MouthTotalOPLEnergy(CurrentFrame) < MouthOpenClosedEnergyLimit
            MouthState='MouthClosed';
            MouthClosedEnergyLevel = MouthClosedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*min(MouthLastStableOPLValue, MouthOpenClosedEnergyLimit);

        else
            MouthState='MouthOpen';
            MouthOpenedEnergyLevel = MouthOpenedEnergyLevel*(OPLAdaptativeMeanSensitivity) + (1-OPLAdaptativeMeanSensitivity)*max(MouthLastStableOPLValue, MouthOpenClosedEnergyLimit);

        end
    end

    % recording values
%     MouthClosedEnergyLevel_Hist(CurrentFrame) = MouthClosedEnergyLevel;
%     MouthOpenedEnergyLevel_Hist(CurrentFrame) = MouthOpenedEnergyLevel;


    
    %%%  Blinks/Yawnings detection end  %%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %end of "if CurrentFrame < NoiseMeanInitDuration"
end

