%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% function that detect Yes and No expressions


% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% output data values :
%   AttitudeState = 1 => Undetermined
%   AttitudeState = 2 => Yes
%   AttitudeState = 3 => No
%   AttitudeState = 4 => MaxMean OUT
%   AttitudeState = 5 => ExtremumTimeDiffSTD OUT
%   AttitudeState = 6 => OrientationSTD OUT



function [YESValue NOvalue MaxCounter, AttitudeState, MaxHistory, OrientationHistory, ExtremumTimeHistory]  = OuiNonFinder(MaxCounter, EventNumberCount, NBanglesFace, CurrentFrame, ExtremumOrientation, MaxHistory, OrientationHistory, ExtremumTimeHistory, FPSmean, LastAlpha)

% default analyse result
AttitudeState = 'Undetermined';

YESValue=0;
NOvalue=0;
%%%%%%%%%%%%%%%%%%%%
%% First : save data

if LastAlpha < 0.1
    return;
end

MaxCounter =MaxCounter+1;

MaxHistory(MaxCounter) = LastAlpha;

%record the frame number to compute the difference between extremums
ExtremumTimeHistory(MaxCounter) = CurrentFrame;

% record the orientation history
OrientationHistory(MaxCounter)=ExtremumOrientation;

%%%%%%%%%%%%%%%%%%%
% Second : analyses


if MaxCounter > EventNumberCount+1

    MaxLastValues = MaxHistory(MaxCounter-EventNumberCount+1:MaxCounter);
    MaxMean = sum(MaxLastValues)/EventNumberCount;
    %MaxSTD = std(MaxLastValues);

    OrientationLastValues = OrientationHistory(MaxCounter-EventNumberCount+1:MaxCounter);
    OrientationMean = sum(OrientationLastValues)/EventNumberCount;
    OrientationSTD = std(OrientationLastValues);

    ExtremumLastTime = ExtremumTimeHistory(MaxCounter-EventNumberCount+1:MaxCounter);
    ExtremumTimeDiffLastValues = ExtremumLastTime(2:EventNumberCount)-ExtremumLastTime(1:EventNumberCount-1);
    ExtremumTimeDiffMean = sum(ExtremumTimeDiffLastValues)/EventNumberCount;
    ExtremumTimeDiffSTD = std(ExtremumTimeDiffLastValues) ;



    if OrientationSTD < NBanglesFace/5 % means that the extremums occur on the same orientation

        if ExtremumTimeDiffSTD/FPSmean< 0.7 % means that the events happen at a regular period with 0.5 second error std

            if ExtremumTimeDiffMean/FPSmean < 1 % means that the period is less than 0.8secon

                if MaxMean > 0.3

                    if abs(OrientationMean - NBanglesFace/4) < NBanglesFace/5
                        AttitudeState = 'Yes';
                        YESValue=1;
                    else
                        if abs(OrientationMean - NBanglesFace*3/4) < NBanglesFace/5
                            AttitudeState = 'No';
                            NOvalue=1;
                        else
                            AttitudeState = 'UnknowPeriodicAction';
                        end
                    end
                else
                    AttitudeState = 'MaxMeanOUT';

                end

            else
                AttitudeState = 'ExtremumTimeDiffMeanOUT';
            end

        else
            AttitudeState = 'ExtremumTimeDiffSTDOUT';
        end
    else
        AttitudeState = 'OrientationSTDOUT';
    end

    % solution N2: probability approach
    %PorientationYES=ComputeProbability(NBanglesFace/4, NBanglesFace*3/4, OrientationMean)
%     PorientationNo=ComputeProbability(NBanglesFace*3/4, NBanglesFace, OrientationMean)
%     Pfrequency=ComputeProbability(NBanglesFace*3/4, NBanglesFace, OrientationMean)
    
    
%     Pfrequency=ComputeProbability()max(0,abs(ExtremumTimeDiffSTD/FPSmean- 0.7))
%     Pamplitude=max(0,MaxMean-0.3)
%     if abs(OrientationMean - NBanglesFace/4) < NBanglesFace/5
%         AttitudeState = 'Yes 2';
%         YESValue=1;
%     else
%         if abs(OrientationMean - NBanglesFace*3/4) < NBanglesFace/5
%             AttitudeState = 'No 2';
%             NOvalue=1;
%         else
%             AttitudeState = 'UnknowPeriodicAction 2';
%         end
%     end


end



