%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit


% Spectrum Analysis Variables INIT
global FacealphaCurrentDataHist FaceTotalIPLEnergy
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% General/common Spectrum Init %%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Log polar analysis variables %%%%
IPLLogPolFFTFace = zeros(NBanglesFace, NBradiusFace);
NBpixelsFFTFace = NBanglesFace*NBradiusFace;
NonRigidMotionActiv=0;

% Hamming windows used for spectrum analysis
GlobalFaceHammingWindow = GenerateHammingWindow(zeros(velocitiesRows, velocitiesColumns));
FaceHammingWindow = GenerateHammingWindow(FaceArea(:,:,1));
EyeHammingWindow = GenerateHammingWindow(EyeLeft);
MouthHammingWindow = GenerateHammingWindow(Mouth);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Total Head Spectrum Init %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prepare LogPolarTransform

[FaceMaxListSize FaceLogPolTransfoMatrixPixList FaceLogPolTransfoMatrixPixCoef] = GlopLargeFilterInitFdivideFast2(velocitiesRows, velocitiesColumns, NBanglesFace, NBradiusFace, MaxRadius, FilterPrecision);
FaceMaxListSize=FaceMaxListSize+1;

% Show Filters sum frequency response
%     figure;
%     FaceSamplingMap = zeros(velocitiesRows, velocitiesColumns);
%     ShowLogPolarSampling_C(zeros(velocitiesRows, velocitiesColumns), FaceLogPolTransfoMatrixPixList, FaceLogPolTransfoMatrixPixCoef, NBanglesFace, NBradiusFace, FaceSamplingMap, FaceMaxListSize);
%     mesh(FaceSamplingMap)
%     title('LogPolar Filters Mapping for Global Face')
%     colormap(hsv)
%     shading interp

Face_OPL = zeros(NrowsFace, McolumnsFace);
Face_IPL = zeros(NrowsFace, McolumnsFace);

FaceIPLCurrentFFT = zeros(velocitiesRows, velocitiesColumns);

% adaptative mean sensitivities
OPLAdaptativeMeanSensitivity=0.4;


FaceNoiseMeanInit = 0;
FaceNoiseMean = 0;
FaceNoiseMeanMultiple=0;
FaceLastStableOPLValue=0;

FaceOrientedEnergyMean = NBanglesFace/2;
FaceOrientedFrequencyMean = NBradiusFace/2;

FaceRecordedEnergy_Hist=zeros(1, MovieStop);

FaceMaxIndexFrequencyEnergy=zeros(1, MovieStop);
FaceTotalIPLEnergy=zeros(1, MovieStop);
FaceTotalOPLEnergy=zeros(1, MovieStop);
FaceOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);

FaceOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
FacealphaCurrentDataHist=zeros(1, MovieStop);
FaceMaxIPLEnergyHistory=zeros(1, MovieStop);
FaceMotionAlert=zeros(1, MovieStop);

FaceMaxEverHistory=zeros(1, MovieStop);

FaceMaxIDOrientedEnergyMean=zeros(1, MovieStop);

FaceMaxCounter=0;
FaceMaxHistory= ones(1, MovieStop);
FaceOrientationHistory= ones(1, MovieStop);
FaceExtremumTimeHistory= ones(1, MovieStop);
FaceMaxIndexOrientedEnergy= ones(1, MovieStop);

FaceAttitudeState = 'Undetermined';

FaceMedian=3;
LastFaceStateChangeTable=zeros(FaceMedian,1);
FaceMotionPeriod=zeros(1,MovieStop);
FaceStateChange=0;
HeadMotionAlertHistory=zeros(1, MovieStop);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Eyes Spectrum init %%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% variable for eye position detection temporfal smooth
alphaEyePositionMotion=0.3;

IPLLogPolFFTFaceInside = zeros(NBanglesFaceInside, NBradiusFaceInside);

NBpixelsFFTFaceInside = NBanglesFaceInside*NBradiusFaceInside;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prepare LogPolarTransform

[EyeMaxListSize EyeLogPolTransfoMatrixPixList EyeLogPolTransfoMatrixPixCoef] = GloPLargeFilterInitFdivideFast2(NrowsEye, McolumnsEye, NBanglesFaceInside, NBradiusFaceInside, MaxRadius, FilterPrecision);
EyeMaxListSize=EyeMaxListSize+1;

% Show Filters sum frequency response
%     figure;
%     EyeSamplingMap = zeros(NrowsEye, McolumnsEye);
%     ShowLogPolarSampling_C(zeros(NrowsEye, McolumnsEye), EyeLogPolTransfoMatrixPixList, EyeLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, EyeSamplingMap, EyeMaxListSize);
%     mesh(EyeSamplingMap)
%     title('LogPolar Filters Mapping for Global Eye')
%     colormap(hsv)
%     shading interp



EyeOPLCurrentFFT = zeros(NrowsEye, McolumnsEye);
EyeIPLCurrentFFT = zeros(NrowsEye, McolumnsEye);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Left Eye Spectrum Init %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


EyeLeftLeftOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
EyeLeftNoiseMeanInit = 0;
EyeLeftNoiseMean = 0;
EyeLeftNoiseMeanMultiple=0;
EyeLeftLastStableOPLValue=0;


EyeLeftRecordedEnergy_Hist=zeros(1, MovieStop);

EyeLeftMaxIndexOrientedFrequency=zeros(1, MovieStop);
EyeLeftTotalIPLEnergy=zeros(1, MovieStop);
EyeLeftTotalOPLEnergy=zeros(1, MovieStop);
EyeLeftOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);

EyeLeftOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
EyeLeftalphaCurrentDataHist=zeros(1, MovieStop);
EyeLeftMaxIPLEnergyHistory=zeros(1, MovieStop);
EyeLeftMaxEverHistory=zeros(1, MovieStop);



EyeLeftClosedEnergyLevel_Hist=zeros(1, MovieStop);
EyeLeftOpenedEnergyLevel_Hist=zeros(1, MovieStop);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TemporalEvolutionFilter parameters/variables
EyeLeftalphaMaxIPLEnergy = 0;
EyeLeftalphaCurrentData =0;
EyeLeftMaxIPLEnergy = 0;
EyeLeftNoiseMeanInit = 0;
EyeLeftNoiseMean = 0;
EyeLeftDoubleNoiseMean=0;


% state evolution indicator pre update
EyeLeftStateChange =0;

% MotionDirection Variables init
EyeLeftMotion = 0;
EyeLeftState = 'LeftEyeOpen';
EyeLeftBinaryState =1;


EyeLeft_OPL = zeros(NrowsEye, McolumnsEye);
EyeRight_OPL = zeros(NrowsEye, McolumnsEye);

EyeLeftWindow = sin(double(linspace(3*pi/4, pi/8, HalfNrowsFace)))'*sin(double(linspace(3/4*pi, pi/4, HalfMcolumnsFace)));
EyeRightWindow = sin(double(linspace(3*pi/4, pi/8, HalfNrowsFace)))'*sin(double(linspace(pi/4, 3/4*pi, HalfMcolumnsFace)));
%     figure;
%     subplot(1,2,2)
%     imagesc(EyeRightWindow)
%     title('EyeRightWindow')
%     subplot(1,2,1)
%     imagesc(EyeLeftWindow)
%     title('EyeLeftWindow')
%     figure


EyeLeft_IPL = zeros(NrowsEye, McolumnsEye);
EyeRight_IPL = zeros(NrowsEye, McolumnsEye);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Right Eye Spectrum Init %%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

EyeRightLeftOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
EyeRightNoiseMeanInit = 0;
EyeRightNoiseMean = 0;
EyeRightNoiseMeanMultiple=0;
EyeRightLastStableOPLValue=0;


EyeRightRecordedEnergy_Hist=zeros(1, MovieStop);

EyeRightMaxIndexOrientedFrequency=zeros(1, MovieStop);
EyeRightTotalIPLEnergy=zeros(1, MovieStop);
EyeRightTotalOPLEnergy=zeros(1, MovieStop);
EyeRightOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);

EyeRightOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
EyeRightalphaCurrentDataHist=zeros(1, MovieStop);
EyeRightMaxIPLEnergyHistory=zeros(1, MovieStop);
EyeRightMaxEverHistory=zeros(1, MovieStop);

EyeRightClosedEnergyLevel_Hist=zeros(1, MovieStop);
EyeRightOpenedEnergyLevel_Hist=zeros(1, MovieStop);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TemporalEvolutionFilter parameters/variables
EyeRightalphaMaxIPLEnergy = 0;
EyeRightalphaCurrentData =0;
EyeRightMaxIPLEnergy = 0;
EyeRightNoiseMeanInit = 0;
EyeRightNoiseMean = 0;
EyeRightDoubleNoiseMean=0;

% state evolution indicator pre update
EyeRightStateChange =0;

% MotionDirection Variables init
EyeRightMotion = 0;
EyeRightState = 'RightEyeOpen';
EyeRightBinaryState =1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%% Mouth Spectrum Init %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prepare LogPolarTransform

% new version GloPLargeFilterInitFdivideFast, if buggy use
% GloPLargeFilterInitFdivide

[MouthMaxListSize MouthLogPolTransfoMatrixPixList MouthLogPolTransfoMatrixPixCoef] = GloPLargeFilterInitFdivideFast2(NrowsMouth, McolumnsMouth, NBanglesFaceInside, NBradiusFaceInside, MaxRadius, FilterPrecision);
MouthMaxListSize=MouthMaxListSize+1;
% Show Filters sum frequency response
% figure
% MouthSamplingMap = zeros(NrowsMouth, McolumnsMouth);
% ShowLogPolarSampling_C(zeros(NrowsMouth, McolumnsMouth), MouthLogPolTransfoMatrixPixList, MouthLogPolTransfoMatrixPixCoef, NBanglesFaceInside, NBradiusFaceInside, MouthSamplingMap, MouthMaxListSize);
% mesh(MouthSamplingMap)
% title('LogPolar Filters Mapping for Global Mouth')
% colormap(hsv)
% shading interp
% figure



Mouth_OPL = zeros(NrowsMouth, McolumnsMouth);
Mouth_IPL = zeros(NrowsMouth, McolumnsMouth);

MouthOPLCurrentFFT = zeros(NrowsMouth, McolumnsMouth);
MouthIPLCurrentFFT = zeros(NrowsMouth, McolumnsMouth);

MouthLeftOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
MouthNoiseMeanInit = 0;
MouthNoiseMean = 0;
MouthNoiseMeanMultiple=0;
MouthLastStableOPLValue=0;


MouthRecordedEnergy_Hist=zeros(1, MovieStop);

MouthMaxIndexOrientedFrequency=zeros(1, MovieStop);
MouthTotalIPLEnergy=zeros(1, MovieStop);
MouthTotalOPLEnergy=zeros(1, MovieStop);
MouthOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
SpeechPeriod=zeros(1, MovieStop);

MouthOPLTotalEnergyAdaptativeMean=zeros(1, MovieStop);
MouthalphaCurrentDataHist=zeros(1, MovieStop);
MouthMaxIPLEnergyHistory=zeros(1, MovieStop);
MouthMaxEverHistory=zeros(1, MovieStop);



MouthClosedEnergyLevel_Hist=zeros(1, MovieStop);
MouthOpenedEnergyLevel_Hist=zeros(1, MovieStop);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TemporalEvolutionFilter parameters/variables
MouthalphaMaxIPLEnergy = 0;
MouthalphaCurrentData =0;
MouthMaxIPLEnergy = 0;
MouthNoiseMeanInit = 0;
MouthNoiseMean = 0;
MouthDoubleNoiseMean=0;


% MotionDirection Variables init
MouthMotionActionBinary=0; % binary variable to describe mouth motion action : 0 if closing, 1 if opening
MouthMotion = 0;
MouthState = 'MouthOpen';

% state evolution indicator pre update
MouthStateChange =0;

MouthEnergyGradient=0;

% speech detection variables
MouthMedian=5;
LastMouthStateChangeTable=zeros(MouthMedian,1);

FrameRate=25;
SilenceStart=0;
SilenceEnd=0;

StartDurationYawningLimit=FrameRate*2;
EndDurationYawningLimit=FrameRate*0.5;

MouthStateChangeEnd=0;
MouthStateChangeStart=0;
FrameRate=25;
SilenceTimeLimit=1100;
SpeechTimeLimit=1250;

SilenceLimit=FrameRate*(SilenceTimeLimit/1000);%%??
SpeechLimit=FrameRate*(SpeechTimeLimit/1000);



Threshold=0.2;
MotionDuration=[0 0];
SpeechMotionPeriod=zeros(1, MovieStop);
SpeechPeriod=zeros(1, MovieStop);
ContinueSpeech=0;

StartYawning=0;


