%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Alexandre Benoit, Phillipe Ngo, Guillaume Chanel, Celine Mancas,
% Vjekoslav Levacic, Daniela G. Trevisan, Lionel Lawson, Laurent Bonnaud and Alice Caplier 
 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%  
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
 
% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.
 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% alexandre benoit : benoit.a@neuf.fr ; benoit@lis.inpg.fr ;
% www.lis.inpg.fr/pages_perso/benoit

% YesNoFinder script computes detected head IPL filter output spectrum and
% analysis its energy and orientation


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%% FFT computing
            FaceIPLCurrentFFT = abs(fftshift(fft2(Face_IPL.*FaceHammingWindow)));
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % LogPolar transform using GloP filters
            FastTransfoLogPolFunctionL_C(FaceIPLCurrentFFT, FaceLogPolTransfoMatrixPixList, FaceLogPolTransfoMatrixPixCoef, NBanglesFace, NBradiusFace, IPLLogPolFFTFace, FaceMaxListSize);
            
            % get the energie at the output of the PLI filter 
            IPLOrientedEnergie=sum(IPLLogPolFFTFace');
            
            % Catch the max value
            [MaxOrientedEnergyValue, FaceMaxIndexOrientedEnergy(CurrentFrame)] = max(IPLOrientedEnergie);            
            [FaceMaxValue(CurrentFrame), FaceMaxIndexOrientedFrequency(CurrentFrame)]=max(IPLLogPolFFTFace(FaceMaxIndexOrientedEnergy(CurrentFrame), :));
            
%             MaxOrientedEnergyValueVector = MaxValue(CurrentFrame)*FrequencyVector;
%             MaxOrientedFrequencyValueVector = MaxValue(CurrentFrame)*OrientationVector;
%             IPLShowLogPolSpectrum = IPLLogPolFFT';
            
            
            % Computing the Total IPL energy
            FaceTotalIPLEnergy(CurrentFrame) = sum(IPLOrientedEnergie);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % Computing Mean Values : 
            
           %%% Extract motion evolution
           if CurrentFrame < 20
            % first evaluate the noise to avoid interpretation errors
            if CurrentFrame >8
                FaceNoiseMeanInit = FaceNoiseMeanInit+FaceTotalIPLEnergy(CurrentFrame);
                FaceMaxIPLEnergy = FaceNoiseMeanInit/20;  
                FaceMaxEver = 0;
                FaceNoiseMean = FaceNoiseMeanInit/12;
            end
           else
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%% Evaluating variables signification
            FaceMaxIPLEnergy = FaceMaxIPLEnergy*0.9; % MaxEnergy decreases in the time => be aware of all events even smallest but significant...
            FaceMaxEver= FaceMaxEver*0.99;
            
            if FaceTotalIPLEnergy(CurrentFrame)-FaceNoiseMean > 0
            
                %CurrentFrame
                % Update the max value limit :
                FaceMaxIPLEnergy = max(FaceMaxIPLEnergy, FaceTotalIPLEnergy(CurrentFrame)-FaceNoiseMean);

                % computing maximum energy to avoid noise problem in the
                
                FaceMaxEver = max(FaceMaxIPLEnergy, FaceMaxEver);
                FacealphaMaxEver = FaceMaxIPLEnergy/FaceMaxEver;

                FacealphaMaxIPLEnergy = abs((FaceTotalIPLEnergy(CurrentFrame)-FaceNoiseMean))/FaceMaxIPLEnergy;
                FacealphaMaxIPLEnergy=FacealphaMaxIPLEnergy*FacealphaMaxIPLEnergy;
                %alphaIPLHistory(CurrentFrame) = alphaMaxIPLEnergy;
                FacealphaCurrentData = FacealphaMaxIPLEnergy*FacealphaMaxEver;
            
            else
                FacealphaCurrentData =0;
                FacealphaMaxIPLEnergy=0;
            end
                
            %alphaIPLHistory(CurrentFrame) = alphaMaxIPLEnergy;
            FacealphaCurrentDataHist(CurrentFrame)=FacealphaCurrentData;
            
            FaceMaxIPLEnergyHistory(CurrentFrame) = FaceMaxIPLEnergy;
            FaceMaxEverHistory(CurrentFrame) = FaceMaxEver;            
            % Computing mean values
            FaceOrientedEnergyMean = FaceOrientedEnergyMean*(1-FacealphaCurrentData) + FacealphaCurrentData*FaceMaxIndexOrientedEnergy(CurrentFrame);
            FaceMaxIDOrientedEnergyMean(CurrentFrame) = FaceOrientedEnergyMean;
            
            FaceOrientedFrequencyMean = FaceOrientedFrequencyMean*(1-FacealphaCurrentData) + FacealphaCurrentData*FaceMaxIndexOrientedFrequency(CurrentFrame);
            FaceMaxIDOrientedFreqMean(CurrentFrame) = FaceOrientedFrequencyMean;
            
             % graph result display
%             IPLShowLogPolSpectrum(:,round(OrientedEnergyMean)) = MaxOrientedEnergyValueVector';
%             IPLShowLogPolSpectrum(round(OrientedFrequencyMean), :) = MaxOrientedFrequencyValueVector';
%             OPLShowLogPolSpectrum(:,round(OrientedEnergyMean)) = MaxOrientedEnergyValueVector';
%             OPLShowLogPolSpectrum(round(OrientedFrequencyMean), :) = MaxOrientedFrequencyValueVector';
              
                if ActivateFullYexNoDetection
                    EnergyGradient(CurrentFrame) = (FaceTotalIPLEnergy(CurrentFrame)-FaceTotalIPLEnergy(CurrentFrame-1));

                    % if energy maximum is reached and if there are no Eye
                    % Blinks/Mouth Yawning
                    if  (EnergyGradient(CurrentFrame-1) > 0) && (EnergyGradient(CurrentFrame) < 0 && NoNonRigidMotionActiv)

                        %MotionState = ['frame : ' num2str(CurrentFrame) 'Max Motion Reached']
                        [FaceMaxCounter, FaceAttitudeState, FaceMaxHistory, FaceOrientationHistory, FaceExtremumTimeHistory]  = OuiNonFinderFunction1(FaceMaxCounter, FaceEventNumberCount, NBanglesFace, CurrentFrame-1, FaceMaxIndexOrientedEnergy(CurrentFrame-1), FaceMaxHistory, FaceOrientationHistory, FaceExtremumTimeHistory, FPSmean, FacealphaCurrentDataHist(CurrentFrame-1));

                    end

                end
               
           end
            
           
           
           
