% luminance correction (photoreceptors modelling)
% input:
%   -> 1.Gray level (type is double) image
%   -> 2.local luminance adaptation sensitivity: the area in pixels on
%   which the luminance is adapted
% output: localy adapted picture (type is double)
function output=localLuminanceAdaptation(InputGrayPicture, localAdaptationRange)

% init parameters
[Nrows, Mcolumns]=size(InputGrayPicture);
photoreceptorsCoefs=InitSpatialLPFilter( 0, 0, localAdaptationRange);
output=zeros(Nrows, Mcolumns);
% compute adaptation
PhotoreceptorsCompression(InputGrayPicture, output, Nrows, Mcolumns, photoreceptorsCoefs);
