function setRetinaParameters(OPLspatialResponse1, OPLtemporalresponse1, OPLassymetryGain, OPLspatialResponse2, OPLtemporalresponse2, LPfilterSpatialResponse, LPfilterGain, LPfilterTemporalresponse, MovingContoursExtractorCoefficient)

global SpatialLPFilterCoefTable OPLCoefTable IPLparameter

% init OPL stage retina (contours extractor)    % First stage retina
%   input parameters:
%       ->OPLspatialResponse1: spatial blurrying response, unit is
%       pixel, its goal: high frequency noise removal, put a small value,
%       tipically 1
%       ->OPLtemporalresponse1: temporal response of the filter, unit is
%       frame, its goal temporal noise removal, let it low, tipically 1
%       ->OPLassymetryGain:amplifying coefficient that creates the
%       assymetric effect on contours boundaries...not always usefull, let
%       it between 0(no assymetry) and 1
%       ->OPLspatialResponse2:spatial blurrying response, unit is
%       pixel, goal: local luminance extraction, put is high, tipically 5
%       ->OPLtemporalresponse2: second temporal response of the OPL filter, unit is
%       frame, its goal temporal adaptation, let it low, tipically 1, it can
%       be increased, stay above OPLtemporalresponse1
    
    OPLCoefTable = ones (8,1);
    beta_1 = OPLtemporalresponse1;
    
	alpha = double(OPLspatialResponse1*OPLspatialResponse1);
	mu = double(0.8);
	temp =  double((1+beta_1)/(2*mu*alpha));
	a =  1 + temp - sqrt( double( (1+temp)*(1+temp) - 1) );
	OPLCoefTable(1) = (1-a)*(1-a)*(1-a)*(1-a)/(1+beta_1);
	OPLCoefTable(2) = 1;
    OPLCoefTable(3) = a;
    OPLCoefTable(4) = OPLtemporalresponse1;

    
    % Second stage retina
    beta_2 = OPLassymetryGain+OPLtemporalresponse2;
    
	alpha = double(OPLspatialResponse2*OPLspatialResponse2);
	mu = double(0.8);
	temp =  double((1+beta_2)/(2*mu*alpha));
	a =  1 + temp - sqrt( double( (1+temp)*(1+temp) - 1) );
	OPLCoefTable(5) = (1-a)*(1-a)*(1-a)*(1-a)/(1+beta_2);
	OPLCoefTable(6) = 1;
    OPLCoefTable(7) = a;
    OPLCoefTable(8) = OPLtemporalresponse2;

% init standard low pass filter (spatial and temporal blurrying filter) parameters
%   input parameters:
%       ->LPfilterSpatialResponse: spatial blurrying response, unit is
%       pixel
%       ->LPfilterGain: amplifying coefficient
%       ->LPfilterTemporalresponse: temporal response of the filter, unit is
%       frame

	SpatialLPFilterCoefTable = ones (4,1);
    LPfilterGain = LPfilterGain+LPfilterTemporalresponse;
    
	alpha = double(LPfilterSpatialResponse*LPfilterSpatialResponse);
	mu = double(0.8);
	temp =  double((1+LPfilterGain)/(2*mu*alpha));
	a =  1 + temp - sqrt( double( (1+temp)*(1+temp) - 1) );
	SpatialLPFilterCoefTable(1) = (1-a)*(1-a)*(1-a)*(1-a)/(1+LPfilterGain);
	SpatialLPFilterCoefTable(2) = 1;
    SpatialLPFilterCoefTable(3) = a;
    SpatialLPFilterCoefTable(4) = LPfilterTemporalresponse;

% init IPL stage retina (Moving contours extractor)
%   input parameters:
%       ->tauIPL: temporal response of the desired first order high pass temporal filter
IPLparameter = exp(-1/MovingContoursExtractorCoefficient)
'Retina parameters updatess done'
