function varargout = silatuto(varargin)
% Project #3, Sign Language Tutoring Tool
% eNTERFACE'06 The SIMILAR NoE Workshop  on Multimodal Interfaces
% July 17 - August 11, 2006, @ Dubrovnik, Croatia
% Project Description: The goal of this project is the development of a
%  real time sign language tutoring tool related to a limited number of 
%  well defined gestures which associate hand gestures and head motion and 
%  facial expressions. This will exhibit the feasibility of such a system 
%  which requires the fusion of three sources of information.

%%%    PROJECT TEAM    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lale Akarun, LEADER/SENIOR, Bogazici University, TURKEY 
% Alice Caplier, LEADER/SENIOR, Universite de Grenoble, FRANCE 
% Michele Rombaut, LEADER/SENIOR, Universite de Grenoble, FRANCE 
% Bulent Sankur, LEADER/SENIOR, Bogazici University, TURKEY 
% Oya Aran, Bogazici University, TURKEY 
% Ismail Ari, Bogazici University, TURKEY 
% Alexandre Benoit, Universite de Grenoble, FRANCE 
% Ana Huerta, Technical University of Madrid, SPAIN 
% Fanard Franois-Xavier,   Universite Catholique de Louvain (UCL), BELGIUM 
% Campr Pavel,  University of West Bohemia, CZECH REPUBLIC  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @silatuto_OpeningFcn, ...
                   'gui_OutputFcn',  @silatuto_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before silatuto is made visible.
function silatuto_OpeningFcn(hObject, eventdata, handles, varargin)
global exited exitedTraining
handles.output = hObject;
handles.trainingDirPath = 'trainingVideos';
exited = 0;
exitedTraining = 0;

% Set the GUI images
axes(handles.titleAxes);
imshow(imread('images/sltt.jpg'));
axes(handles.blankAxes1);
imshow(imread('images/blankImg.jpg'));
axes(handles.blankAxes2);
imshow(imread('images/blankImg.jpg'));
axes(handles.blankAxes3);
imshow(imread('images/blankImg.jpg'));

% hide the video windows
axes(handles.trainingAxes);
axis off;
axes(handles.acquisitionAxes);
axis off;
axes(handles.synthesisAxes);
axis off;

% Disable the acquisition and synthesized buttons, they will e enabled after trial
% set(handles.acquisitionPlayButton,  'Enable', 'off');
% set(handles.acquisitionPauseButton, 'Enable', 'off');
% set(handles.acquisitionStopButton,  'Enable', 'off');
% set(handles.synthesisPlayButton,  'Enable', 'off');
% set(handles.synthesisPauseButton, 'Enable', 'off');
% set(handles.synthesisStopButton,  'Enable', 'off');
slttFillTrainingPopupMenu(handles);

handles.shirt = 'shirt4';

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = silatuto_OutputFcn(hObject, eventdata, handles) 
varargout{1} = handles.output;



% --------------------------------------------------------------------
function trainingPopup_Callback(hObject, eventdata, handles)
val = get(hObject,'Value');
string_list = get(hObject,'String');
handles.trainingFilename = string_list{val}; % convert from cell array
guidata(hObject, handles);
% Change the information text
set(handles.signInfoText,'String',handles.trainingFilename);
set(handles.infoText,'String','');

% --------------------------------------------------------------------
function trainingPopup_CreateFcn(hObject, eventdata, handles)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

% --------------------------------------------------------------------
function trainingPlayButton_Callback(hObject, eventdata, handles)
global exited exitedTraining    % 'exited' is for exiting entire program
                                % 'exitedTraining' is for exiting only training part
global pauseTraining;           % to simulate pause button                                
pauseTraining = 0;

% Stop the other video displays
global exitedAcquisition exitedSynthesis
exitedAcquisition = 1;
exitedSynthesis = 1;
set(handles.acquisitionPauseButton,'Value',0);
set(handles.synthesisPauseButton,'Value',0);

exitedTraining = 0; % initially 0, it will be 1 when user stops the video show

set(handles.trainingPauseButton,'Value',0);

% Read the current video file which is chosen by the user
val = get(handles.trainingPopup,'Value');
string_list = get(handles.trainingPopup,'String');
handles.trainingFilename = string_list{val}; 

% Find the full path
filename = [handles.trainingDirPath '/' handles.trainingFilename '.avi'];
% Find number of frames and frames/second rate
fileinfo = aviinfo(filename);
fps = fileinfo.FramesPerSecond;
mov = aviread(filename); % read the movie
kLimit = length(mov);

k = 1;
% Continue in loop while there are frames and the user did not press exit
% button or stop button.
axes(handles.trainingAxes); % Select the correct axes to display video
while k <= kLimit && ~exited && ~exitedTraining
    imgRGB = frame2im(mov(k));
    imshow(imgRGB);
    drawnow
    k = k+1;
    while (~exited && pauseTraining); drawnow; pause(0.001); end;
    pause(0.001);
end
exitedTraining = 1; % set to 1 stating that the user pressed 0.
% Note: In the lack of such control variables, the program continued to go
% on displaying the remaining of the previous video. These variables
% prevent that. 

clear mov;

% --------------------------------------------------------------------
function trainingStopButton_Callback(hObject, eventdata, handles)
global exitedTraining;
set(handles.trainingPauseButton,'Value',0);
exitedTraining = 1;

% --------------------------------------------------------------------
function trainingPauseButton_Callback(hObject, eventdata, handles)
global pauseTraining;
if pauseTraining == 0
    pauseTraining = 1;
else
    pauseTraining = 0;
end


% --------------------------------------------------------------------
function acqusitionTryButton_Callback(hObject, eventdata, handles)
set(handles.infoText,'String','');
val = get(handles.trainingPopup,'Value');
string_list = get(handles.trainingPopup,'String');
handles.trainingFilename = string_list{val}; % convert from cell array
filename = [handles.trainingDirPath '/' handles.trainingFilename '.avi'];
signNo = slttStr2SignNo(handles.trainingFilename);

fclose('all'); % Close all open files
[status handdecision headdecision error] = slttAcquisition(signNo);
% status = 0;
% handdecision = 1;
% headdecision = 0;
% error = 'deneme yazisidir.';

if (status)
    if handdecision == 1 & headdecision == 1
        set(handles.infoText,'Foregroundcolor',[0 0.8 0]);
        set(handles.infoText,'Fontweight','Bold');
        set(handles.infoText,'Fontsize', 15);
        str = 'OK';
    elseif handdecision == 1 & headdecision == 0
        set(handles.infoText,'Foregroundcolor',[0 0 0.6]);
        set(handles.infoText,'Fontweight','Bold');
        set(handles.infoText,'Fontsize', 11);
        str = 'Hand Analysis Result: True';
        str = strvcat(str,'Head Analysis Result: False');
    else
        set(handles.infoText,'Foregroundcolor',[1 0 0]);
        set(handles.infoText,'Fontweight','Bold');
        set(handles.infoText,'Fontsize', 15);
        str = 'False';
    end
    set(handles.infoText,'String',str);
else
    set(handles.infoText,'String',error);    
    set(handles.infoText,'Foregroundcolor',[1 0 0]);
    set(handles.infoText,'Fontweight','Normal');
    set(handles.infoText,'Fontsize', 11);
end

% enable the buttons now 
set(handles.acquisitionPlayButton, 'Enable', 'on');
set(handles.acquisitionPauseButton, 'Enable', 'on');
set(handles.acquisitionStopButton, 'Enable', 'on');
set(handles.synthesisPlayButton, 'Enable', 'on');
set(handles.synthesisPauseButton, 'Enable', 'on');
set(handles.synthesisStopButton, 'Enable', 'on');


% --------------------------------------------------------------------
function acquisitionPlayButton_Callback(hObject, eventdata, handles)
global exited exitedAcquisition % 'exited' is for exiting entire program
                                % 'exitedAcquisition' is for exiting only acquisition part
global pauseAcquisition         % to simulate pause button                                

% Stop the other video displays
global exitedTraining exitedSynthesis
exitedTraining = 1;
exitedSynthesis = 1;
set(handles.trainingPauseButton,'Value',0);
set(handles.synthesisPauseButton,'Value',0);

exitedAcquisition = 0; % initially 0, it will be 1 when user stops the video show
pauseAcquisition = 0;
set(handles.acquisitionPauseButton,'Value',0);

val = get(handles.acquisitionPopup,'Value');
if val == 1 % Show original
    % File is 'capture.avi' in 'acquisition' folder
    filename = ['_data/captured.avi'];
else
    % File is 'segmented.avi' in 'acquisition' folder
    filename = ['_data/segmented.avi'];
end

% Find number of frames and frames/second rate
fileinfo = aviinfo(filename);
fps = fileinfo.FramesPerSecond;
mov = aviread(filename); % read the movie
kLimit = length(mov);

k = 1;
% Continue in loop while there are frames and the user did not press exit
% button or stop button.
axes(handles.acquisitionAxes); % Select the correct axes to display video
while k <= kLimit && ~exited && ~exitedAcquisition
    imgRGB = frame2im(mov(k));
    imshow(imgRGB);
    drawnow
    k = k+1;
    while (~exited && pauseAcquisition); drawnow; pause(0.001); end;
    pause(0.001);
end
exitedAcquisition = 1; % set to 1 stating that the user pressed 0.
% Note: In the lack of such control variables, the program continued to go
% on displaying the remaining of the previous video. These variables
% prevent that. 



function slttFillTrainingPopupMenu(handles)
% Fills the training popupmenu with the 
% filenames in 'trainingVideos'directory
dir_struct = dir([handles.trainingDirPath '/*.avi']);
[sorted_names, sorted_index] = sortrows({dir_struct.name}');
for i=1:length(sorted_names)
    sorted_names{i} = slttRemoveExtension(sorted_names{i});
end
handles.trainingFilenames = sorted_names;
set(handles.trainingPopup,'String',handles.trainingFilenames,'Value',1);

function filename = slttRemoveExtension(filenameWithExtension)
% Removes the extension from the filename 
indices = findstr(filenameWithExtension,'.');
index = indices(end);
filename = filenameWithExtension(1:index-1);

% --------------------------------------------------------------------
function acquisitionStopButton_Callback(hObject, eventdata, handles)
global exitedAcquisition;
set(handles.acquisitionPauseButton,'Value',0);
exitedAcquisition = 1;

% --------------------------------------------------------------------
function acquisitionPauseButton_Callback(hObject, eventdata, handles)
global pauseAcquisition;
if pauseAcquisition == 0
    pauseAcquisition = 1;
else
    pauseAcquisition = 0;
end

% --------------------------------------------------------------------
function synthesisPlayButton_Callback(hObject, eventdata, handles)
global exited exitedSynthesis  % 'exited' is for exiting entire program
                               % 'exitedSynthesis' is for exiting only synthesis part
global pauseSynthesis          % to simulate pause button                                

global exitedTraining exitedAcquisition
exitedTraining = 1;
exitedAcquisition = 1;
set(handles.trainingPauseButton,'Value',0);
set(handles.acquisitionPauseButton,'Value',0);


exitedSynthesis = 0; % initially 0, it will be 1 when user stops the video show
pauseSynthesis = 0;
set(handles.synthesisPauseButton,'Value',0);

% File is 'synth.avi' in 'synthesis' folder
filename = ['synthesis/synth.avi'];

% Find number of frames and frames/second rate
fileinfo = aviinfo(filename);
fps = fileinfo.FramesPerSecond;
mov = aviread(filename); % read the movie
kLimit = length(mov);
k = 1;
% Continue in loop while there are frames and the user did not press exit
% button or stop button.
axes(handles.synthesisAxes); % Select the correct axes to display video
while k <= kLimit && ~exited && ~exitedSynthesis
    imgRGB = frame2im(mov(k));
    imshow(imgRGB);
    drawnow
    k = k+1;
    while (~exited && pauseSynthesis); drawnow; pause(0.001); end;
    pause(0.001);
end

exitedSynthesis = 1; % set to 1 stating that the user pressed 0.
% Note: In the lack of such control variables, the program continued to go
% on displaying the remaining of the previous video. These variables
% prevent that. 

% --------------------------------------------------------------------
function synthesisStopButton_Callback(hObject, eventdata, handles)
global exitedSynthesis;
set(handles.synthesisPauseButton,'Value',0);
exitedSynthesis = 1;

% --------------------------------------------------------------------
function synthesisPauseButton_Callback(hObject, eventdata, handles)
global pauseSynthesis;
if pauseSynthesis == 0
    pauseSynthesis = 1;
else
    pauseSynthesis = 0;
end

% --------------------------------------------------------------------
function acquisitionPopup_Callback(hObject, eventdata, handles)
val = get(hObject,'Value');
string_list = get(hObject,'String');
handles.acquisitionDisplay = string_list{val}; % convert from cell array
guidata(hObject, handles);

% --------------------------------------------------------------------
function quitMenu_Callback(hObject, eventdata, handles)
global exited;
exited = 1; % Set to 1 so that all executing procedures will be cancelled
close all;

% --------------------------------------------------------------------
function helpMenu_Callback(hObject, eventdata, handles)
web([cd '\doc\help.htm'],'-noaddressbox'); % Show the help page


% --------------------------------------------------------------------
function aboutMenu_Callback(hObject, eventdata, handles)
web([cd '\doc\about.htm'],'-noaddressbox'); % Show the about page

% --------------------------------------------------------------------
function signNo = slttStr2SignNo(signName)
% set the sign number (it will be used as a parameter in the recognition part)
if     strcmp(signName,'open door (noun)')  signNo = 1;
elseif strcmp(signName,'to open door')  signNo = 2;
elseif strcmp(signName,'drink (noun)') signNo = 3;
elseif strcmp(signName,'to drink') signNo = 4;
elseif strcmp(signName,'here')      signNo = 5;
elseif strcmp(signName,'is here')    signNo = 6;
elseif strcmp(signName,'not here')   signNo = 7;
elseif strcmp(signName,'look at')    signNo = 8;
elseif strcmp(signName,'look at continuously')signNo = 9;
elseif strcmp(signName,'look at regularly') signNo = 10;
elseif strcmp(signName,'study')     signNo = 11;
elseif strcmp(signName,'study continuously') signNo = 12;
elseif strcmp(signName,'study regularly')  signNo = 13;
elseif strcmp(signName,'afraid')    signNo = 14;
elseif strcmp(signName,'very afraid')signNo = 15;
elseif strcmp(signName,'clean')     signNo = 16;
elseif strcmp(signName,'very clean') signNo = 17;
elseif strcmp(signName,'fast')      signNo = 18;
elseif strcmp(signName,'very fast')  signNo = 19;
end

% --------------------------------------------------------------------
function synthesizeButton_Callback(hObject, eventdata, handles)
val = get(handles.trainingPopup,'Value');
string_list = get(handles.trainingPopup,'String');
handles.trainingFilename = string_list{val}; % convert from cell array
filename = [handles.trainingDirPath '/' handles.trainingFilename '.avi'];
signNo = slttStr2SignNo(handles.trainingFilename);


cd('synthesis');

% Set the t-shirt
mergedImg = imread(['../images/' handles.shirt '.jpg']);

h = waitbar(0,'Creating the ''hands'' video');
cd('hand');
%% Currently, the executable is called for only 'clean' and 'very clean'
%% signs, for the others, predefined videos are used.
if signNo == 16 | signNo == 17
    copyfile('..\..\_data\handsynthesis.txt','handsynthesis.txt')
    dos('DemBones.exe'); % Call the executable that creates the hands video
else
    copyfile([num2str(signNo) '.avi'],'hand.avi')
end
cd('..');
waitbar(0,h,'Creating the ''head'' video');

cd('head');
usePredefinedHeadVideos = 1;
if ~usePredefinedHeadVideos
    dos('C:\sltt\wxFaceEd\Debug\XfaceEd.exe'); % Call the executable that creates the head video
else
    copyfile([num2str(signNo) '.avi'],'head.avi')
end
cd('..');
waitbar(0,h,'Creating the final video');

headInfo = aviinfo('head/head.avi');
handInfo = aviinfo('hand/hand.avi');
headNumFrames = headInfo.NumFrames;
handNumFrames = handInfo.NumFrames;
numFrames = max(headNumFrames,handNumFrames);


headVideo = aviread('head/head.avi');
handVideo = aviread('hand/hand.avi');

% Start witht he second frame, because first frame in the hand video is false
for k=2:numFrames
    % if the fame number exceeds the video frame number, then it will copy
    % the last frame until reaching the numFames
    if(k <= headNumFrames)
        headImg = frame2im(headVideo(k));
    end
    if(k <= handNumFrames)
        handImg = frame2im(handVideo(k));
    end
    % merge the frames
    mergedMov(k-1) = im2frame(slttMergeHeadAndHands(headImg,handImg,mergedImg));
    waitbar(k/numFrames,h);
end
waitbar(1,h,'Writing the video on disk.');
movie2avi(mergedMov,'synth.avi','compression','Indeo5','fps',25); % save the video
close(h);
cd('..');



% --------------------------------------------------------------------
% Avatar T-Shirt Selection Part: For all callbacks; the 'shirt' variable is
% set and the corresponding menu option is checked whereas the other
% options are unchecked.
% --------------------------------------------------------------------
function selectShirt1_Callback(hObject, eventdata, handles)
handles.shirt = 'shirt1';
set(handles.selectShirt1,'Checked','on');
set(handles.selectShirt2,'Checked','off');
set(handles.selectShirt3,'Checked','off');
set(handles.selectShirt4,'Checked','off');
set(handles.selectShirt5,'Checked','off');
set(handles.selectShirt6,'Checked','off');
guidata(hObject, handles);
% --------------------------------------------------------------------
function selectShirt2_Callback(hObject, eventdata, handles)
handles.shirt = 'shirt2';
set(handles.selectShirt1,'Checked','off');
set(handles.selectShirt2,'Checked','on');
set(handles.selectShirt3,'Checked','off');
set(handles.selectShirt4,'Checked','off');
set(handles.selectShirt5,'Checked','off');
set(handles.selectShirt6,'Checked','off');
guidata(hObject, handles);
% --------------------------------------------------------------------
function selectShirt3_Callback(hObject, eventdata, handles)
handles.shirt = 'shirt3';
set(handles.selectShirt1,'Checked','off');
set(handles.selectShirt2,'Checked','off');
set(handles.selectShirt3,'Checked','on');
set(handles.selectShirt4,'Checked','off');
set(handles.selectShirt5,'Checked','off');
set(handles.selectShirt6,'Checked','off');
guidata(hObject, handles);
% --------------------------------------------------------------------
function selectShirt4_Callback(hObject, eventdata, handles)
handles.shirt = 'shirt4';
set(handles.selectShirt1,'Checked','off');
set(handles.selectShirt2,'Checked','off');
set(handles.selectShirt3,'Checked','off');
set(handles.selectShirt4,'Checked','on');
set(handles.selectShirt5,'Checked','off');
set(handles.selectShirt6,'Checked','off');
guidata(hObject, handles);
% --------------------------------------------------------------------
function selectShirt5_Callback(hObject, eventdata, handles)
handles.shirt = 'shirt5';
set(handles.selectShirt1,'Checked','off');
set(handles.selectShirt2,'Checked','off');
set(handles.selectShirt3,'Checked','off');
set(handles.selectShirt4,'Checked','off');
set(handles.selectShirt5,'Checked','on');
set(handles.selectShirt6,'Checked','off');
guidata(hObject, handles);
% --------------------------------------------------------------------
function selectShirt6_Callback(hObject, eventdata, handles)
handles.shirt = 'shirt6';
set(handles.selectShirt1,'Checked','off');
set(handles.selectShirt2,'Checked','off');
set(handles.selectShirt3,'Checked','off');
set(handles.selectShirt4,'Checked','off');
set(handles.selectShirt5,'Checked','off');
set(handles.selectShirt6,'Checked','on');
guidata(hObject, handles);


