function mergedImg = slttMergeHeadAndHands(headImg,handImg,mergedImg)
% This function takes three images. Initial 'mergedImage' is the bacground
% image that involves the t-shirt. 'head' and 'hand' images are seperate head
% and hand images. It merges them and returns the 'mergedImage' as a
% result.

% headImg = imread('head.jpeg');    % //delete
% handImg = imread('hands1.jpeg');  % //delete
% mergedImg = imread('shirt4.jpg'); % //delete

% Set the shift size of the head image for both horizontal and vertical
% directions.
[heightHead,widthHead,dummy] = size(headImg);
headStartI = 12;
headEndI = headStartI+heightHead-1;
headStartJ = 105;
headEndJ = headStartJ+widthHead-1;

% Merge the head witht the bacground t-shirt image.
% i=1:heightHead;
% j=1:widthHead;
% mergedImg(i+headStartI,j+headStartJ,:) = headImg(i,j,:) + mergedImg(i+headStartI,j+headStartJ,:) ;
for i=1:heightHead
    for j=1:widthHead
        if mergedImg(i+headStartI,j+headStartJ,1) < 50
            mergedImg(i+headStartI,j+headStartJ,1) = headImg(i,j,1) + mergedImg(i+headStartI,j+headStartJ,1);
            mergedImg(i+headStartI,j+headStartJ,2) = headImg(i,j,2) + mergedImg(i+headStartI,j+headStartJ,2);
            mergedImg(i+headStartI,j+headStartJ,3) = headImg(i,j,3) + mergedImg(i+headStartI,j+headStartJ,3);
        end
    end
end

% Add the arms
for i=61:240 % These bound are only for decreasing the runtime, the arms will not be in that region
    % Then, no need to search for those pixels
    for j=36:285
        if(~(handImg(i,j,1)<30 & handImg(i,j,2)<30 & handImg(i,j,3)<30))
        % if part finds the arm pixels, it eliminates the black pixels in arms image
            mergedImg(i,j,1) =  handImg(i,j,1);
            mergedImg(i,j,2) =  handImg(i,j,2);
            mergedImg(i,j,3) =  handImg(i,j,3);
        end
    end
end
% imshow(mergedImg);  % //delete