function CC4M_AllFileList(DIR,p,ALT_NAME)
%look for folders in DIR and write a text file with the contained wav files. These have to contain wav files, there has to be
%a separate folder for each target
% Inputs:
% DIR       folder with the spectral base data
% p         parameter structure (for docu see NM4M_ParamInit.m)
% ALT_NAME  specifies the data list names and the name of the classifier to
%           be written
%
%
%
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project

p = CC4M_ParamInit(p);%set parameters to standard values if not set

baseparmstr = ['_' num2str(p.winlength) '_' num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) ... 
    '_' num2str(p.use_first_coeff) '.mat']; 
D = dir(DIR);k=0;
for i=1:length(D)
    if(D(i).isdir & ~(D(i).name(1) == '.'))
	k=k+1;
	soundDir(k)=D(i);
    end
end
if(k>0)
    for i=1:k
        ClassName{i} = fullfile( DIR, soundDir(i).name) ;
        TrainListName = fullfile(ClassName{i},[ALT_NAME '_TrainListMFCC.txt']);
        fprintf('\nWriting Test and Train data lists for: %s\n', ClassName{i});
        TL = dir([ClassName{i} '/*.wav']);
        numFiles=length(TL);
        textwrite({TL(1:numFiles).name}, TrainListName);
    end
else
    fprintf('\nOoooops! There are no appropriate files.\n');
end
