function CC4M_CompFeat(DIR,p,ALT_NAME)
%construct MFCC from the wav files in folder DIR
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project

p = CC4M_ParamInit(p);%set parameters to standard values if not set

% Get directory structures for each sound class
D = dir(DIR);k=0;
for i=1:length(D)
    if(D(i).isdir & ~(D(i).name(1) == '.'))
	k=k+1;
	soundDir(k)=D(i);
    end
end
if(k>0)
    NumDatAllClass = 0;
    %compute the features
    for i=1:k
        ClassName{i} = fullfile( DIR, soundDir(i).name) ;
        fprintf('\nConstructing feature vectors for: %s\n', ClassName{i});
        TL=dir([ClassName{i} '/*.wav']);
        for j=1:length(TL)
             AllList{i}.file{j}=fullfile(DIR,soundDir(i).name,TL(j).name);
             if (~exist([AllList{i}.file{j}(1:length(AllList{i}.file{j})-4) '_' num2str(p.winlength) '_' ...
                     num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.use_first_coeff) '.mat']))
                [wav,p.fs] = wavread(AllList{i}.file{j});
                if (p.fs ~= 16000)
                    error('Wrong sampling frequency of the input file, 16kHz is assumed!');
                end
                mfcc = Comp_MFCC(wav,p);
                if p.use_deltas
                    delta = deltas(mfcc',9);
                    deltadelta = deltas(delta,9);
                    mfcc = [mfcc;delta';deltadelta'];
                end
                save([AllList{i}.file{j}(1:length(AllList{i}.file{j})-4) '_' num2str(p.winlength) '_' ...
                     num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' num2str(p.use_deltas) '.mat'],'mfcc');
             else
                fprintf('\nFound feature vectors for: %s', AllList{i}.file{j}); 
             end
        end
    end
end