function p = CC4M_ParamInit(p)
%sets the fields of p to the most probable settings if not defined by user
%
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project

%% defaults
if ~isfield(p,'bpo'),      p.bpo = 4;         end
if ~isfield(p,'winlength'),      p.winlength = 0.025;         end
if ~isfield(p,'overlap'),      p.overlap = 0.5;         end
%set the arguments used by the MA toolbox. The toolbox is used to calculate
%the sonograms of the audio files
if ~isfield(p,'fs'),      p.fs = 16000;         end
if ~isfield(p,'dB_max'),      p.dB_max = 96;         end
if ~isfield(p,'do_visu'),      p.do_visu = 0;         end
if ~isfield(p,'num_ceps_coeffs'),      p.num_ceps_coeffs = 12;         end
if ~isfield(p,'use_first_coeff'),      p.use_first_coeff = 0;         end
if ~isfield(p,'max_iter') p.max_iter = 50; end
if ~isfield(p,'hopsize'),      p.hopsize = 160;         end
if ~isfield(p,'fft_size'),      p.fft_size = 320;         end
if ~isfield(p,'visu'),      p.visu = 0;         end
if ~isfield(p,'train_num'), p.train_num = 1; end %value 0..1: fraction of data used for training
if ~isfield(p,'crossrun'), p.crossrun = 0; end
if ~isfield(p,'feature'), p.feature=2; end %MFCC feature type
if ~isfield(p,'nrg'), p.nrg = 1; end%compute the energy from the frame and put it to the feature vec
if ~isfield(p,'use_deltas'), p.use_deltas = 1; end%compute the energy from the frame and put it to the feature vec
if ~isfield(p,'clust_meth'), p.clust_meth = 'kmeans'; end%choose kmeans or gmeans
if ~isfield(p,'num_clusters'), p.num_clusters = 50; end%choose kmeans or gmeans
p.fft_size = p.fs * p.winlength;%size of the fft window in samples
p.hopsize = p.fft_size * (1-p.overlap);% size of the hop in samples
p.bark_type = [62.5 8000 (7*p.bpo)];%sets low/high freq bounds and the spectral resolution in each of the 7 octaves
%spanned by the frequency range
%62.5...8000