function VQonMFCC(DIR,p,ALT_NAME)
%train a vector quantization for MFCC

p = CC4M_ParamInit(p);%set parameters to standard values if not set
TRAIN_LIST_NAME = [ALT_NAME '_TrainListMFCC.txt'];

% Get directory structures for each target
D = dir(DIR);k=0;
for i=1:length(D)
    if(D(i).isdir & ~(D(i).name(1) == '.'))
	k=k+1;
	soundDir(k)=D(i);
    end
end
if(k>0)
    NumDatAllClass = 0;
    %train separate clustering
    for i=1:k
        ClassName{i} = fullfile( DIR, soundDir(i).name) ;
        fprintf('\nReading feature vectors from disk: %s\n', ClassName{i});
        sfxfilename = fullfile( ClassName{i}, TRAIN_LIST_NAME );
        fileList = readsfxfiles(sfxfilename);
        mfcc_all.mfcc = [];%field for the features
        mfcc_all.index = [];%field for the frame indices
        mfcc_all.name = [];%field for the file name
        for j=1:length(fileList)%read the features from the files
             AllList{i}.file{j}=fullfile(ClassName{i},fileList{j});
             open([AllList{i}.file{j}(1:length(AllList{i}.file{j})-4) '_' num2str(p.winlength) '_' ...
                     num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']);
             mfcc = ans.mfcc;
             mfcc_all.mfcc = cat(2,mfcc_all.mfcc,mfcc);
             mfcc_all.index = cat(2,mfcc_all.index,[ 1:size(mfcc,2)]);
             mfcc_all.name = [mfcc_all.name repmat(fileList(j),1,size(mfcc,2))];
        end
        num_mfcc = size(mfcc_all.mfcc,2);
        if strcmp('gmeans',p.clust_meth)%gmeans as presented by Greg Hamerly
            if isempty(p.num_clusters)%automatic stopping
                centres = gmeans(mfcc_all.mfcc');
            else
                centres = NM4M_KMeans(mfcc_all.mfcc',p.num_clusters);
            end
            for j=1:size(centres,1)
                vd = mfcc_all.mfcc' - repmat(centres(j,:),size(mfcc_all.mfcc',1),1);
                cet(:,j) = sum(abs(vd).^2, 2);
            end
            [a, pclass]=min(cet');
        elseif strcmp('kmeans',p.clust_meth)%standard kmeans, using the netlab package
            options = zeros(14,1);
            options(5) = 1;
            options(14) = 5;
            options(1) = 1;
            options(3) = 10e-06;
            centres = zeros(p.num_clusters,size(mfcc_all.mfcc,1));
            for j = 1:10%do 10 runs and take the best finally 
                [centres_(j,:,:),options,pclass_(j,:,:),errlog]=kmeans(centres,mfcc_all.mfcc',options);
                distance(j) = options(8);
            end
            [val,best] = min(distance);
            centres = reshape(centres_(best,:,:),p.num_clusters,size(mfcc_all.mfcc,1));
            options(5) = 0;
            options(14) = 100;
            [centres,options,pclass,errlog]=kmeans(centres,mfcc_all.mfcc',options);
            [indRow,indCol] = find(pclass ==1);
            [sorted,indx] = sort(indRow);
            pclass = indCol(indx);
        else
            fprintf('\nNo clustering, just writing the data structure\n');
            pclass = zeros(1,size(mfcc_all.mfcc,2));
            centres = zeros(size(mfcc_all.mfcc,1),1);
            p.clust_meth = 'noclust';
        end
        mfcc_all.cluster = pclass;
        centres = centres';
        save(fullfile(ClassName{i}, ['Clusters_' p.clust_meth '_' num2str(size(centres,1)) '_' num2str(p.num_ceps_coeffs) '_' ...
            num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']),'mfcc_all','centres');
    end
end