function [unitSequence,source,data,D,p] = computeViterbiSequence(Cl,AllMFCC)

p.clust_meth = 'LBG';
p.winlength = 0.032;
p.overlap = 0.75;
p.num_clusters = 256;
p.num_ceps_coeffs = 20;
p.nrg = 0;
p.use_deltas = 0;
  
p = CC4M_ParamInit(p);
display('Loading source and y''...')

order_mfcc = 20;

source = wavread('d:\programmation\matlab\enterface06\wave\enterface06_us_td_arctic\validation\wav\arctic_a0005.wav');
f = fopen('d:\programmation\matlab\enterface06\Yannis\MF_GMM\validation\arctic_a0005_transf.mfcc');%_transf.mcc
y_prime = fread(f,'float');
fclose(f);
y_prime=reshape(y_prime,order_mfcc,length(y_prime)/order_mfcc);

%for Aligned MFCC
% source = wavread('d:\programmation\matlab\enterface06\wave\cmu_us_awb_arctic\validation\wav\arctic_a0025.wav');
% load ./Aligned/0025.mat
% y_prime = AlignedMFCC;

display('Loading list of files...')
load(fullfile('d:\programmation\matlab\enterface06\cluster','List_of_files.mat'));
% sfxfiles = readsfxfiles('d:\programmation\matlab\enterface06\andreas\lst.devel_all');
% for k=1:size(sfxfiles,1)
%     D(k).name = strcat(sfxfiles(k),'.wav');
% end

if nargin<1
    display('Loading cluster information...')
    [Cl,AllMFCC] = createStructures('d:\programmation\matlab\enterface06\cluster',p);
end

display('Computing Viterbi...')
unitSequence = mexUnitSelection(y_prime,Cl,AllMFCC,ones(order_mfcc,1),100);

display('Computing data...')
nUnits = length(unitSequence);
data = zeros(2,nUnits);

% in case cluster is on original data
for k=1:nUnits
    data(1,k) = (AllMFCC{unitSequence(k)}.index-1)*p.winlength*1000*(1-p.overlap) + p.winlength*1000/2;
    data(2,k) = AllMFCC{unitSequence(k)}.name;
end
% in case cluster is on aligned data
% time_data = read_time_data('d:\programmation\matlab\enterface06\cluster\devel_target_awb.time.data');
% data(1,:) = time_data(1,unitSequence);
% data(2,:) = time_data(2,unitSequence);

% load(fullfile('d:\programmation\matlab\enterface06\Andreas\','sequence_256_4.mat'));
% sequence_4 = sequence;
% load(fullfile('d:\programmation\matlab\enterface06\Andreas\','sequence_256_8.mat'));
% sequence_8 = sequence;

% out0005_4 = mexUnitSelection(sequence_4{1}.dat,Cl,AllMFCC,ones(20,1),100);
% out0010_4 = mexUnitSelection(sequence_4{2}.dat,Cl,AllMFCC,ones(20,1),100);
% out0015_4 = mexUnitSelection(sequence_4{3}.dat,Cl,AllMFCC,ones(20,1),100);
% out0020_4 = mexUnitSelection(sequence_4{4}.dat,Cl,AllMFCC,ones(20,1),100);
% out0025_4 = mexUnitSelection(sequence_4{5}.dat,Cl,AllMFCC,ones(20,1),100);
% out0005_8 = mexUnitSelection(sequence_8{1}.dat,Cl,AllMFCC,ones(20,1),100);
% out0010_8 = mexUnitSelection(sequence_8{2}.dat,Cl,AllMFCC,ones(20,1),100);
% out0015_8 = mexUnitSelection(sequence_8{3}.dat,Cl,AllMFCC,ones(20,1),100);
% out0020_8 = mexUnitSelection(sequence_8{4}.dat,Cl,AllMFCC,ones(20,1),100);
% out0025_8 = mexUnitSelection(sequence_8{5}.dat,Cl,AllMFCC,ones(20,1),100);

% data0005_4 = unitSequence2data(out0005_4);
% data0010_4 = unitSequence2data(out0010_4);
% data0015_4 = unitSequence2data(out0015_4);
% data0020_4 = unitSequence2data(out0020_4);
% data0025_4 = unitSequence2data(out0025_4);
% data0005_8 = unitSequence2data(out0005_8);
% data0010_8 = unitSequence2data(out0010_8);
% data0015_8 = unitSequence2data(out0015_8);
% data0020_8 = unitSequence2data(out0020_8);
% data0025_8 = unitSequence2data(out0025_8);

% save data_0005_4_V100_td2awb.mat data0005_4
% save data_0010_4_V100_td2awb.mat data0010_4
% save data_0015_4_V100_td2awb.mat data0015_4
% save data_0020_4_V100_td2awb.mat data0020_4
% save data_0025_4_V100_td2awb.mat data0025_4
% save data_0005_256_8_V100_td2awb.mat data0005_8
% save data_0010_256_8_V100_td2awb.mat data0010_8
% save data_0015_256_8_V100_td2awb.mat data0015_8
% save data_0020_256_8_V100_td2awb.mat data0020_8
% save data_0025_256_8_V100_td2awb.mat data0025_8