function [Cluster,AllMFCC] = createStructures(DIR)

p.clust_meth = 'LBG';
p.num_clusters = 256;
p.num_ceps_coeffs = 20;
p.nrg = 0;
p.use_deltas = 0;
  
p = CC4M_ParamInit(p);
  
% centres & mfcc_all
load(fullfile(DIR,['Clusters_' p.clust_meth '_' num2str(p.num_clusters) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']));

[numOfMfcc,numOfClusters] = size(centres);

% cells
for k=1:numOfClusters
    Cluster{k}.center = centres(:,k);
    index = find(mfcc_all.cluster==k);
    Cluster{k}.frames = index;
    Cluster{k}.size = length(index);
end

[numOfMfcc,numOfFrames] = size(mfcc_all.mfcc);

count = 0;
name = mfcc_all.name(1);
for k=1:numOfFrames
    AllMFCC{k}.mfcc = mfcc_all.mfcc(:,k);   
    AllMFCC{k}.name = mfcc_all.name(k);
    if name == mfcc_all.name(k)
        count = count + 1;
        AllMFCC{k}.index = count;        
    else
        name = mfcc_all.name(k);
        count = 1;
        AllMFCC{k}.index = count;
    end
end
% structures
% for k=1:numOfClusters
%     Cluster(k).center = centres(:,k);
%     index = find(mfcc_all.cluster==k);
%     Cluster(k).frames = index;
%     Cluster(k).size = length(index);
% end
% 
% [numOfMfcc,numOfFrames] = size(mfcc_all.mfcc);
% 
% for k=1:numOfFrames
%     AllMFCC(k).mfcc = mfcc_all.mfcc(:,k);
%     AllMFCC(k).index = mfcc_all.index(k);
%     AllMFCC(k).name = char(mfcc_all.name(k));
% end


