 /*********************************************************************\
 * TODO LIST                                                           *
 *	1. Any idea for the "when do we make backtracking" question        *
 *  2. Rewrite a lot of things (clean the code) and use classes        *
 *     or structures to store prhs[1] (CLUSTER) and prhs[2] (MFCC_ALL) *
 *  3. implement direct management of .mat file (see mathworks)        *
 *  4. change N-BEST to a more efficient one ?                         *
 *     ("thresholded" N-BEST instead of N-fixed-one)                   *
 *                                                                     *
 \*********************************************************************/

#include "mex.h"
#include <iostream>
#include <cmath>
#include <ctime>
#include <cstring>

using namespace std;

bool noWEIGHTS;
int numberOfMFCC;
int	numberOfFrames;
int	numberOfClusters;
int numberOfData;
long int count = 0;

// VITERBI ALGORITHM FUNCTIONS
double *initialization(int clusterSize, double *sourceMFCC, double **targetMFCC, int *clusterFrames, double *weights);
double *induction(int *stateSequenceArgument, double *bestAccumulatedDistance, double *sourceMFCC,double **targetMFCC,double *weights,
				  double *targetName, double *targetIndex, int *clusterFrames,int *prevClusterFrames, int clusterSize,int prev_clusterSize);
double *nbestInduction(int NBEST, int *stateSequenceArgument, double *bestAccumulatedDistance,
					   double *targetDistance, double **targetMFCC, double *weights,
					   double *targetName, double *targetIndex, int *clusterFrame, int *prevClusterFrames);
int termination(double *bestAccumulatedDistance, int clusterSize);

//for concatenation and target costs
int *findLabels(mxArray *mfcc,mxArray *centers,mxArray *weights);
int *findLabels(double **mfcc, double **clusterCenters, double *weights);
double weightedEuclideanDistance(double *features1, double * features2, double *weights);
//NBEST algorithm
int *nbestArguments(int NBEST, double *in,int sizeIn);
double *nbestSelection(int NBEST, double *in, int *nbestArguments);
int *nbestSelection(int NBEST, int *in, int *nbestArguments);

void mexFunction(int nlhs,mxArray *plhs[],int nrhs, mxArray *prhs[]){
	/*convention :
		prhs[0] = mfcc of the y_prime (let's call this the source)
		prhs[1] = the structure with the clusters of the database (target)
		prhs[2] = the structure with name-mfcc-index of the database (target)
		prhs[3] = the weights of the distance (for weighted euclidean distance)
		prhs[4] = the number of states to select for the n-best (optional)
	*/
	noWEIGHTS = true;
	int i,j;
	int NBEST = 0;
	count = 0;
	
if (nrhs==0){
	// HELP FILE
	mexPrintf("[stateSequence] = mexUnitSelection(source,cluster,target,weights,NBEST);\n\n");
	mexPrintf("\t source is a 2D matrix containing the features (e.g. MFCC) of the source (y_prime)\n");
	mexPrintf("\t\t dimension : [numberOfFeatures x numberOfFrames]\n\n");

	mexPrintf("\t cluster is an array of cells containing information about the clustering of the target database :\n");
	mexPrintf("\t\t dimension : [1 x numberOfClusters]\n");
	mexPrintf("\t\t each cell represents one cluster and contains 3 fields :\n");
	mexPrintf("\t\t\t center : 1D matrix of double [numberOfMFCC x 1] containing the features of \n\t\t\t\t the center of the cluster\n");
    mexPrintf("\t\t\t frames : 1D matrix of int [numberOfFramesInTheCluster] \n");
	mexPrintf("\t\t\t\t containing the index of the database (awb) frames which are in this cluster.\n");
    mexPrintf("\t\t\t size : int [1 x 1] containing the number of database frames which are in this cluster.\n\n");

    mexPrintf("\t target is an array of cells containing information about the features of the target database :\n");
	mexPrintf("\t\t dimension : [1 x numberOfFramesInDatabase]\n");
	mexPrintf("\t\t each cell represents one frame and contains 3 fields :\n");
    mexPrintf("\t\t\t mfcc : 1D matrix of double [numberOfMFCC x 1] containing the features (mfcc) \n\t\t\t\t of each frame of the database.\n");
    mexPrintf("\t\t\t name : a string containing the name of the file from which the frame comes from \n\t\t\t\t (e.g. : 'a0082.wav')\n");
    mexPrintf("\t\t\t index : an integer value [1 x 1] containing the index of that frame in that file \n\t\t\t\t (e.g. : 123, meaning the 123rd frame of 'a0082.wav')\n\n");

	mexPrintf("\t weights (optional) : a 1D matrix of double value containing the weights for the weighted euclidian distance\n\n");

	mexPrintf("\t NBEST (optional) : an integer value. It's the number of states to select for the n-best\n\n");

	mexPrintf("\t out : a 1D matrix [numberOfFrames x 1]\n");
    mexPrintf("\t\t It contains the index of the frames of the database selected by the Viterbi algorithm\n");
    mexPrintf("\t\t (e.g. : 1234 means the 1234th frame of the database \n\t\t\t --> the 1234th element of the target structure\n");
    mexPrintf("\t\t --> you can get the frame using target.name(1234) and target.index(1234)\n\n");
}
else if(nrhs > 2 ){
	numberOfMFCC = mxGetM(prhs[0]);
	numberOfFrames = mxGetN(prhs[0]);
	numberOfClusters = mxGetN(prhs[1]);
	numberOfData = mxGetN(prhs[2]);

	mexPrintf("number of features (mfcc) : %d \n",numberOfMFCC);
	mexPrintf("number of frames (source) : %d \n",numberOfFrames);
	mexPrintf("number of clusters (data) : %d \n",numberOfClusters);
	mexPrintf("number of frames (target) : %d\n",numberOfData);

// GET THE MFCC OF THE SOURCE
	double *tmpSourceMFCC = mxGetPr(prhs[0]);
	/**///if I could avoid this that would be great (time and memory expensive)
	double **sourceMFCC = new double*[numberOfFrames];
	for(i=0;i<numberOfFrames;i++){
		sourceMFCC[i] = new double[numberOfMFCC];
		for(j=0;j<numberOfMFCC;j++)
			sourceMFCC[i][j] = tmpSourceMFCC[i*numberOfMFCC + j];
	}/**/
// GET THE CLUSTERS INFORMATION (CENTERS, NUMBER OF FRAMES, SIZE OF CLUSTERS

	double **clusterCenters = new double*[numberOfClusters];
	int **clusterFrames = new int*[numberOfClusters];
	int *clusterSize = new int[numberOfClusters];
	for(i=0;i<numberOfClusters;i++){
		mxArray *mxaClusterCenter = mxGetField(mxGetCell(prhs[1],i),0,"center");//mxGetField(prhs[1],i,"center");//
		mxArray *mxaClusterFrames = mxGetField(mxGetCell(prhs[1],i),0,"frames");//mxGetField(prhs[1],i,"frames");//
		mxArray *mxaClusterSize = mxGetField(mxGetCell(prhs[1],i),0,"size");//mxGetField(prhs[1],i,"size");//

		clusterCenters[i] = mxGetPr(mxaClusterCenter);
		double *tmpClusterFrames = mxGetPr(mxaClusterFrames);
		double tmpClusterSize = mxGetScalar(mxaClusterSize);
		//this is necessary as clusterSize is used as an index for array
		clusterSize[i] = (int) tmpClusterSize;
		clusterFrames[i] = new int[clusterSize[i]];
		for(j=0;j<clusterSize[i];j++)
			clusterFrames[i][j] = (int) (tmpClusterFrames[j]-1); //-1 because Frames indexes come from matlab (thus starting at 1)
	}


// GET THE DATABASE INFORMATION (MFCC, FILENAME, INDEX, CLUSTER(though cluster isn't needed anymore thanks to cluster struct above))
	
	double **targetMFCC = new double*[numberOfData];
	//the two next variables are actually integer, but they can be kept and used as double
	//because they are only used as a mean to detect neighbour frames --> it doesn't matter.
	//(e.g. see the concatenation distance in induction and nbestInduction functions)
	double *targetName = new double[numberOfData];
	double *targetIndex = new double[numberOfData];
	
	for(i=0;i<numberOfData;i++){
		mxArray *mxaTargetName = mxGetField(mxGetCell(prhs[2],i),0,"name");
		mxArray *mxaTargetMFCC = mxGetField(mxGetCell(prhs[2],i),0,"mfcc");
		mxArray *mxaTargetIndex = mxGetField(mxGetCell(prhs[2],i),0,"index");

		targetMFCC[i] = mxGetPr(mxaTargetMFCC);
		targetName[i] = mxGetScalar(mxaTargetName);
		targetIndex[i] = mxGetScalar(mxaTargetIndex);
	}

// GET THE WEIGHTS OF THE EUCLIDIAN DISTANCE

	double *weights;
	//if no weights --> default weights
	if(nrhs<4){
		weights = new double[numberOfMFCC];
		for(i=0;i<numberOfMFCC;i++)
			weights[i] = 1;
		noWEIGHTS = true;
	}
	else{
		if( (mxGetM(prhs[3])==numberOfMFCC && mxGetN(prhs[3])==1) 
			|| (mxGetM(prhs[3])==1 && mxGetN(prhs[3])==numberOfMFCC) ){
			weights = mxGetPr(prhs[3]);
			for(i=0;i<numberOfMFCC;i++){
				if(weights[i] != 1)
					noWEIGHTS = false;
			}
		}
		else{
			weights = new double[numberOfMFCC];
			for(i=0;i<numberOfMFCC;i++)
				weights[i] = 1;
			noWEIGHTS = true;
		}
	}

// GET THE NBEST
	bool doNBEST = false;
	if (nrhs<5){		
		doNBEST = false;
	}
	else{
		double *tmpNBEST = mxGetPr(prhs[4]);
		if(tmpNBEST > 0){
			NBEST = (int) tmpNBEST[0];
			doNBEST = true;
		}
		delete[] tmpNBEST;
	}
	

//CREATE THE OUTPUT VECTOR (the states sequence)
	plhs[0] = mxCreateDoubleMatrix(numberOfFrames,1,mxREAL);
	double *output;
	output = mxGetPr(plhs[0]);

// Viterbi VARIABLES
	int frameIndex;
	int *stateSequence;
	int **stateSequenceArgument;
	int *nbestArg;
	int **nbestClusterFrames;
	double *bestAccumulatedDistance;

// CLUSTER SELECTION - both findLabels overloaded funtions work and give the same result (this was just a test)
	//int *labels = findLabels(sourceMFCC,clusterCenters,weights);
	int *labels = findLabels(prhs[0],prhs[1],prhs[3]);
	//for(i=0;i<numberOfFrames;i++)
	//	mexPrintf("<frame %d : cluster %d>\n",i,labels[i]);

//CHECK WHETHER THERE IS NO CLUSTER WITH A SIZE SMALLER THAN THE NBEST LIMIT.
//IF THERE IS ONE, NBEST IS REDUCED TO THAT SMALLER SIZE.
//THIS MIGHT NOT BE A GOOD IDEA - COULD IMPLEMENT DYNAMIC SIZE (IF NBEST < CLUSTERSIZE : SIZE = NBEST ; OTHERWIZE : SIZE = CLUSTERSIZE)
	if(doNBEST){
		for(i=0;i<numberOfFrames;i++){
			if(NBEST > clusterSize[labels[i]])
				NBEST = clusterSize[labels[i]];
		}
		mexPrintf("N-best is activated : %d states will be selected for each step of Viterbi\n",NBEST);
	}
	
// DYNAMIC MEMORY ALLOCATION

	stateSequence = new int[numberOfFrames];
	stateSequenceArgument = new int*[numberOfFrames-1];

// ALGORITHM
	clock_t startTime = clock();
	bestAccumulatedDistance = initialization(clusterSize[labels[0]],sourceMFCC[0],targetMFCC,clusterFrames[labels[0]],weights);
	if(doNBEST){
		nbestClusterFrames = new int*[numberOfFrames];
		nbestArg = nbestArguments(NBEST,bestAccumulatedDistance,clusterSize[labels[0]]);
		bestAccumulatedDistance = nbestSelection(NBEST,bestAccumulatedDistance,nbestArg);
		nbestClusterFrames[0] = nbestSelection(NBEST,clusterFrames[labels[0]],nbestArg);
		for(frameIndex=1;frameIndex<numberOfFrames;frameIndex++){
			stateSequenceArgument[frameIndex-1] = new int[NBEST];
			double *targetDistance = initialization(clusterSize[labels[frameIndex]],sourceMFCC[frameIndex],
													targetMFCC,clusterFrames[labels[frameIndex]],weights);
			nbestArg = nbestArguments(NBEST,targetDistance,clusterSize[labels[frameIndex]]);
			double *nbestTargetDistance = nbestSelection(NBEST,targetDistance,nbestArg);
			nbestClusterFrames[frameIndex] = nbestSelection(NBEST,clusterFrames[labels[frameIndex]],nbestArg);

			bestAccumulatedDistance = nbestInduction(NBEST,stateSequenceArgument[frameIndex-1],bestAccumulatedDistance,
												nbestTargetDistance,targetMFCC,weights,targetName,targetIndex,
												nbestClusterFrames[frameIndex],nbestClusterFrames[frameIndex-1]);
		}
	}
	else{	
		for(frameIndex=1;frameIndex<numberOfFrames;frameIndex++){
			stateSequenceArgument[frameIndex-1] = new int[clusterSize[labels[frameIndex]]];
			bestAccumulatedDistance = induction(stateSequenceArgument[frameIndex-1],bestAccumulatedDistance,
												sourceMFCC[frameIndex],targetMFCC,weights,targetName,targetIndex,
												clusterFrames[labels[frameIndex]],clusterFrames[labels[frameIndex-1]],
												clusterSize[labels[frameIndex]],clusterSize[labels[frameIndex-1]]);
		}
	}


// BACKTRACKING
	if(doNBEST){
		stateSequence[numberOfFrames-1] = termination(bestAccumulatedDistance,NBEST);
		output[numberOfFrames-1] = (double) nbestClusterFrames[numberOfFrames-1][stateSequence[numberOfFrames-1]] +1;//because Matlab arrays start at 1, not 0 
		delete[] bestAccumulatedDistance;
		for(frameIndex=numberOfFrames-2;frameIndex>=0;frameIndex--){
			stateSequence[frameIndex] = stateSequenceArgument[frameIndex][stateSequence[frameIndex+1]];
			output[frameIndex] = (double) nbestClusterFrames[frameIndex][stateSequence[frameIndex]] + 1;//because Matlab arrays start at 1, not 0 
			delete[] stateSequenceArgument[frameIndex];
			delete[] nbestClusterFrames[frameIndex];
		}
		delete[] nbestArg;
		delete[] nbestClusterFrames;
	}
	else{
		stateSequence[numberOfFrames-1] = termination(bestAccumulatedDistance,clusterSize[labels[numberOfFrames-1]]);
		output[numberOfFrames-1] = (double) clusterFrames[labels[numberOfFrames-1]][stateSequence[numberOfFrames-1]] + 1;//because Matlab arrays start at 1, not 0 
		delete[] bestAccumulatedDistance;
		for(frameIndex=numberOfFrames-2;frameIndex>=0;frameIndex--){
			stateSequence[frameIndex] = stateSequenceArgument[frameIndex][stateSequence[frameIndex+1]];
			output[frameIndex] = (double) clusterFrames[labels[frameIndex]][stateSequence[frameIndex]] + 1;//because Matlab arrays start at 1, not 0 
			delete[] stateSequenceArgument[frameIndex];
		}
	}
	clock_t endTime = clock();

	mexPrintf("%g seconds for a length of %g seconds\n",((double)(endTime-startTime)/CLOCKS_PER_SEC), numberOfFrames*0.008);
	mexPrintf("real-time ratio : %g \n",((double)(endTime-startTime)/CLOCKS_PER_SEC)/(numberOfFrames*0.008));

	mexPrintf("%d\n",count);
	
	delete[] stateSequenceArgument;
	delete[] stateSequence;	
}//this "}" close the help menu
}

//INITIALIZATION
double *initialization(int clusterSize, double *sourceMFCC, double **targetMFCC, int *clusterFrames, double *weights){
	double *bestAccumulatedDistance = new double[clusterSize];
	for(int i=0;i<clusterSize;i++){	
		bestAccumulatedDistance[i]=weightedEuclideanDistance(sourceMFCC,targetMFCC[clusterFrames[i]],weights);
	}		
	return bestAccumulatedDistance;
}

//INDUCTION
double *induction(int *stateSequenceArgument, double *bestAccumulatedDistance, double *sourceMFCC,double **targetMFCC, double *weights,
				  double *targetName, double *targetIndex, int *clusterFrames,int *prevClusterFrames, int clusterSize,int prev_clusterSize){
	double distance; 
	double newDistance;
	double *newBestAccumulatedDistance = new double[clusterSize];
	count++;//for debugging purpose
	for(int j=0;j<clusterSize;j++){
		
		if( (targetIndex[clusterFrames[j]]-1 == targetIndex[prevClusterFrames[0]]) 
			&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[0]]) ){
				distance=bestAccumulatedDistance[0];
		}
		else if( (targetIndex[clusterFrames[j]] == targetIndex[prevClusterFrames[0]]) 
			&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[0]]) ){
				distance=10000000;//avoid using the same frame again and again
		}
		else{
			distance=bestAccumulatedDistance[0] + weightedEuclideanDistance(targetMFCC[prevClusterFrames[0]],targetMFCC[clusterFrames[j]],weights);
		}

		stateSequenceArgument[j]=0;
		
		for(int i=1;i<prev_clusterSize;i++){
			if( (targetIndex[clusterFrames[j]]-1 == targetIndex[prevClusterFrames[i]]) 
				&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[i]]) ){
					newDistance=bestAccumulatedDistance[i];
			}
			else if( (targetIndex[clusterFrames[j]] == targetIndex[prevClusterFrames[i]]) 
			&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[i]]) ){
				newDistance=10000000;//avoid using the same frame again and again
			}
			else{
				newDistance=bestAccumulatedDistance[i]+weightedEuclideanDistance(targetMFCC[prevClusterFrames[i]],targetMFCC[clusterFrames[j]],weights);
			}

			if(newDistance<distance){
				distance=newDistance;
				stateSequenceArgument[j]=i;
			}				
		}
		newBestAccumulatedDistance[j]=distance+weightedEuclideanDistance(sourceMFCC,targetMFCC[clusterFrames[j]],weights);
	}
	return newBestAccumulatedDistance;
}

//INDUCTION with N-BEST
double *nbestInduction(int NBEST, int *stateSequenceArgument, double *bestAccumulatedDistance, double *targetDistance, double **targetMFCC, double *weights,
					   double *targetName, double *targetIndex, int *clusterFrames, int *prevClusterFrames){
	double distance; 
	double newDistance;
	double *newBestAccumulatedDistance = new double[NBEST];
	count++;//for debugging purpose
	for(int j=0;j<NBEST;j++){	
		
		if( (targetIndex[clusterFrames[j]]-1 == targetIndex[prevClusterFrames[0]]) 
			&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[0]]) ){
			distance=bestAccumulatedDistance[0];			
		}
		else if( (targetIndex[clusterFrames[j]] == targetIndex[prevClusterFrames[0]]) 
			&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[0]]) ){
				distance=10000000;//avoid using the same frame again and again
		}
		else{
			distance=bestAccumulatedDistance[0] + weightedEuclideanDistance(targetMFCC[prevClusterFrames[0]],targetMFCC[clusterFrames[j]],weights);
		}

		stateSequenceArgument[j]=0;
		
		for(int i=1;i<NBEST;i++){
			if( (targetIndex[clusterFrames[j]]-1==targetIndex[prevClusterFrames[i]]) 
				&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[i]]) ){
					newDistance=bestAccumulatedDistance[i];
			}
			else if( (targetIndex[clusterFrames[j]] == targetIndex[prevClusterFrames[i]]) 
			&& (targetName[clusterFrames[j]] == targetName[prevClusterFrames[i]]) ){
				newDistance=10000000;//avoid using the same frame again and again
			}
			else{
				newDistance=bestAccumulatedDistance[i]+weightedEuclideanDistance(targetMFCC[prevClusterFrames[i]],targetMFCC[clusterFrames[j]],weights);
			}

			if(newDistance<distance){
				distance=newDistance;
				stateSequenceArgument[j]=i;
			}				
		}
		newBestAccumulatedDistance[j]=distance+targetDistance[j];
	}
	return newBestAccumulatedDistance;
}

//TERMINATION
int termination(double *bestAccumulatedDistance, int clusterSize){
	int argBestAccumulatedDistance = 0;
	double minimumValue = bestAccumulatedDistance[0];
	for(int i=1;i<clusterSize;i++){
		if(bestAccumulatedDistance[i]<minimumValue){
			minimumValue=bestAccumulatedDistance[i];
			argBestAccumulatedDistance = i;
		}			
	}
	return argBestAccumulatedDistance;
}

//FIND THE CLUSTER WITH THE CLOSEST CENTROID
int *findLabels(double **mfcc, double **clusterCenters, double *weights){
	int *labels = new int[numberOfFrames];
	int i,j;
	double distance,new_distance;

	for(i=0;i<numberOfFrames;i++){
		distance = weightedEuclideanDistance(clusterCenters[0],mfcc[i],weights);
		labels[i] = 0;
		for(j=1;j<numberOfClusters;j++){
			new_distance = weightedEuclideanDistance(clusterCenters[j],mfcc[i],weights);
			if(new_distance < distance){
				distance = new_distance;
				labels[i] = j;
			}
		}
	}
	return labels;
}

//FIND THE CLUSTER WITH THE CLOSEST CENTROID - mxArray version (for testing purpose but it works properly)
int *findLabels(mxArray *mxaMfcc,mxArray *mxaCenters,mxArray *mxaWeights){
	int *labels = new int[numberOfFrames];
	int i,j;
	double distance,new_distance;
	mxArray *mxaClusterCenter;
	double *mfcc = mxGetPr(mxaMfcc);
	double *tmpMfcc = new double[numberOfMFCC];
	double *clusterCenter = new double[numberOfMFCC];
	double *weights = mxGetPr(mxaWeights);

	for(i=0;i<numberOfFrames;i++){
		mxaClusterCenter = mxGetField(mxGetCell(mxaCenters,0),0,"center");
		clusterCenter = mxGetPr(mxaClusterCenter);
		for(j=0;j<numberOfMFCC;j++)
			tmpMfcc[j] = mfcc[i*numberOfMFCC + j];
		
		distance = weightedEuclideanDistance(clusterCenter,tmpMfcc,weights);		
		labels[i] = 0;
		for(j=1;j<numberOfClusters;j++){
			mxaClusterCenter = mxGetField(mxGetCell(mxaCenters,j),0,"center");
			clusterCenter = mxGetPr(mxaClusterCenter);
			new_distance = weightedEuclideanDistance(clusterCenter,tmpMfcc,weights);
			if(new_distance < distance){
				distance = new_distance;
				labels[i] = j;
			}
		}
	}
	return labels;
}

//THE WEIGHTED EUCLIDEAN DISTANCE
double weightedEuclideanDistance(double *features1, double * features2, double *weights){
	int i;
	double weDistance = 0;
	if(noWEIGHTS){
		for(i=0;i<numberOfMFCC;i++)
			weDistance += pow((features1[i] - features2[i]),2);
	}
	else{
		for(i=0;i<numberOfMFCC;i++)
			weDistance += pow((features1[i] - features2[i])*weights[i],2);	
	}
	return sqrt(weDistance);
}

//THE ARGUMENTS OF THE NBEST IN THE VECTOR in[]
int *nbestArguments(int NBEST, double *in,int sizeIn){
	int i,j;
	int *argNBEST;
	double min,max;
	double *tmp = new double[sizeIn];

	for(i=0;i<sizeIn;i++)
		tmp[i] = in[i];

	argNBEST = new int[NBEST];

	//find the max and the min of input
	min = tmp[0];
	max = tmp[0];
	argNBEST[0] = 0;
	for(i=1;i<sizeIn;i++){
		if(tmp[i]<min){
			min = tmp[i];
			argNBEST[0] = i;
		}
		else if(tmp[i]>max){
			max = tmp[i];
		}
	}
	//replace the min by the max
	tmp[argNBEST[0]] = max;

	//find the next NBEST-1 minima
	for(i=1;i<NBEST;i++){
		min = tmp[0];
		argNBEST[i] = 0;
		for(j=1;j<sizeIn;j++){
			if(tmp[j]<min){
				min = tmp[j];
				argNBEST[i] = j;
			}
		}
		tmp[argNBEST[i]] = max;
	}

	delete[] tmp;
	return argNBEST;
}

//SELECT THE NBEST IN VECTOR double in[]
double *nbestSelection(int NBEST, double *in, int *nbestArg){
	int i;
	double *out = new double[NBEST];
	
	for(i=0;i<NBEST;i++){
		out[i] = in[nbestArg[i]];
	}

	return out;
}

//SELECT THE NBEST IN VECTOR int in[]
int *nbestSelection(int NBEST, int *in, int *nbestArg){
	int i;
	int *out = new int[NBEST];
	
	for(i=0;i<NBEST;i++){
		out[i] = in[nbestArg[i]];
	}

	return out;
}