function YPrimes = CVQGetYPrimes(SourceCB,TargetCB,DIR,p)

%Find the most probable paths of target space codebook entries for a list of
%validation files using Viterbi considering the euclidean distances of the
%candidates for each frame.
%Two fields of the p-structure are used for the cvq: p.cvq_maps specifies
%the number of codebook elements to find for each source space clusters and
%p.num_clusters specifies the number of source space clusters
%You need the cvq code by Yannis Agiomyrgiannakis and the viterbiselect.m function modified
%from the ttsbox.
%Note that you have to adjust the file names and the parameter extensions
%in the code....
%
%input:
% SourceCB  : X space clustering centroids (dim x p.num_clusters)
% TargetCB  : Y|X conditional clustering (dim x
% (p.num_clusters*p.cvq_maps))
% DIR       : where are the MFCC
% p         : parameter structure
%output:
%     YPrimes{File}.dat: matrix of D*N_{file} MFCC's, these are the
%     Y'
%     YPrimes{File}.file: name of the file
%     YPrimes{File}.parms: parameter structure used
%...there is redundancy, it is the first version ....
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project

p = CC4M_ParamInit(p);%set parameters to standard values if not set 

NamesFile='/home/hannover/Documents/enterface/arctic/lst.validation';%list of validation files
BaseDir= DIR;

MatExt = ['_' num2str(p.winlength) '_' num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' ...
    num2str(p.nrg) '_' num2str(p.use_deltas) '.mat'] ;%extension of the mfcc file written by CC4M_CompFeat
OutExt = strcat('__syn_',MatExt);

SenName=textread(NamesFile,'%s');
NumFile=length(SenName);

all_log_mean_snr=zeros(NumFile,1);
all_mean_snr=zeros(NumFile,1);
for File=1:NumFile %get the YPrimes for all the files   
    wname=strcat(BaseDir, char(SenName(File)), MatExt);
    fprintf('File %d of %d: %s\n',File, NumFile, wname);    
    load(wname);
    NFRAMES=size(mfcc,2);    
    syn_frames = zeros(size(mfcc));
    syn_idx = zeros(NFRAMES,1);
    s_energy = zeros(NFRAMES,1);
    n_energy = zeros(NFRAMES,1);
    Ycands = [];
    %get the closests cluster in X space for each frame and get the codebook for that 
    for k=1:NFRAMES,
        if rem(k,10) == 0,
            fprintf('Frame %d of %d\r',k,NFRAMES);
        end       
        b=mfcc(:,k);
        s_energy(k) = sqrt(mean(b.^2));       
        % Euclidean distance
        [n_energy(k),clust]=min(sqrt(mean((SourceCB-b(:,ones(1,size(SourceCB,2)))).^2)));%get the cluster in X space for a sample
        Ycands = [Ycands TargetCB( : , (clust-1)*p.cvq_maps+[1:p.cvq_maps])]; %get the target space codebook entries for that
    end
    %do the viterbi to find minimum weight path
    indices = viterbiselect(p,Ycands); 
    %create the output cell array
    YPrimes{File}.dat = Ycands(:,indices);
    YPrimes{File}.file = char(SenName(File));
    YPrimes{File}.parms = p;
    %next lines just to print measures on how gut the target space
    %clustering fits the data
    syn_snr = s_energy ./ n_energy;
    mean_snr = mean(syn_snr);   
    log_syn_snr = 20*log10(syn_snr);
    log_mean_snr = mean(log_syn_snr);    
    oname=strcat(BaseDir, char(SenName(File)), OutExt);    
    fprintf('SNR: %f\tlogSNR: %f\n', mean_snr, log_mean_snr);
    all_log_mean_snr(File)=log_mean_snr;
    all_mean_snr(File)=mean_snr;
end
fprintf('\n\n*** GLOBAL:\n\tSNR: %f\tlogSNR: %f\n', mean(all_mean_snr), mean(all_log_mean_snr));
fprintf('\n\n')