function [SourceCB,TargetCB]  = CVQTrainMap(DIR,p)

%train a conditional vector quantization for MFCC's of aligned data stored
%in DIR. If not found also a target space clustering is computed
%Two fields of the p-structure are used for the cvq: p.cvq_maps specifies
%the number of codebook elements to find for each source space clusters and
%p.num_clusters specifies the number of source space clusters
%You need the cvq code by Yannis Agiomyrgiannakis
%inputs:
% DIR       : where is the aligned data
% p         : parameter structure
%outputs:
% SourceCB  : X space clustering centroids (dim x p.num_clusters)
% TargetCB  : Y|X conditional clustering (dim x
% (p.num_clusters*p.cvq_maps))
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project


p = CC4M_ParamInit(p);%set parameters to standard values if not set 

%read aligned data...
%...from source
X =read_align_data(fullfile(DIR,'devel_source_td.aligned.mfcc'));


%...and from target
Y = read_align_data(fullfile(DIR,'devel_target_awb.aligned.mfcc'));


%do a LBG clustering of the source space
SourceCB = slbg_(X(:,1:round(size(X,2))), int32(p.num_clusters));

%get the target space codebook
TargetCB = cvq_train(X, Y , int32(p.cvq_maps), SourceCB);

%if there is no according file save a target space
%clustering to make work for the map from YPrime to the Y more easy
if (~exist(fullfile(DIR,['Clusters_' 'LBG' '_' num2str(p.num_clusters) '_' num2str(p.num_ceps_coeffs) '_' ...
        num2str(p.nrg) '_' num2str(p.use_deltas) '.mat'])))
    centres = slbg_(Y(:,1:round(size(Y,2))), int32(p.num_clusters));
    labels = findlabels(centres',Y');
    Ylocs = read_time_data(fullfile(DIR,'devel_target_awb.time.data'));
    mfcc_all.mfcc = Y;
    mfcc_all.index = Ylocs(1,:);
    mfcc_all.name = Ylocs(2,:);
    mfcc_all.cluster = labels;
    save( fullfile(DIR,['Clusters_' 'LBG' '_' num2str(size(centres,2)) '_' num2str(p.num_ceps_coeffs) '_' ...
        num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']),'mfcc_all','centres');
end