%    
% 	mY = cvq_train(X, Y, K, mX)
%
% 	Conditional Vector Quantization training, given a X-space partitioning with
% 	either hard of soft (via a GMM) association probabilities. Using the first four
% 	arguments are needed for hard association probabilities. Soft assoc. probs require
% 	the last 2 input arguments.
%
% 	Input Arguments:
% 	X:		[PxN] (input) the N P-dimensional X-space vectors
% 	Y:		[DxN] (input) the N D-dimensional Y-space vectors
% 	K:		[1x1] (input) the number of Y|X-space classes
% 	mX:		[PxM] (input) the X-space codebook (or the X-space gaussian
% 	centers)
% 	Output Arguments:
% 	mY:		[DxK*M] the Y|X-space codebook
%
%
%
%
%
% Jannis Agiomyrgiannakis and Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project
function	mY = cvq_train(X, Y, K, mX)
if nargin==4
	mY = cvq_train_(X, Y, int32(K), mX);	return;
end;
error('wrong number of input arguments');



