/* Jannis Agiomyrgiannakis and Andre Holzapfel */
/* Signal Processing Laboratory */
/* University of Crete, June 2006 */
/* Supervisor: Jannis Stylianou */
/* */
/* Enterface06, Multimodal Character Morphing Project */ 

/*#include "mex.h"*/
/*#include "math.h"*/
/*#include "matrix.h"*/

#include "cvq_lib.h"

#define MIN_IN_ARGNUM	4
#define MAX_IN_ARGNUM	6
#define MIN_OUT_ARGNUM	1
#define MAX_OUT_ARGNUM	1

/* #define INITIALIZE_INPUT_REQ_MATRICES */
/* #define INITIALIZE_INPUT_OPT_MATRICES */
/* #define INITIALIZE_OUTPUT_REQ_MATRICES */
/* #define INITIALIZE_OUTPUT_OPT_MATRICES */



void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
 /* setting up dimension declarations */
 int  P, N, D, M, K;
 /* setting up int declarations */
 int  *Kptr;
 /* setting up double declarations */
 double  *X, *Y, *mX, *alpha, *cX, *mY;
 const int *dnum;
 int i, dims[16];

 /* declare the optional I/O flags */
 int flag_alpha=0;
 int flag_cX=0;

 /* check the number of I/O arguments */
 if (nrhs < MIN_IN_ARGNUM || nrhs > MAX_IN_ARGNUM) mexErrMsgTxt("too many or too few input arguments.");
 if (nrhs>=MIN_IN_ARGNUM+1) flag_alpha=1; else flag_alpha=0;
 if (nrhs>=MIN_IN_ARGNUM+2) flag_cX=1; else flag_cX=0;
 if (nlhs < MIN_OUT_ARGNUM || nlhs > MAX_OUT_ARGNUM) mexErrMsgTxt("too many or too few output arguments.");
 if (flag_alpha!=flag_cX) mexErrMsgTxt("both `alpha` and `cX` should be given together.");

 /*
 * 	check the dimensions of input arguments, and set input pointers
 */
 /* X */
 if(mxGetNumberOfDimensions(prhs[0])!=2) mexErrMsgTxt("`X` must have 2 dimensions");
 if(mxGetClassID(prhs[0])!=mxDOUBLE_CLASS) mexErrMsgTxt("`X` must be stored in `mxDOUBLE_CLASS` format");
 dnum = mxGetDimensions(prhs[0]);
 P = dnum[0];
 N = dnum[1];
 X =  (double *)mxGetPr(prhs[0]);
 #ifdef INITIALIZE_INPUT_REQ_MATRICES
 	for (i=0;i<P*N;i++) X[i] = 0.000000e+00;
 #endif
 /* Y */
 if(mxGetNumberOfDimensions(prhs[1])!=2) mexErrMsgTxt("`Y` must have 2 dimensions");
 if(mxGetClassID(prhs[1])!=mxDOUBLE_CLASS) mexErrMsgTxt("`Y` must be stored in `mxDOUBLE_CLASS` format");
 dnum = mxGetDimensions(prhs[1]);
 D = dnum[0];
 if (dnum[1]!=N) mexErrMsgTxt("`Y` has incorrect size");
 Y =  (double *)mxGetPr(prhs[1]);
 #ifdef INITIALIZE_INPUT_REQ_MATRICES
 	for (i=0;i<D*N;i++) Y[i] = 0.000000e+00;
 #endif
 /* Kptr */
 if(mxGetNumberOfDimensions(prhs[2])!=2) mexErrMsgTxt("`Kptr` must have 2 dimensions");
 if(mxGetClassID(prhs[2])!=mxINT32_CLASS) mexErrMsgTxt("`Kptr` must be stored in `mxINT32_CLASS` format");
 dnum = mxGetDimensions(prhs[2]);
 if(dnum[0]!=1) mexErrMsgTxt("`Kptr` has incorrect size");
 if (dnum[1]!=1) mexErrMsgTxt("`Kptr` has incorrect size");
 Kptr =  (int *)mxGetPr(prhs[2]);
 K = *Kptr;
 /* mX */
 if(mxGetNumberOfDimensions(prhs[3])!=2) mexErrMsgTxt("`mX` must have 2 dimensions");
 if(mxGetClassID(prhs[3])!=mxDOUBLE_CLASS) mexErrMsgTxt("`mX` must be stored in `mxDOUBLE_CLASS` format");
 dnum = mxGetDimensions(prhs[3]);
 if (dnum[0]!=P) mexErrMsgTxt("`mX` has incorrect size");
 M = dnum[1];
 mX =  (double *)mxGetPr(prhs[3]);
 #ifdef INITIALIZE_INPUT_REQ_MATRICES
 	for (i=0;i<P*M;i++) mX[i] = 0.000000e+00;
 #endif

 /* optional input arguments */
 /* alpha */
 if(flag_alpha)
 {
 	if(mxGetNumberOfDimensions(prhs[4])!=2) mexErrMsgTxt("alpha must have 2 dimensions");
 if(mxGetClassID(prhs[4])!=mxDOUBLE_CLASS) mexErrMsgTxt("`alpha` must be stored in `mxDOUBLE_CLASS` format");
 	dnum = mxGetDimensions(prhs[4]);
 	if (dnum[0]!=1) mexErrMsgTxt("`alpha` has incorrect size");
 	if (dnum[1]!=M) mexErrMsgTxt("`alpha` has incorrect size");
 	alpha =  (double *)mxGetPr(prhs[4]);
 	#ifdef INITIALIZE_INPUT_OPT_MATRICES
 		for (i=0;i<1*M;i++) alpha[i] = 0.000000e+00;
 	#endif
 } else alpha = NULL;
 /* cX */
 if(flag_cX)
 {
 	if(mxGetNumberOfDimensions(prhs[5])!=3) mexErrMsgTxt("cX must have 3 dimensions");
 if(mxGetClassID(prhs[5])!=mxDOUBLE_CLASS) mexErrMsgTxt("`cX` must be stored in `mxDOUBLE_CLASS` format");
 	dnum = mxGetDimensions(prhs[5]);
 	if (dnum[0]!=P) mexErrMsgTxt("`cX` has incorrect size");
 	if (dnum[1]!=P) mexErrMsgTxt("`cX` has incorrect size");
 	if (dnum[2]!=M) mexErrMsgTxt("`cX` has incorrect size");
 	cX =  (double *)mxGetPr(prhs[5]);
 	#ifdef INITIALIZE_INPUT_OPT_MATRICES
 		for (i=0;i<P*P*M;i++) cX[i] = 0.000000e+00;
 	#endif
 } else cX = NULL;

 /*
 * 	check the dimensions of output arguments, and set output pointers
 */
 /* mY */
 dims[0] = D;
 dims[1] = M*K;
 plhs[0] = mxCreateNumericArray(2, dims, mxDOUBLE_CLASS, mxREAL);
 mY = (double *)mxGetPr(plhs[0]);
 #ifdef INITIALIZE_OUTPUT_REQ_MATRICES
 	for (i=0;i<D*M*K;i++) mY[i] = 0.000000e+00;
 #endif

 /* optional output arguments */


 /* input pointers:  X, Y, Kptr, mX  */
 /* output pointers:  mY  */
 /* call function `cvq_train`  */
/* changed by hannover */

cvq_train_hard(mY, X, Y, P, D, N, K, M, mX, SLBG_DEFAULT_DTHRES, SLBG_DEFAULT_MAXITER, CVQ_SETTINGS_DEFAULT);



}
