/* Jannis Agiomyrgiannakis and Andre Holzapfel */
/* Signal Processing Laboratory */
/* University of Crete, June 2006 */
/* Supervisor: Jannis Stylianou */
/* */
/* Enterface06, Multimodal Character Morphing Project */ 
/*#include "mex.h"*/
/*#include "math.h"*/
/*#include "matrix.h"*/

#include "cvq_lib.h"

#define MIN_IN_ARGNUM	2
#define MAX_IN_ARGNUM	3
#define MIN_OUT_ARGNUM	1
#define MAX_OUT_ARGNUM	14

/* #define INITIALIZE_INPUT_REQ_MATRICES */
/* #define INITIALIZE_INPUT_OPT_MATRICES */
/* #define INITIALIZE_OUTPUT_REQ_MATRICES */
/* #define INITIALIZE_OUTPUT_OPT_MATRICES */


void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
 /* setting up dimension declarations */
 int  P, N, nM;
 /* setting up int declarations */
 int  *MM;
 /* setting up double declarations */
 double  *X, *W, *C[MAX_OUT_ARGNUM];
 const int *dnum;
 int i, dims[16];

 /* declare the optional I/O flags */
 int flag_W=0;

 /* check the number of I/O arguments */
 if (nrhs < MIN_IN_ARGNUM || nrhs > MAX_IN_ARGNUM) mexErrMsgTxt("too many or too few input arguments.");
 if (nrhs>=MIN_IN_ARGNUM+1) flag_W=1; else flag_W=0;
 if (nlhs < MIN_OUT_ARGNUM || nlhs > MAX_OUT_ARGNUM) mexErrMsgTxt("too many or too few output arguments.");

 for(i=0;i<MAX_OUT_ARGNUM;i++) C[i] = NULL;
 /*
 * 	check the dimensions of input arguments, and set input pointers
 */
 /* X */
 if(mxGetNumberOfDimensions(prhs[0])!=2) mexErrMsgTxt("`X` must have 2 dimensions");
 if(mxGetClassID(prhs[0])!=mxDOUBLE_CLASS) mexErrMsgTxt("`X` must be stored in `mxDOUBLE_CLASS` format");
 dnum = mxGetDimensions(prhs[0]);
 P = dnum[0];
 N = dnum[1];
 X =  (double *)mxGetPr(prhs[0]);
 #ifdef INITIALIZE_INPUT_REQ_MATRICES
 	for (i=0;i<P*N;i++) X[i] = 0.000000e+00;
 #endif
 /* MM */
 if(mxGetNumberOfDimensions(prhs[1])!=2) mexErrMsgTxt("`MM` must have 2 dimensions");
 if(mxGetClassID(prhs[1])!=mxINT32_CLASS) mexErrMsgTxt("`MM` must be stored in `mxINT32_CLASS` format");
 dnum = mxGetDimensions(prhs[1]);
 if(dnum[0]!=1) mexErrMsgTxt("`MM` has incorrect size");
 nM = dnum[1];
 MM =  (int *)mxGetPr(prhs[1]);
 if(nM!=nlhs) mexErrMsgTxt("`MM` size must be equal to the number of the output arguments");
 for (i=0;i<nM;i++)
 {
 	if(MM[i]<=0 || MM[i]>16*1024 || power_of_2(MM[i])==0)
	{
		printf("MM[%d] = %d (%d)\n",i,MM[i],power_of_2(MM[i]));
		mexErrMsgTxt("`MM` contains integers which are no power of 2 or out of bounds");
	}
 }

 /* optional input arguments */
 /* W */
 if(flag_W)
 {
 	if(mxGetNumberOfDimensions(prhs[2])!=2) mexErrMsgTxt("W must have 2 dimensions");
 	if(mxGetClassID(prhs[2])!=mxDOUBLE_CLASS) mexErrMsgTxt("`W` must be stored in `mxDOUBLE_CLASS` format");
 	dnum = mxGetDimensions(prhs[2]);
 	if (dnum[0]!=1) mexErrMsgTxt("`W` has incorrect size");
 	if (dnum[1]!=N) mexErrMsgTxt("`W` has incorrect size");
 	W =  (double *)mxGetPr(prhs[2]);
 	#ifdef INITIALIZE_INPUT_OPT_MATRICES
 		for (i=0;i<1*N;i++) W[i] = 0.000000e+00;
 	#endif
 } else W = NULL;

 /*
 * 	check the dimensions of output arguments, and set output pointers
 */
 /* C */
 for(i=0;i<nM;i++)
 {
	dims[0] = P;
	dims[1] = MM[i];
	plhs[i] = mxCreateNumericArray(2, dims, mxDOUBLE_CLASS, mxREAL);
	C[i] = (double *)mxGetPr(plhs[i]);
 }
 /* optional output arguments */


 /* input pointers:  X, MM  */
 /* output pointers:  C  */
 /* call function `slbg`  */
 /*slbg(X, C, MM, nM, P, N, 1e-7, 50, SLBG_SETTINGS_VERBOSE | SLBG_SETTINGS_EIGEN_SPLIT, W);*/
 slbg(X, C, MM, nM, P, N, 1e-7, 50, SLBG_SETTINGS_VERBOSE | SLBG_SETTINGS_SIMPLE_SPLIT, W);
}
