function unit_sequence=viterbiselect(p,data)

% Partially based on code from the project: TTSBOX, a corpus-based speech
% synthesizer for Genglish. Copyright and license follows.
%
% Copyright (c) 2004 Faculte Polytechnique de Mons-Thierry Dutoit
%                    - Slovak Academy of Science - Milos Cernak
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation
% input:
% p: parameter structure, see CC4M_ParamInit.m
% data: (Dim x N*p.cvq_maps) matrix building the lattice
% output:
% indices of the columns in data used for the minimum weight path
% the weights are determined by using euclidean distance
%
% Alexis Moinet &
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project


% simply for testing purposes
w_mfcc = 1;
w_delta = 1;
w_ddelta = 1;
w_E = 1;
p = CC4M_ParamInit(p);
mfcc = data;


%Something is not logical here : we are doing weighted euclidian
%distances for the target and concatenation costs but here (and I guess
%during the clustering too) we are using simple euclidian distance ...
%it's easy to change this for the findlabels function but what about
%the clustering algorihm ???--Alexis
labels = ceil( (1:size(mfcc,2)) ./ p.cvq_maps);
nFrames = length(unique(labels));
step = length(labels)/nFrames;
if (rem(step,1)~=0)
    bla =1;
end


unit_lattice = zeros(p.cvq_maps, nFrames);
unit_sequence = zeros(nFrames,1);
I = zeros(p.cvq_maps,nFrames-1);

for i=1:nFrames
    if mod(i,25)==0
        i
        pause(0.001)
    end

    if (i>1) index_previous=index_current; end;

    % do partial viterbi
    % induction
    index_current = find(labels==labels((i-1)*step+1));
    overall_cost_upto_current_target = zeros(size(index_current));
    for u=1:length(index_current)
        if (i>1)
            frame2.mfcc = [0;mfcc(:,index_current(u))];
            overall_cost_partial = zeros(size(index_previous));
            for v=1:length(index_previous)
                frame1.mfcc = [0;mfcc(:,index_previous(v))];
                overall_cost_partial(v) = overall_cost_upto_previous_target(v) ...
                    + target_distance(frame1,frame2,p,'m',w_mfcc,w_delta,w_ddelta,w_E);%take target_distance()
            end;
            % find min and indices
            [value,index]=min(overall_cost_partial);
            overall_cost_upto_current_target(u)=value;% + tdist(u);
            I(u,i-1)=index;    % fill indice's matrix for backtracking
            clear overall_cost_partial;
        else
            overall_cost_upto_current_target(u)=0;%that is useless
        end;
    end;

    overall_cost_upto_previous_target=overall_cost_upto_current_target;
    unit_lattice(1:length(index_current),i)=index_current';
end;

%viterbi - backtracking
[value,index]=min(overall_cost_upto_current_target);
for i=nFrames:-1:2
    unit_sequence(i,1)=unit_lattice(index,i);
    index=I(index,i-1);
end;
unit_sequence(1,1)=unit_lattice(index,1);
