%script for calculating the fundamental frequency contours of a speech file
%the praat program is used for this.
%before using the script do:
% 1. ls PATHTOWAVFILES *.wav > files.txt
% 2. vim -es files.txt < changes.vim (use script provided, just deletes the
%   .wav endings) (...you can use whatever editor you like for this job.)
% 3. in praat: run the script lst2f0 and define the folders and settings,
% set the step parameter to the frame rate of the MFCC, and adjust the
% frequency range according if you have male or female speaker
% 4. then run this script...
% Finally you end up with the .Pitch files as stored by praat and the
% .PitchFine files in binary format, which contain for each frame of the
% according mfcc feature file a value for pitch, delta and deltadelta of the pitch. So the first third is pitch,
% the next deltas and so on...
%
%
%
%
% Andre Holzapfel
% Signal Processing Laboratory
% University of Crete, June 2006
% Supervisor: Jannis Stylianou
%
% Enterface06, Multimodal Character Morphing Project


function writePitchContour(DIR,p)
%DIR: where are the mfcc's...
%p: parameter structure

p = CC4M_ParamInit(p);%set parameters to standard values if not set
LIST_NAME = 'files.txt';

% Get directory structures for each target
D = dir(DIR);k=0;
for i=1:length(D)
    if(D(i).isdir & ~(D(i).name(1) == '.'))
	k=k+1;
	soundDir(k)=D(i);
    end
end
if(k>0)
    NumDatAllClass = 0;
    %for k targets
    for i=1:k
        ClassName{i} = fullfile( DIR, soundDir(i).name) ;
        fprintf('\nReading from disk: %s\n', ClassName{i});
        sfxfilename = fullfile( ClassName{i}, LIST_NAME );
        fileList = readsfxfiles(sfxfilename);
        for j=1:length(fileList)%read the mfcc features from the files
             AllList{i}.file{j}=fullfile(ClassName{i},fileList{j});
             open([AllList{i}.file{j} '_' num2str(p.winlength) '_' ...
                     num2str(p.overlap) '_' num2str(p.num_ceps_coeffs) '_' num2str(p.nrg) '_' num2str(p.use_deltas) '.mat']);
             mfcc = ans.mfcc;
             fp = fopen([AllList{i}.file{j} '.Pitch'],'rt');%read the praat files
             a = fscanf(fp,'%c');
             fclose(fp);
             position = findstr('candidate [1]',a);
             for m=1:length(position)
                pitch(m) = str2num(a(position(m)+43:position(m)+60));
             end
             pitch = [zeros(1,size(mfcc,2)-length(position)) pitch]%praat does not give results for the first few milliseconds so we have to fill with zeros
             deltapitch = deltas(pitch');%you need the delta function by Dan Ellis for that!
             deltadeltapitch = deltas(deltapitch);
             pitchfine = [pitch' deltapitch deltadeltapitch];
             fp = fopen([AllList{i}.file{j} '.PitchFine'],'wb');
             fwrite(fp,pitchfine,'float');
             fclose(fp);
        end
    end
end