#!/bin/bash

VIDEO_IN=$1;
AUDIO_S=$2;
AUDIO_T=$3;
AUDIO_C=$4;
TAG=$5;

mkdir -p .tmp 

echo "Converting two mono files to stereo files"

sox $AUDIO_S -c2 .tmp/source.wav;
sox $AUDIO_T -c2 .tmp/target.wav;
sox $AUDIO_C -c2 .tmp/converted.wav;

cd .tmp

sox source.wav out11.wav avg 1.0,0.0,0.0,0.0
sox source.wav out12.wav avg 0.0,1.0,0.0,0.0

sox target.wav out21.wav avg 1.0,0.0,0.0,0.0
sox target.wav out22.wav avg 0.0,1.0,0.0,0.0

sox converted.wav out31.wav avg 1.0,0.0,0.0,0.0
sox converted.wav out32.wav avg 0.0,1.0,0.0,0.0

#Source audio
soxmix out11.wav out12.wav out1.wav

#Target audio
soxmix out21.wav out22.wav out2.wav

#Converted audio
soxmix out31.wav out32.wav out3.wav

#Mixed audio S-T
soxmix out11.wav out22.wav out4.wav

#Mixed audio S-C
soxmix out11.wav out32.wav out5.wav

#Mixed audio T-C
soxmix out21.wav out32.wav out6.wav


for f in out?.wav; do
    g=${f/wav/ogg}
    echo "Creating $g file"
    oggenc -q10 -o$g $f
done

cd ..


DIR_OUT=${VIDEO_IN/.avi/}_${TAG}
mkdir -p ${DIR_OUT}
cp .tmp/out1.ogg ${DIR_OUT}/source.ogg
cp .tmp/out2.ogg ${DIR_OUT}/target.ogg
cp .tmp/out3.ogg ${DIR_OUT}/converted.ogg

VIDEO_OUT=${DIR_OUT}/${VIDEO_IN/.avi/};


echo "Merging audio & video: $VIDEO_OUT"
ogmmerge -o ${VIDEO_OUT}_Source.ogm -A $VIDEO_IN -c LANGUAGE=Source .tmp/out1.ogg 

ogmmerge -o ${VIDEO_OUT}_Target.ogm -A $VIDEO_IN -c LANGUAGE=Target .tmp/out2.ogg 

ogmmerge -o ${VIDEO_OUT}_Converted.ogm -A $VIDEO_IN -c LANGUAGE=Converted .tmp/out3.ogg 

ogmmerge -o ${VIDEO_OUT}_Mixed_S_T.ogm -A $VIDEO_IN -c LANGUAGE=Mixed_S_T .tmp/out4.ogg 

ogmmerge -o ${VIDEO_OUT}_Mixed_S_C.ogm -A $VIDEO_IN -c LANGUAGE=Mixed_S_C .tmp/out5.ogg 

ogmmerge -o ${VIDEO_OUT}_Mixed_T_C.ogm -A $VIDEO_IN -c LANGUAGE=Mixed_T_C .tmp/out6.ogg


rm -rf .tmp

echo "Done!"

